/* note to mike, if you decide to undo all your bad design decisions,
   do a keyword search on the phrase "dangerous_reference" */


/* $Id$ */

/*
 *  Mike S. and Camille F. 
 *  mds2@andrew camille@andrew
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* tag format is as follows, tags are 8 bits
   d    d    d    d    d    d    d    AorF
   discrete log of block size         allocated or free */

// #define DEBUG_MIKE
// DEBUG_MIKE should be renamed DEBUG_MALLOC
#define DEBUG_FREE

#define MAX(a,b) (a>b ? a : b)

#define MEM_SIZE ((size_t)dseg_hi+1 - (size_t)dseg_lo)

/* pass this a void *, and it tells you whether it points to a free block */
#define IS_FREE(x) (BLOCK_STATUS( (*((char *)x))) == FREE)

/* pass this a tag and it isolates the part corresponding to the log
   of the block size */
#define SIZE_PART(x) (x>>1L)

/* pass this a tag and it tells you the block size */
#define BLOCK_SIZE(x) (1L<<SIZE_PART(x))

/* pass this a tag and it tells you whether the block is allocated or free */
#define BLOCK_STATUS(x) (x & 1L)

/* d'uh */
#define FREE 0
#define ALLOC 1

/* gets the tag pointed to by x */
#define GET_TAG(x)  *((char *)x)

/* whether this is a valid block */
#define IS_BLOCK(ptr) (ptr &&  ((char *)ptr < (char *)dseg_hi) && (SIZE_PART(GET_TAG(ptr)) > 2 ))

/* sets the status of the block pointed to by ptr */
inline static void setBlockStatus(void * ptr, char status) {
  *((char *) ptr) &= ~((char) 1);
  *((char *) ptr) |= status & (char)1;
}

/* flips the status of the block pointed to by ptr */
#define FLIP_BLOCK_STATUS(x) *((char *)x) ^= (char)1


team_t team = {
    /* Team name to be displayed on webpage */
    "powerpuff girls <img src = "http://www.contrib.andrew.cmu.edu/usr/mds2/powerpuff.jpg>",
    /* First member full name */
    "Michael D Schuresko",
    /* First member email address */
    "mds2",
    /* Second member full name (leave blank if none) */
    "Camille Fournier",
    /* Second member email address (blank if none) */
    "camille"
};

/* last argument makes me tail recursive
 */
static unsigned long dlHelper(unsigned long X, unsigned long guess, 
			      unsigned long accum) {
  /* I am a helper function for discreteLog */
  if(X == 0L ) {
    return -1L;
  }
  if(X == 1L)
    return accum;
  if((X>>guess)) {
    return dlHelper(X>>guess, guess/2L,guess+accum);
  } else {
    return dlHelper(X, guess/2L,accum);
  }
}

/* not actually the discrete log, this holds the place of the 
   most significant bit
*/
static unsigned long int discreteLog(unsigned long int x) {
  return dlHelper((unsigned long)x,(unsigned long) 32L, 0L);
}

/* named after the clasic 80s doll for boys

   computes buddy of a block

   DAMN there is some mucky typecasting in here,
   luckily I should be able to keep it all the things that are
   64 bits on the alphas
*/
static void * myBuddy(void *ptr) { 
  size_t relPtr; /* ptr relative to dseg_lo */
  unsigned char logSize = *((char *)ptr); /* HERE is a dangerous_reference */
  logSize = SIZE_PART(logSize);
  relPtr = (char *)ptr - dseg_lo;
  // 2^logSize == size of this block
  if((relPtr>>logSize)&1L) { // if (relPtr / 2^logSize) is odd
    return ((char *)ptr - (1L<<logSize));
  } else {
    return ((char *)ptr + (1L<<logSize));
  }
}

static void eager_coallesce(void *ptr) {
  // pay _VERY_ careful attention to debugging / verifying this function
  void *bud = myBuddy(ptr);
  unsigned char budsize = *((char *)bud); // dangerous_reference
  unsigned char ptrsize = *((char *)ptr); 
  budsize = SIZE_PART(budsize);
  ptrsize = SIZE_PART(ptrsize);
  if(budsize == ptrsize && BLOCK_STATUS((*((char *)bud))) == FREE) {
    
    if(bud < ptr) {
      budsize += 1; /* since budsize is the log of the buddy's size
		       this actually is a multiply by two */
      budsize = budsize << 1L;
      *((char *)bud) = budsize;
      eager_coallesce(bud);
    } else {
      ptrsize += 1;  /* see above comment for "budsize += 1;" */
      ptrsize = ptrsize << 1L;
      *((char *)ptr) = ptrsize;
      eager_coallesce(ptr);
    } /* if(bud < ptr) else */
  } /* if buddy is free and the right size */
}


static void viewHeap(char *str) {

  char * s;
  fprintf(stdout,"############################################\n");
  if(str) fprintf(stdout, "heap at event \"%s\" is...\n",str);
  for(s = (char *)dseg_lo; s < (char *)dseg_hi; s += BLOCK_SIZE(GET_TAG(s))) {
    if(BLOCK_SIZE(GET_TAG(s)) <= 1) { 
      fprintf(stdout,"unused stuff at end, amounting to %lx bytes\n",
	      (unsigned long)( (char *)dseg_hi + 1 - s));
      break;
    }
    fprintf(stdout,"%s block of size %lx at %lx\n", (IS_FREE(s)?"FREE    ":
						     "ALLOCATED"),
	    BLOCK_SIZE(GET_TAG(s)), (unsigned long)s);
  }

}

static void debug_info(char * str) {
  //#ifdef DEBUG_MIKE
  fprintf(stdout,"dseg_lo is %lx, dseg_hi is %lx, MEM_SIZE is %lx\n",
	  (unsigned long)dseg_lo, (unsigned long)dseg_hi, 
	  (unsigned long)MEM_SIZE);
  if(str)
    fprintf(stdout,"message: \"%s\"\n",str);
  //#endif
}

int mm_init (void)
{
  /* this should make one big free block whose size is
   the largest power of two less than the memory size */
  


  /* so if someone hands me an empty heap, I make a big heap
     the typecase to a long int is cause size_t is unsigned,
     originally when dseg_hi was one less then dseg_lo this
     functions said "OK, I have ffffffffffffffff bytes in my heap
     guess I don't need to resize"
     and that was bad */
  /* HERE are two dangerous_references */
  if((long int)MEM_SIZE <= (long int)mem_pagesize()) {
    mem_sbrk(mem_pagesize());
   
    //    printf("mm_init increased heap by one page (%d)\n",mem_pagesize());
  }

  /* this sets the tag for the block starting at dseg_lo  
     the use of the #define is probably dangerous (dont you dare
     change GET_TAG to a function -- it will behvae completely differently)
     but it makes this easier to read */
  GET_TAG(dseg_lo) = (unsigned char)(discreteLog(MEM_SIZE) << 1L);
  if( (dseg_lo + (size_t)BLOCK_SIZE(GET_TAG(dseg_lo))) <= dseg_hi)
    *((char *) (dseg_lo + BLOCK_SIZE((long int)(*(char *)dseg_lo)))) = '\0';
  /* if there is stuff after the end of the first block (not big enough
     to make its own block) then set its tag to 0, indicating
     that its the end of the useful heap */


  return 0;
}



static void * nextBlock(void *ptr) {
  unsigned char blockMarker = *((unsigned char *) ptr);
  return ((void *)( (char *)ptr + BLOCK_SIZE(blockMarker)));
}

static void * nextBlockOfSize(void *ptr, size_t size) {
  unsigned char blockTag = GET_TAG(ptr);
  return ((void *)( (char *)ptr +MAX(size, BLOCK_SIZE(blockTag))));
}

static void * nextFreeBlock(void *ptr, size_t size) {
  void *tmpPtr = ptr;
  unsigned char blockMarker;

  long blockSize;
  do {
    tmpPtr = nextBlockOfSize(tmpPtr, size);
    if((char *)tmpPtr > dseg_hi) {
#ifdef DEBUG_MIKE
      fprintf(stdout,"this is where i be returnin NULL\n");
#endif
      return NULL; // may replace this with a call that expands the heap
    }
    blockMarker = *((unsigned char *) tmpPtr);
    blockSize = BLOCK_SIZE(blockMarker);
    if(blockSize <= 1) {
#ifdef DEBUG_MIKE
      fprintf(stdout,"here is where i be returnin NULL\n");
#endif
      return NULL; // went past last block
    }
   
  } while (BLOCK_STATUS(blockMarker) != FREE) ;
 
  
  return tmpPtr;
} 

// splits a block in two
static void splitBlock(void *ptr) {
  GET_TAG(ptr) = (SIZE_PART(GET_TAG(ptr)) -(char)1) << ((char)1);
  GET_TAG((ptr + (size_t)BLOCK_SIZE(GET_TAG(ptr)))) = 
    (SIZE_PART(GET_TAG(ptr)) ) << ((char)1);
}

// repeatedly apples splitBlock until I've reached the right size
static void splitToSize( void *ptr, size_t size) {
  unsigned char sizeCmp = discreteLog(size+8)+1;
  if(sizeCmp <= 3) return;
  sizeCmp = sizeCmp << 1;
  while(GET_TAG(ptr) > sizeCmp)
    splitBlock(ptr);
}

void *mm_malloc (size_t size)
{
  void * debugBlock; /* used for debugging only */
  void * endOfBlocks;
  void *tmpPtr = dseg_lo;
#ifdef DEBUG_MIKE
  fprintf(stdout,"allocating %lx bytes\n",(unsigned long)size);
  viewHeap("starting malloc");
  debug_info(NULL);
#endif
  
  if(BLOCK_STATUS( *((char *)tmpPtr)) != FREE) {
    tmpPtr = nextFreeBlock(tmpPtr, 1<<(discreteLog(size)+1));
  }
  while(tmpPtr != NULL && BLOCK_SIZE( *((char *)tmpPtr)) <= size+8) {
#ifdef DEBUG_MIKE
    fprintf(stdout,"%lx <= %lx\n", BLOCK_SIZE( *((char *)tmpPtr)), size+8);
#endif
    tmpPtr = nextFreeBlock(tmpPtr, 1<<(discreteLog(size)+1));
    
  }
  if(tmpPtr == NULL) {
#ifdef DEBUG_MIKE
    fprintf(stderr,"ran out of heap space\n");
#endif

    if(mem_sbrk(MEM_SIZE)) {
#ifdef DEBUG_MIKE
      viewHeap("changed heap size");
#endif
      /* set endOfBlocks here */
      for(endOfBlocks = tmpPtr = dseg_lo; IS_BLOCK(tmpPtr); 
	  tmpPtr = nextBlock(tmpPtr)) {
	debugBlock = endOfBlocks;
	endOfBlocks = tmpPtr;
      }
      /* ******************** */
      if(endOfBlocks == NULL) {
	fprintf(stderr,"thats really really bad\n");
      } else {
	endOfBlocks = (void *)((char *)endOfBlocks 
			       + BLOCK_SIZE( GET_TAG(endOfBlocks)));
     	GET_TAG(endOfBlocks) = discreteLog(MEM_SIZE/2) <<1;
#ifdef DEBUG_MIKE
	viewHeap("re-adjusted heap");
	debug_info("about to recurse in mm_malloc");
#endif
	return mm_malloc(size);
      }
    } else 
      return NULL;
  } // expand heap or return NULL
  if( BLOCK_STATUS( *((char *)tmpPtr)) != FREE) { 
    fprintf(stderr,"mm_malloc() nextFreeBlock() returned a non-free block\n");
    return NULL;
  }
  //  FLIP_BLOCK_STATUS(tmpPtr); 
  //  *((char *)tmpPtr) ^= (char)1;
#ifdef DEBUG_MIKE
  fprintf(stderr,"returning from mm_malloc properly, %lx \n", 
	  (unsigned long)tmpPtr);
#endif
  splitToSize(tmpPtr, size);
  FLIP_BLOCK_STATUS(tmpPtr);
#ifdef DEBUG_MIKE
  viewHeap("returning from malloc");
#endif
  return (tmpPtr+8);
}

void mm_free (void *ptr)
{
#ifdef DEBUG_FREE
  //  fprintf(stderr,"freeing a block\n");
#endif
  ptr = (void *) ((char *)ptr - 8);
  if( BLOCK_STATUS( *((char *)ptr)) != FREE) 
    *((char *)ptr) ^= (char) 1;
  // do some coallescing
  eager_coallesce(ptr);
}

