/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Whatever",
    /* First member full name */
    "Michael Jones",
    /* First member email address */
    "mj",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/***************
** Structures **
***************/

// Header.  The first few bytes in memory
struct header_t {
  struct flist_t *head;  // Link list of free spaces between memory
  caddr_t tail;          // Last memory used
};

// The link list.  Every node element is placed at an open memory space
struct flist_t {
  caddr_t end;           // The end of this free space
  struct flist_t *next, *prev;
};

#define HEADER ((struct header_t *)dseg_lo)
#define PS mem_pagesize()

/*
  Initialization:
  This program builds pointers to positions of the
  head of the link list and the very last point of used memory
*/
int mm_init (void)
{
  struct header_t *header = HEADER;
  if (!(mem_sbrk(PS+40))) return -1;
  header->head = NULL;
  header->tail = (dseg_lo + 16);
  return 0;
}

/*
  Allocation:
  Allocates space and updates the lists.
  Using the first fit strategy, finds an open space
  Also, allocates more heap space if it is necessary to do so.
*/
void *mm_malloc (size_t size) {
  struct header_t *header = HEADER;
  struct flist_t *flist   = header->head;
  long *addr;
  size_t allocsize;
  
  size = ((size >> 3) + 2) << 3;  // Aligning to 8 bytes (plus a little extra)
  for ( ; flist ; flist = flist->next) {  // looks for open space between
    if ((flist->end - (caddr_t)flist) >= size) { // other memory
      flist->end -= size;                 // if found, then the list is updated
      if ((flist->end - (caddr_t)flist) < 24) {
	if (flist->prev) flist->prev->next = flist->next;
	else header->head = flist->next;
	if (flist->next) flist->next->prev = flist->prev;	
      }
      addr = (long *)flist->end;
      *addr = size;                // the 8 bytes prior to the allocated space
      return (addr + 1);           // contain the allocated space
    }                              // this is used for free
  }

  if (dseg_hi - header->tail < size) {  // if no suitable memory was found
    allocsize = size - (size_t)dseg_hi + (size_t)header->tail; 
    allocsize = ((allocsize / PS) + 1) * PS; 
    if (!(mem_sbrk(allocsize))) return NULL; // allocate more heap space.
  }
  addr = (long *)header->tail;
  header->tail += size;
  *addr = size;
  return (addr + 1);
}

/*
  Free:
  Adds memory range to the free list, and updates list
*/
void mm_free (void *ptr) {
  struct header_t *header = HEADER;
  struct flist_t *flist = header->head;
  struct flist_t *new, *prev = flist;
  long *size;

  if ((long)ptr < 8) return;          // for 0 or negative memory
  size = ptr - 8;                     // the size is stored in ptr-8
  new = ptr - 8;                      // and this area can be freed too

  if ((caddr_t)new >= header->tail) return;  // out of bounds?
  if ((caddr_t)new + *size == header->tail) { // if this memory can be
    header->tail = (caddr_t)new;              // stuck to the tail...
    for (flist = header->head; flist; flist = flist->next) prev = flist;
    if (prev && (caddr_t)new == prev->end) {
      header->tail = (caddr_t)prev;
      if (prev->prev) prev->prev->next = prev->next;
      else header->head = prev->next;
      if (prev->next) prev->next->prev = prev->prev;
    }               // also, if any other memory can be connected to that 
    return;         // as a result of the free, connect it.
  }

  for(flist = header->head ; flist && flist < new; flist = flist->next) {
    prev = flist;
    if ((caddr_t)new == flist->end) { // looking for any place to connect.
      flist->end += *size;
      if (flist->next && flist->end == (caddr_t)flist->next) {
	flist->end = flist->next->end;
	flist->next = flist->next->next;
	if (flist->next) flist->next->prev = flist;
      }
      return;
    }
  }

  if (flist) {     // and for more places to connect
    if ((new >= flist) && ((caddr_t)new < flist->end)) return;
    if ((caddr_t)new + *size == (caddr_t)flist) {
      new->end = flist->end;
      new->next = flist->next;
      new->prev = flist->prev;
      if (flist->prev) flist->prev->next = new;
      else header->head = new;
      if (flist->next) flist->next->prev = new;
      return;
    }
    if (*size >= 24) {  // if it can't be connected, then just create
      new->end = (caddr_t)new + *size; // a new node, in order.
      new->next = flist;
      new->prev = flist->prev;
      if (flist->prev) flist->prev->next = new;
      else header->head = new;
      flist->prev = new;
      return;
    }
  }


  if (*size >= 24) {  // create a new node...
    new->end = (caddr_t)new + *size;
    new->next = NULL;
    new->prev = prev;
    if (prev) {
      prev->next = new;  // at the end
    }
    else header->head = new; // at the head (empty list)
  }
}
