/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Whatever",
    /* First member full name */
    "Michael Jones",
    /* First member email address */
    "mj",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

struct header_t {
  struct flist_t *head;
  caddr_t tail;
};

struct flist_t {
  caddr_t end;
  struct flist_t *next, *prev;
};

#define HEADER ((struct header_t *)dseg_lo)
#define PS mem_pagesize()

int mm_init (void)
{
  struct header_t *header = HEADER;
  if (!(mem_sbrk(PS))) return -1;
  header->head = NULL;
  header->tail = (dseg_lo + 16);

  return 0;
}

void *mm_malloc (size_t size) {
  struct header_t *header = HEADER;
  struct flist_t *flist   = header->head;
  long *addr;
  size_t allocsize;

  size = ((size / 8) + (size % 8 > 0) + 1) * 8;
  for ( ; flist ; flist = flist->next) {
    if ((flist->end - (caddr_t)flist) >= size) {
      flist->end -= size;
      if ((flist->end - (caddr_t)flist) < 24) {
	if (flist->prev) flist->prev->next = flist->next;
	else header->head = flist->next;
	if (flist->next) flist->next->prev = flist->prev;	
      }
      addr = (long *)flist->end;
      *addr = size;
      return (addr + 1);

    }
  }

  if (dseg_hi - header->tail < size) {
    allocsize = size - (size_t)dseg_hi + (size_t)header->tail;
    allocsize = ((allocsize / PS) + 1) * PS;
    if (!(mem_sbrk(allocsize))) return NULL;
  }
  addr = (long *)header->tail;
  header->tail += size;
  *addr = size;
  return (addr + 1);
}


void mm_free (void *ptr) {
  struct header_t *header = HEADER;
  struct flist_t *flist = header->head;
  struct flist_t *new, *prev = flist;
  long *size;

  if ((long)ptr < 8) return;
  size = ptr - 8;
  new = ptr - 8;

  if ((caddr_t)new >= header->tail) return;
  if ((caddr_t)new + *size == header->tail) {
    header->tail = (caddr_t)new;
    for(flist = header->head ; flist ; flist = flist->next) {
      if ((caddr_t)new == flist->end) {
	header->tail = (caddr_t)flist;
	if (flist->prev) flist->prev->next = flist->next;
	else header->head = flist->next;
	if (flist->next) flist->next->prev = flist->prev;
	return;
      }
    }
    return;
  }

  for(flist = header->head ; flist ; flist = flist->next) {
    prev = flist;
    if ((new >= flist) && ((caddr_t)new < flist->end)) return;
    if ((caddr_t)new == flist->end) {
      flist->end += *size;
      return;
    }
    if ((caddr_t)new + *size == (caddr_t)flist) {
      new->end = flist->end;
      new->next = flist->next;
      new->prev = flist->prev;
      if (flist->prev) flist->prev->next = new;
      else header->head = new;
      if (flist->next) flist->next->prev = new;
      return;
    }
  }

  if (*size >= 24) {
    new->end = (caddr_t)new + *size;
    new->next = NULL;
    new->prev = prev;
    if (prev) {
      prev->next = new;
    }
    else header->head = new;
  }
}
