/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Whatever",
    /* First member full name */
    "Michael Jones",
    /* First member email address */
    "mj",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

struct header_t {
  struct flist_t *head, *tail;
};

struct flist_t {
  caddr_t start, end;
  struct flist_t *prev, *next;
};

#define HEADER ((struct header_t *)dseg_lo)
#define PS mem_pagesize()

int mm_init (void)
{
  struct header_t *header = HEADER;
  struct flist_t *flist;
  if (!(mem_sbrk(mem_pagesize()))) return -1;
  header->head = header->tail = (struct flist_t *)(dseg_lo + 16);
  flist = header->head;
  flist->start = dseg_lo + 48;
  flist->end  = dseg_hi;
  flist->next = flist->prev = NULL;

  return 0;
}

void *mm_malloc (size_t size) {
  struct header_t *header = HEADER;
  struct flist_t *flist   = header->head;
  long *addr;
  size_t allocsize;

  size = (((size+1) / 8) + ((size + 1) % 8 > 0)) * 8;
  for ( ; flist; flist = flist->next) {
    if (flist->end - flist->start >= size) {
      addr = (long *)(flist->start);
      flist->start = flist->start + size;
      *addr = (long)size;
      //printf("1 - %d > %d ->1%x\n", flist->end - flist->start + size, size, addr + 1);
      return (addr + 1);
    }
  }
  
  if (header->tail->end == dseg_hi) {
    allocsize = size - (size_t)(header->tail->end) + (size_t)(header->tail->start);
    allocsize = ((allocsize / PS) + 1) * PS;
    if (!(mem_sbrk(allocsize))) return NULL;
    addr = (long *)header->tail->start;
    header->tail->start += size;
    header->tail->end    = dseg_hi;
    *addr = (long)size;
    //printf("2 - %d (1%x)->1%x\n", size, dseg_hi, addr+1);
    return (addr + 1);
  }
  //printf("3\n");
  return NULL;

}

void mm_free (void *ptr)
{
  struct header_t *header = HEADER;
  struct flist_t *flist = header->head;
  struct flist_t *new;
  long *size;
  
  if ((long)ptr < 8) return;

  size = ptr - 8;
  new->start = (caddr_t)ptr-8;
  new->end   = new->start + *size - 1;
  for ( ; flist; flist = flist->next) {
    if (new->start == flist->end + 1) {
      flist->end += *size;
      return;
    }
    if (new->end == flist->start - 1) {
      flist->start -= *size;
      return;
    }
  }
  //  printf("not done...\n");


}

/********************
** Other funcs.... **
********************/
/*
void resort_list(struct flist_t *addr) {
  struct flist_t *flist = HEADER->head;

  
}
*/
