/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define PAGESIZE 8192

team_t team = {
    /* Team name to be displayed on webpage */
    "<blink>Team Blink</blink><I>Final</I><br>No tricks, but I seem to <br>have opened the HTML can of worms <br>and can't put it away. <font color=\"#8822AA\">:)</FONT>",
    /* First member full name */
    "Michael Donohue",
    /* First member email address */
    "mdonohue",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};



// removes a free block from the linked list
void listremove(void ***loc)
{
  void **next = *(loc + 1);
  void **prev = *(loc + 2);
  if (next) { *(next + 2) = prev; } 
  if (prev) { *(prev + 1) = next; } else { *(long **)dseg_lo = (long *)next; }
}

// adds a free block to the head of the linked list
void listadd(void ***loc)
{
  void ***head = (void ***)dseg_lo;
  void **next = *head;
  *(loc + 1) = next;
  *(loc + 2) = 0;
  *(head) = (void *)loc;
  if (next) { *(next + 2) = (void *)loc; }
}

// initialize heap 
int mm_init (void)
{
  /* make allocated memory one big free block */
  /* leave first pointer to hold head of free block list */
    void ***begin = (void ***)dseg_lo + 1;
    void ***end = (void ***)((long)dseg_hi & -8);

    /* if no space allocated yet, allocate a page */
    if (end <= begin) {
      if (!(mem_sbrk(PAGESIZE))) return -1;
      end = (void ***)((long)dseg_hi & -8);
    }
    
    /* setup the free block */
    *begin = (void **)end + 1;
    *end = (void **)begin - 1;

    /* mask off low order bit (just in case) */
    *(long *)begin &= -2;
    *(long *)dseg_lo = 0;  

    /* add new block to free list */
    listadd((void *)begin);

    /* indicate success */
    return NULL;
}

// called by free.  takes a block that is marked free, and checks if it
// can be connected to the next or previous block
void connect(void ***loc)
{
  void ***begin = (void ***)((long)dseg_lo + 8);
  void **end = (void **)((long)dseg_hi & -8);
  void **beginseg, **endseg;
  
  /* Set beginning of free region.  
     Moves beginning back if previous region is also free */
  if (loc == begin || 
      *(long *)(loc - 1) & 1) { 
    beginseg = (void **)loc; }
  else {
    beginseg = *(loc - 1) + 1;
    listremove((void *)beginseg);
  }

  /* Set end of free region.
     Moves end back if previous region is also free */
  if (*loc == end + 1 || *(long *)*loc & 1) { endseg = *loc - 1; }
  else {
    endseg = (void **)**loc - 1;
    listremove((void *)*loc);
  }

  /* set implicit pointers to next and previous blocks */
  *beginseg = endseg + 1;
  *endseg = beginseg - 1;

  /* add free space to explicit list */
  listadd((void *)beginseg);
}

// adds a block.    loc is assumed free, and big enough to hold size
void *addblock(void ***loc, long size)
{
  void **olddest;  // keep track of end boundary
  
  listremove((void *)loc);
  olddest = (*loc);
  *loc = (void *)((long)loc + size);  // set pointers
  if ((olddest - *loc) < 4) { *loc = olddest; }  // leave room for headers
  if (*loc != olddest) { // if exact fit, don't make circles
    **loc = olddest;
    *(olddest - 1) = (*loc) - 1;
    listadd((void *)*loc); }
  *((*loc) - 1) = loc - 1; // set reverse pointer

  // mark as used
  (long)*((*loc) - 1) |= 1;
  (long)*loc |= 1;

  return loc;
}


// grow the size of the heap
// size is the requested block size that is unfillable
int growheap(long size)
{
  long needed;
  void ***newend;
  void ***end = (void ***)((long)dseg_hi & -8);

  if ( *(long *)end & 1 ) { needed = size; } else {
  needed = size - (((void **)end - *end) * 8) + 8; }
 
  //  needed = (needed + (PAGESIZE - 1)) / PAGESIZE * PAGESIZE;

  if (!mem_sbrk(needed)) return NULL;
  newend = (void ***)((long)dseg_hi & -8);

  /* check if there is a free tail, to attach new space to */
  if ( *(long *)end & 1 ) { 
    *newend = (void **)end; 
    *(end + 1) = (void **)(newend + 1); 
    listadd((void *)(end + 1));}
  else {
    listremove((void *)(*end + 1));
    *newend = *end; 
    *((*end) + 1) = newend + 1; 
    listadd((void *)(*end + 1));}

  /* operation completed successfully */
  return 1;
}

  

void *mm_malloc (size_t size)
{
  void ***P;
  void ***end;
  void ***best;
  long best_length;

  /* force size to be a multiple of 8, and add 2 words for header */
  if (size == 0) { return NULL; } else
    { size = (size + 23) / 8 * 8; }

  /* loop.  increments memory as needed */
  do {
    end = (void ***)((long)dseg_hi & -8);
    P = *(void **)dseg_lo;
    best_length = (1L << 63) ^ -1; // set best_length to something unattainable

    /* loop.  look for best fit block */
    do {

      /* main loop which traverses free blocks */
      while((P != 0) && (((long)*P & -8)-(long)P < size)) {
	(long)P = (long)*(P + 1);}

      /* check if loop exited because of lack of memory, or good fit */
      if (P != 0) {
	if (((long)*P & -8)-((long)P & -8) < best_length) {
	  best = P;
	  best_length = ((long)*P & -8) - ((long)P & -8);
	  if (best_length == size) {
	    addblock(best, size);
	    return best + 1;
	  }
	}
	(long)P = (long)*(P + 1);
      }
    } while(P != 0);
    if (best_length != ((1L << 63) ^ -1)) {
      addblock(best, size);
      return best + 1;
    }
  } while (growheap(size));
  
  return NULL;
}

void mm_free (void *ptr)
{
  void *loc=(ptr - 8);
  
  /* mark block as free, and coalesce, and add to free list */
  *(long *)loc &= -8;
  *(long *)((*(void **)loc) - 8) &= -8;
  connect(loc);
}

