/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Mr. T",
    /* First member full name */
    "Ljubomir Cvetkovic",
    /* First member email address */
    "ljbomir",
    /* Second member full name (leave blank if none) */
    "John Kowalski",
    /* Second member email address (blank if none) */
    "jkau"
};
/* we implemented the first-fit bidirectional implicit list */

int mm_init (void)
{
  void *ptr = NULL;
  long *lower;
  long *higher;
  long size = mem_pagesize();
  ptr = mem_sbrk(size);
  lower = (long*)dseg_lo;
  higher= (long*)dseg_hi;
  *lower = size << 1L;
  *higher = size << 1L;

  if (ptr == NULL)
    return -1;    /* indicate the problem with allocation */
  else
    return 0;     /* allocation OK */
}

void *mm_malloc (size_t size)
{

  long real_size;
  long *stepper = (long*)dseg_lo;
  long *lower = (long*)dseg_lo;
  long *higher = (long*)dseg_hi;
  long counter;      /* variable that holds the current available block size*/    
  printf("lower = %ld\n", *lower >> 1L);
  printf("lower = %ld\n", lower);
  printf("higher = %ld\n", *higher >> 1L);
  printf("higher = %ld\n", higher);
  printf("size is %d\n", size);

  if (size % 8L == 0)
    real_size = (long)size;
  else if (size < 8L)
    real_size =  8L;
  else real_size = ((long)size) - ((long)size % 8L) + 8L;
  real_size = (real_size / 8L) + 2L;
  printf("real size is %d\n", real_size);

  /* while there is space in the heap look for free blocks of sufficient size */
  while (stepper < higher){ 
    /* if the block is free and big enough */
    if (!(*stepper & 1L) && (real_size <= ((*stepper) >> 1L))){   
	counter = *stepper >> 1L;
	*stepper = ((real_size) << 1L) | 1L;   /* set the size on block's bottom */
	*(stepper + real_size -1L) = ((real_size) << 1L) | 1L;/*indicate size on block's top*/
	*(stepper + real_size) = (counter - real_size) << 1L; /*set the next block*/
	*(stepper + real_size + counter) = (counter - real_size) << 1L;
	return (void *) stepper;
    }
    else stepper = stepper + (*stepper >> 1L);  /* look for the next block*/
  /* alocate new page in the heap */
    if (stepper == higher){
      if (!(mem_sbrk(mem_pagesize()))){           /*if not enough space return NULL */        
	printf("There is not enough space\n");
	return (void *) NULL;
      }
      else if (*stepper & 1L){                /*if the top block is used just put a new page */
	higher = (long*)dseg_hi;
	stepper  = stepper + 1L;              /* on top of the heap */  
	*stepper = (long)mem_pagesize() << 1L;
	*higher = (long)mem_pagesize() << 1L;
      }else{
	higher = (long*)dseg_hi;
	stepper  = stepper - (*stepper >> 1L);  /* if the last block is free put the new page on top */
	*stepper = (mem_pagesize() + (*stepper >> 1L)) << 1L;  /* of the heap and coalesce with last block */
	*higher = *stepper;
      }
    } 
  }
}

void mm_free (void *ptr)
{
  long *stepper;
  long *pointer = (long*)ptr;
  printf("HELLO HHHHHHHHHHHHHHHHHHHHHHH");

  /* if we are at the bottom of the heap just check if block above is free to coalesce*/
  if (pointer == (long*)dseg_lo){
    stepper = pointer + (*pointer >> 1);
    if (!(*stepper & 1)){
      *pointer = ((*pointer >> 1) + (*stepper >> 1)) << 1;
      *(stepper + (*stepper >> 1) - 1) = *pointer;
    }else{
      *pointer = *pointer & -2;
      *(pointer + (*pointer >> 1) -1) = *pointer;
    }
    /* if we are at the top block of the heap check if one beneath it is free */
  }else if ((pointer + (*pointer >> 1) -1) == (long*)dseg_hi){
    stepper = pointer - 1;
    if (!(*stepper & 1)){
      *(stepper - (*stepper >> 1) + 1) = ((*pointer >> 1) + (*stepper >> 1)) << 1;
      *(pointer + (*pointer >> 1) -1) = *(stepper - (*stepper >> 1) + 1);
    }else{
      *pointer = *pointer & -2;
      *(pointer + (*pointer >> 1) -1) = *pointer;
    }
  /* otherwise check blocks above and beneith if they are free */
  }else{
    stepper = pointer - 1;
    if (!(*stepper & 1)){
      *(stepper - (*stepper >> 1) + 1) = ((*pointer >> 1) + (*stepper >> 1)) << 1;
      *(pointer + (*pointer >> 1) -1) = *(stepper - (*stepper >> 1) + 1);
      pointer = stepper - (*stepper >> 1) + 1;
    }
    stepper = pointer + (*pointer >> 1);
    if (!(*stepper & 1)){
      *pointer = ((*pointer >> 1) + (*stepper >> 1)) << 1;
      *(stepper + (*stepper >> 1) - 1) = *pointer;
    }
    *pointer = *pointer & -2;
    *(pointer + (*pointer >> 1) -1) = *pointer;
  }
  return;
}

