 /* $Id$ */

/*
 * Guido Zarrella
 * Elena Balestreire
 * 3-10-99
 *
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "wicked cool",
    /* First member full name */
    "Jeff Zarrella",
    /* First member email address */
    "jmz",
    /* Second member full name (leave blank if none) */
    "Elena Balestreire",
    /* Second member email address (blank if none) */
    "emb"
};

/*

Dear Grader,

This program was a terrible experience for us, and any consideration you will give us is greatly appreciated.  We would actually appreciate talking to you about our code.;  we had some major problems with our code until the TA actually spent some time with us.  unfortunately that was at 10PM tonight, and we were unable to make the changes that we wanted to be able to make.

First I'd like to explain the problem we've had with this program.  We wrote the code carefully and were able to pass correction tests for the 5 tracefiles that we tested it on.  It not only passed the correction test, it proceeded to pass the test for time.  ALthough we weren't thrilled with our results, we were hoping to make the algorithm more efficient after we had 100% completion of the test program, ie the following situation.  Upon the third run through a testfile, the programs seg-faulted.  They always waited for the third test.  We were baffled because we were under the understanding that the heap was re-initialized to 0 every time one of the tests were called.  We contacted all of the TA's about the problem and received feedback from 2 ta's merely saying to use gdb to find the seg fault.  This wasn't as easy as it sounded considering we needed to step through thousands of loop calls just to understand how the seg fault occured.  <we never really did, and were told not to worry about the details of it, since other problems in our code were more pressing>

Needless to say the many hours we spent on first developing the program, revising it to pass the correction tests, and then searching for the obscure cause of our seg fault were very aggravating.  At one point we took 3 minutes to write the simple version of malloc that is terrible "space-wise" but very simple and timely, and this poor algorithm scored far better than our struggling strategy

We decided to submit the following code because it gives an idea of the thoughts we were working towards when we decided that there was no way to finish tonight, particularly when our feedback came at 10PM and all of the ece computers are running so slow since everyone is playing with memory.

Like we said, we would really appreciate your feedback and advise as to either why our program behaves as it does, or what adaptations could be made to fix it.

Here is a brief explanation of our code and algorithm, as it is currently implemented.

 INITIALIZATION

 Initialization first allocates memory for the heap.  It creates the header that consists of an int size followed by an int flag, which stores the value 0 if the block is unallocated and 1 if the block is allocated.  Hence, the header is 8 bytes long, which is consistent with 8-byte alignment.

 MALLOC

 Malloc's main while loop controls finding an adequate chunk.  It checks its location and whether it will fit with the size added, and also checks whether the particular chunk is large enough and when it is already allocated.  The first step ideally is to assure your'e not out of bounds, and if you are, to add the proper size to the end of the heap.  Unfortunately the current working version is not very compatible here, and this we feel is the main source of our problems.  The next step is to assure that the "chunk" you're looking at is free and availble to be malloc'd (according to the header).  Optimally we would like to coalesce in malloc to make our free more optimal.  If it's not free, (else) covers when we need to sbrk for the entire chunk of "size".  All of the sbrk calls account for 8-byte alignment.  The third case is that we just want to increment the walk pointer to the next block (to be checked by the while loop.)
When while finally finds an allocatable block, it allocates - first checking whether the "chunk" is the exact size, or if it's a little big, it first makes the header for the unallocated region, and then allocates for the region to be filled (marking the header likewise).


 FREE

 free sets the header int to indicate the region is now empty.  right now we have coalesce running in free.  it runs through the entire heap, checking the current and next chunk to see if they're both free (indicated by header).  if so, the function combines the chunks and updates the header size.  again, this is a poor algorithm but we were more concerned with correctness before making the changes to free (like not coalescing every time, or not coalescing the entire list at once).

Sincerely,
Elena Balestreire & Guido Jeff Zarrella


*/
int mm_init (void)
{
  int *walk = (int *)dseg_lo;
  mem_sbrk(16);
  *walk = (int)(dseg_hi - dseg_lo) + 1;
  *(walk+1) = 0;
  return 0;
}

void *mm_malloc (size_t size)
{
  int *walk = (int *)dseg_lo;

   /* while we're still in our bounds & this chunk isn't big enough or it's already allocated */
  while ((walk + size/4 +2 >= dseg_hi) || (*walk - 8 < size) || (*(walk+1) == 1)){
    /* see if there is not enough room already*/

    /*if you're out of bounds, you allocate the size at the end of the heap*/
    /*
     *    if(walk >= dseg_hi){  
     *      printf("walk: %d, hi: %d \n",walk, dseg_hi);
     *      walk = dseg_hi;
     *      if(((int)walk+8+size)%8 !=0){  
     *	printf("%d\n", ((size + 8)+(8-((int)walk+ size+8)%8)));
     *	if (mem_sbrk((size + 8)+(8-((int)walk+ size+8)%8)) == NULL) 	
     *	  return NULL; 	  
     *      }  
     *      else{ 
     *	if (mem_sbrk(size + 8) == NULL)  
     *	  return NULL; 	  
     *       } 
     *     } 
    */

    /* do if the current space is free or if we're at the end of the heap */    
    if (((*(walk+1) == 0)) || (*walk == 0)) {
      /* if we still have some space that can be used, sbrk remaining space needed */	 
      if( *(walk+1+ *walk/4) == 0){ 
	if (mem_sbrk((size + 8 - *walk)+(8-(size+8-*walk)%8)) == NULL)
	  return NULL; 
	/*coalesce here is an option but did not seem to make our running times faster...*/
	*walk = size + 8 + (8-(size+8-*walk)%8); 
	break;
       }  

      /* need to sbrk for the entire chunk+header size */
      else{ 
	/*going to the end of the heap, check to see if %8 aligned; if not aligned, add little space header indicating full, unaligned... and fill to %8 */
	
	 if( mem_sbrk(8+size+(8-(size+8)%8)) == NULL)
	   return NULL;
	  /* create header for the amount we just sbrk'd */
	  *walk += (8+size + (8-(size+8)%8));
	  *(walk + *walk/4) = 0;
      }
    }
    else{
      /* increment pointer to start of next block's header, which is (header size + block size) away */

      /* this check helps us isolate what causes the seg fault - for some reason in the third test (speed) of our file, walk gets way ahead of d-seg hi due to an irregular, inexplainably large value for *walk - see for yourself with the following debugging test :
      if (walk > 0x141400000)  
      printf("1  *walk %d\n", *walk);   */

      walk += (int)*walk/4;
 
    }
  }
  /*check to see if you have an unexact fit */
  if(size != *walk - 8){
    /*    take care of unallocated segment */
    *(walk + 2 + size/4) = (*walk - size - 8);   
    *((char*)walk + 8 + size + 2) = 0; 
  }
  *(walk + 1) = 1;
  return walk+2;
}


void mm_free (void *ptr)
{
  int *walk = (int *)dseg_lo;

  /* set this region to free space region - set to 0*/
  *((int*)ptr + 1) = 0;

  /* COALESCE 
   one of the options that we tested consisted of free simply freeing the space, and coalescing only during malloc before you search for the proper fit space */
  while ( walk < dseg_hi ){  
    /* if the current and the next block are both free, COALESCE THEM! */
    if( (*(walk+1) == 0) && (*(walk + *walk + 1)==0) ){
      *walk +=  *(walk + *walk);
    }
    /* advance to the next block and check for coalesce */
    else
      walk += *walk/4;
  } 
}



