/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Battle Noids",
    /* First member full name */
    "John Stultz",
    /* First member email address */
    "jstultz",
    /* Second member full name (leave blank if none) */
    "Lydia Choy",
    /* Second member email address (blank if none) */
    "lpc"
};



/*
  General Notes:
  --------------
  Linked list of free blocks (32 byte table) 
  First fit allocation
  Coalescing in Free

 */



/* stores information of next and prev memory blocks*/
struct Table 
{
  struct Table* prev;     /* previous memory block      */
  struct Table* next;     /* next memory block          */
  unsigned int  prevsize;        /* size of previous mem block */
  unsigned int  size;             /* size of the current block  */
  unsigned int  used;             /* 1 if used, 0 if free       */
};

/*  table size  */
const int TBLSIZE = 32;

int mm_init (void)
{

  ulong* listptr;                    /* pointer to head  */
  struct Table*  firstblock;         /* first free block */


  /* allocate a chunk */
  mem_sbrk(TBLSIZE);
  
  /* init the listptr */
  listptr = (ulong*)dseg_lo;
  *listptr = listptr+1;

  /* init the first block */
  firstblock = (struct Table*)*listptr;
  firstblock->prevsize = 0;
  firstblock->prev = NULL;
  firstblock->next = NULL;
  firstblock->size = (ulong)dseg_hi - (ulong)firstblock+1;
  firstblock->used = 0;

  return 0;
}

void *mm_malloc (size_t size)
{
  struct Table* current;   /* current free block   */
  struct Table* ret;       /* block returned       */
  ulong* listptr;          /* initial head pointer */
  ulong pgsize;            /* the page size        */

  /* adjust desired size to a multiple of 8 */
  size = size + 8 - (size%8);

  /* get head pointer */
  listptr = (ulong*)dseg_lo;

  /* get first block */
  current = (struct Table*)*listptr;
 
  /* find block with enough space */
  while(current->next != NULL &&  current->size < size)
    current = current->next;

  /* if at end of list */
  if (current->next == NULL)
  {
    while (current->size < size  +TBLSIZE)
    {
      /* increment space if needed */
      mem_sbrk(size - current->size +TBLSIZE);	
      current->size = (ulong)dseg_hi - (ulong)(current+1);
    }
  }

  /* decide if its worth splitting the block */
  if (current->size > (size + TBLSIZE) || current->next ==NULL)
  {
    /* split block */
    ret = current;

    /* move current up to block */
    current = (ulong)(current+1) + size;
    /* copy table data */
    current->next = ret->next;
    current->prev = ret->prev;
    current->used = 0;
    /* current size */
    current->size = ret->size - size - TBLSIZE;
    /* set previous size */
    current->prevsize = size;
    
    /* fix previous pointers */
    if (ret->prev == NULL)
      *listptr = (ulong)current;
    else
      ret->prev->next = current;

    /* fix next ptrs */
    if (ret->next != NULL)
    {
      ret->next->prev = current;
      ((struct Table*)((ulong)(current+1) + current->size))->prevsize = current->size;
    }

    /* set used */
    ret->used = 1;
    /* set size */
    ret->size = size;

    return ret+1;
  }
  else    /* do not split block */
  {
    /* set block as used */
    current->used = 1;

    /* remove current from free list */
    current->next->prev = current->prev;
    if (current->prev != NULL)
      current->prev->next = current->next;
    else
      *listptr = current->next;

    /* return current pointer of allocated block */
    return current+1;
  }

  return NULL;
}

void mm_free (void *ptr)
{ 
  struct Table* free;
  ulong* listptr;
  struct Table * chkprev;
  struct Table * chknext;
  ulong* chk;

  /* init free tbl */
  listptr = (ulong*)dseg_lo;
  free = (struct Table*)ptr;
  free--;

  /*get next physical block*/
  chk = (ulong*) (ptr);
  chk = ((ulong)chk + free->size);
  chknext = (struct Table*)chk;

  /*get prev physical block*/
  chk = (ulong*)(free);
  chk = (ulong)chk -  free->prevsize;
  chkprev = (struct Table*)chk;
  chkprev = chkprev-1;


  /* coalesce previous block */
  if ( chkprev->used == 0 && chkprev > listptr) 
  {
    /* set size */
     chkprev->size += free->size + TBLSIZE;

     /*also coalesce next block if possible*/
     if (chknext->used ==0)
     {
       /*re adjust size */
        chkprev->size += chknext->size + TBLSIZE;

	/*correct ptrs*/
        if (chkprev->prev != NULL)
           chkprev->prev->next = chkprev->next;
        else
           *listptr = chkprev->next;

        chkprev->next->prev = chkprev->prev;

        if (chknext->prev != NULL)
           chknext->prev->next = chkprev;
        else 
           *listptr = chkprev;

        chkprev->next = chknext->next;
        chkprev->prev = chknext->prev;
	
	/*set next's prevsize */
        if (chknext->next != NULL)
        {
           chknext->next->prev = chkprev;
           chknext = (ulong)(chknext+1)+chknext->size;
           chknext->prevsize = chkprev->size;
	}

     }
     else
        chknext->prevsize = chkprev->size;
  }
  /*coalesce next block */
  else if (chknext->used ==0)
  {
    /*mark free */
    free->used = 0;
    free->size = free->size + chknext->size +TBLSIZE;
    
    /*fix ptrs*/
    free->prev = chknext->prev;
    free->next = chknext->next;
    
    if (chknext->prev !=NULL)
      chknext->prev->next = free;
    else
      *listptr = free;
    
    /*set nexts prevsize */
    if (chknext->next != NULL)
      {
        chknext->next->prev = free;

        chk = (ulong*)ptr ;// (free+1);
        chk = ((ulong)chk + free->size);
        chknext = (struct Table*)chk;
        chknext->prevsize = free->size;
     }
    }


  /*just free block and add to front of list*/
  else
  {
     free->used = 0;
     free->prev = NULL;
     free->next = (struct Table*)*listptr;
     free->next->prev = free;
     *listptr = free;
  }
}
