/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* free block : */
typedef struct {
	long size;
} fblock;

/* allocated block : just contains the sizes */
typedef struct {
	long size;
} ablock;

typedef struct { /* Structure for roving pointer. */
  void *nfree;
} head;

#define TAG_SIZE 16
/* This is the size of the header and footer lengths. */

team_t team = {
    /* Team name to be displayed on webpage */
    "Call me Guy, Jerry.",
    /* First member full name */
    "James 'Flug des Kondors!' Sanders",
    /* First member email address */
    "jsanders",
    /* Second member full name (leave blank if none) */
    "Thomas 'the Anonymous' Drake",
    /* Second member email address (blank if none) */
    "drakejr"
};

/* GENERAL COMMENTS:  We used a first-fit algorithm with a roving pointer
   to the first free block that is available.  We made an implicit listing
   using sizes.  Basically, it will search through all memory looking for
   a free space.  It just checks the LSB of the size block to find out if
   the block is allocated or not. */


/* Takes a normal size and turns it into a size block plus allocation bit. */
long make_size(long s, long alloc) {

  if(alloc)
    return (s << 1L) | 1L;
  else
    return (s << 1L) & -2L;

}

/* Given a size block it shifts the allocation bit away and returns the proper
   size. */
long get_size(long s) {

  return (s >> 1L) & ~(1L << 63L);

}


/* Given a starting free block and a size, it turns that into a free 
   block with the stucture:

    ---------------------------
   |    | free space      |    |
   |size| of size 'size'* |size|
    ---------------------------
    ^         ^              ^
 8 bytes    size bytes    8 bytes

Total size: (size + 16) bytes

The header and footer size byte blocks are also encoded with a 1 in the
LSB to signify the block as being unallocated.  *Also, the requested size
of the block converted so it is aligned by 8.

Returns: the address of the header size block.

*/

fblock *make_free_block(fblock *p, long size) {

  fblock *tmp;

  ((fblock*)p)->size = make_size(size+TAG_SIZE, 0);
  tmp = (fblock*)((char*)p + (size+8));
  tmp->size = make_size(size+TAG_SIZE, 0);

  return (void*)p;
}  

/* Given a starting free block and a size, it turns that into an allocated 
   block with the stucture:

    ---------------------------
   |    | allocated space |    |
   |size| of size 'size'* |size|
    ---------------------------
    ^         ^              ^
 8 bytes    size bytes    8 bytes

Total size: (size + 16) bytes

The header and footer size byte blocks are also encoded with a 1 in the
LSB to signify the block as being allocated.  *Also, the requested size
of the block converted so it is aligned by 8.

Returns: the address of the byte immediately after the size block.

*/

ablock *make_allocated_block(fblock *p, long size) {

  ablock *tmp;

  ((ablock*)p)->size = make_size(size+TAG_SIZE, 1);
  tmp = (ablock*)((char*)p + (size+8));
  tmp->size = make_size(size+TAG_SIZE, 1);

  return ((void*)p + sizeof(ablock*));
}

/*  Aligns a size to 8 bytes. */
long align8(long size) {
  
  long s = 7L;

  /* fix alignment */
  s = (~(s & size) + 1) & s;
  size = size + s;
  
  return size;
}

/* Send this function a free block and the 8-aligned size of the block you
   want to allocate within it. It then splits the block accordingly and
   returns the address of allocated (after the size header). */

ablock *split_block(fblock *f, long a_size) {

  long f_size, new_size, tsize;
  fblock *ftmp;
  ablock *atmp;

  tsize = a_size;
  f_size = get_size(f->size);
  new_size = f_size - (tsize + TAG_SIZE);
  if(new_size <= TAG_SIZE) {
    tsize = tsize + new_size;
  }
  atmp = make_allocated_block(f, tsize);
  if(new_size > TAG_SIZE) {
    ftmp = make_free_block((fblock*)((char*)f + a_size + TAG_SIZE), new_size - TAG_SIZE);
    if((void*)f == (void*)((head*)dseg_lo)->nfree)
      ((head*)dseg_lo)->nfree = ftmp;
  }
  return atmp;

}


/* This function, given a free block, looks ahead one block and back one
   block to see if those are free.  It coalesces with the free blocks and
   returns the appropriate address, depending on what was coalesced. 
   The code variable is as follows: 0 is a normal coalesce, 1 is coalescing
   when a new page of memory is added.
*/

fblock *coalesce_block(fblock *f, long code) {

  long f_size;
  fblock *tmp;
  long s = 7L;

  if(!code) { /* Normal coalescing routine. */
    tmp = (fblock*)((char*)f + get_size(f->size)); /* Go to the next block. */
    if((void*)tmp < (void*)dseg_hi) {
      if(!(tmp->size & 1L)) { /* Check if free. */
	f = make_free_block(f, get_size(f->size) + get_size(tmp->size) - TAG_SIZE);
      }
    }
    if((void*)f > (void*)((char*)dseg_lo+8)) {
      tmp = (fblock*)((char*)f - 8);
      tmp = (fblock*)((char*)tmp - get_size(tmp->size) + 8); /* Go to previous block. */
      if(!(tmp->size & 1L)) { /* Check if free. */
	f = make_free_block(tmp, get_size(f->size) + get_size(tmp->size) - TAG_SIZE);
      }
    }
    tmp = f;
  }
  else { /* Special routine, adding new pages. */
    f_size = (long)((void*)dseg_hi - (void*)f) - TAG_SIZE;
    /* f_size = align8((long)((void*)dseg_hi - (void*)f) - TAG_SIZE); */
    s = (~(s & f_size) + 1) & s;
    f_size = f_size + s;
    
    tmp = make_free_block(f,f_size);
  }
  
  return tmp;
}

int mm_init (void)
{
  fblock *root;
  long root_size;
  head *start;
  long s = 7L;
  
  if( mem_sbrk(mem_pagesize()) == NULL)
    return -1;
  
  start = (head*)dseg_lo; /* This is where I keep a pointer to the first
			     free block. */
  root = (fblock*)(dseg_lo+8);
  
  /* Align in 8 bytes. */
  root_size = (long)((void*)dseg_hi - (void*)root) - TAG_SIZE;
  s = (~(s & root_size) + 1) & s;
  root_size = root_size + s;
  
  make_free_block(root,root_size);
  start->nfree = root;
  
  return 0; /* IT WORKS!!! In theory. */
}

void *mm_malloc (size_t size)
{
  fblock *p;
  ablock *tmp;
  long block_size;
  long foundfree = 0L;
  long moremem = 0L;
  long s = 7L;

  p = (fblock*)((head*)dseg_lo)->nfree;
  /* Align by 8 bytes. */
  s = (~(s & size) + 1) & s;
  size = size + s;
  
  /*size = align8(size);*/ /* Removed to get rid of overhead. */
  
  while(!foundfree) { /* Looking for an appropriate free block. */
    
    if((void*)p > (void*)dseg_hi) { /* We overstepped the boundary, need more memory. */
      moremem = 1L;
      foundfree = 1L;
    }
    
    if(!moremem) {
      block_size = get_size((long)p->size);
      
      if(p->size & 1L)  /* Allocated block, move on. */
	p = (fblock*)((char*)p + get_size(p->size));
      else {
	if(block_size >= (size+TAG_SIZE))  /* Possible candidate. */
	  foundfree = 1L;  /* Was the right size. */
	else {
	  if( (void*)((char*)p + get_size(p->size)) < (void*)dseg_hi ) 
	    p = (fblock*)((char*)p + get_size(p->size)); /* Too small and in bounds, move on. */
	  else {
	    foundfree = 1L;
	    moremem = 1L;
	  }
	}
      }
      
    }
  }

  if(moremem) { /* If more memory is needed, make it. */
    while( ((char*)p + (size+TAG_SIZE)) >= dseg_hi) {
      if( mem_sbrk(mem_pagesize()) == NULL)
	return NULL;
    }
    p = coalesce_block(p, 1);
  }
  
  tmp = split_block(p, size);
  
  return (void*)tmp;
}

void mm_free (void *ptr)
{

  ablock *p = (ablock*)((char*)ptr - 8);
  fblock *tmp;

  if(p->size & 1L) {
    tmp = make_free_block((fblock*)p, get_size(p->size) - TAG_SIZE);
    tmp = coalesce_block((fblock*)tmp, 0);
    if((void*)tmp < (void*)((head*)dseg_lo)->nfree)
      ((head*)dseg_lo)->nfree = tmp;
  }

}

