/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Bacon",
    /* First member full name */
    "Jarrod A. Roy",
    /* First member email address */
    "jroy",
    /* Second member full name (leave blank if none) */
    "Andrew P. Begun",
    /* Second member email address (blank if none) */
    "apb"
};


/*             Summary of Algorithm Used             */
/*                                                   */
/*  Basic algorithm is a first fit, lazy coalescing  */
/*  algorithm. The header for a free block of is the */
/*  length of the free block and a pointer to the    */
/*  next free space. The header for a used block is  */
/*  the length of the used block. Coalescing is done */
/*  while looking for a free space.                  */
/*                                                   */


typedef struct header {
long int size;
struct header *nextfree;
} header;

typedef struct frontofheap {
struct header *firstfree;
struct header *lastblock;
} frontofheap;


int mm_init (void)
{
 struct frontofheap *temp; 

 if (mem_sbrk(mem_pagesize()) == NULL) { return -1; }
 temp = (struct frontofheap *)(dseg_lo);
 temp->firstfree = (struct header *)(dseg_lo + 16);
 temp->firstfree->size = (long int)(dseg_hi + 1) - (long int)temp->firstfree;
 temp->firstfree->nextfree = (struct header *)(dseg_hi + 1);
 temp->lastblock = temp->firstfree;
 return 0;
}

void *mm_malloc (size_t siz)
{
 struct frontofheap *temp;
 struct header *curr, *prev, *new, **firstfree, **lastblock;
 long int size, diff;

 temp = (struct frontofheap *)(dseg_lo);
 firstfree = &(temp->firstfree);
 lastblock = &(temp->lastblock);

 if (*firstfree == (struct header *)(dseg_hi + 1))
   {
    if(mem_sbrk(mem_pagesize()) == NULL)
      { return NULL; }
    else
      {
       (*firstfree)->size = (long int)(*firstfree) - (long int)(dseg_hi + 1);
       (*firstfree)->nextfree = (struct header *)(dseg_hi + 1);
       lastblock = firstfree;
      }
   }

 curr = *firstfree;
 prev = NULL;

 size = (long int)(siz + 15) & (~7L);

 while(1)
   {
    diff = curr->size - size;

    if ( diff < 0 )  /* current doesn't have enough */
    {
     if ( curr->nextfree == (struct header *)(dseg_hi + 1) ) /* new mem */
          {
           if (mem_sbrk(mem_pagesize()) == NULL)
             { return NULL; }
           else
	     {
              curr->nextfree->size = (long int)(dseg_hi + 1) - (long int)(curr->nextfree);
              curr->nextfree->nextfree = (struct header *)(dseg_hi + 1);
              *lastblock = curr->nextfree;
              /* try the loop again */
             }
          }

    
     else if ( (long int)curr + curr->size == (long int)curr->nextfree ) /* coal */
          {
	   if ( (long int)curr + curr->size == (long int)(*lastblock) ) { *lastblock = curr; }
           curr->size = curr->size + curr->nextfree->size;
           curr->nextfree = curr->nextfree->nextfree;
           /* try the loop again */
          }
          else  /* try a new spot */
	    {
             prev = curr;
             curr = curr->nextfree;
             /* try the loop again */
            }  
    }
    else if ( diff >= 16 )  /* grab part of the space */
           {
            new = (struct header *)((void *)curr + size);
            new->size = curr->size - size;
            new->nextfree = curr->nextfree;
            if (curr == (*firstfree))
                 { *firstfree = new; }
            else { prev->nextfree = new; }
            if (curr == (*lastblock)) { *lastblock = new; }
            curr->size = size;
            return (struct header *)((void *)curr + 8);
           }
         else /* diff == 0 or diff == 8, take all space */
	     {
              if (curr == (*firstfree))
		   { *firstfree = curr->nextfree; }
              else { prev->nextfree = curr->nextfree; }
              return (struct header *)((void *)curr + 8);
             }
   }

}

void mm_free (void *ptr)
{
 
 struct frontofheap *temp; 
 struct header *curr, *counter, **firstfree;

 temp = (struct frontofheap *)(dseg_lo);
 firstfree = &(temp->firstfree);

 curr = (struct header *)(ptr - 8);
 
 if ( curr < (*firstfree) )
   {
    curr->nextfree = *firstfree;
    *firstfree = curr;
   }
 else
   {
    counter = *firstfree;
    while(1)
      {
       if (counter->nextfree > curr)
	 {
          curr->nextfree = counter->nextfree;
          counter->nextfree = curr;
          return;
         }
       else
         {
          counter = counter->nextfree;
         }
      }
   }
}

