/* $Id$ */
/*Used The Segregated Lists Algorithm*/

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
  "Insufficient Memor",
    /* First member full name */
  "Jon Rosenberg",
    /* First member email address */
  "jpr",
    /* Second member full name (leave blank if none) */
  "John Esper",
    /* Second member email address (blank if none) */
  "esper"
};

typedef struct {
  int index;
  int size; /* this isn't used, but it helps to line up the memory */
} header;

typedef struct list {
  struct list * next;
} list;

typedef struct free_page {
  struct free_page * next;
  struct free_page * prev;
  long int size;
} free_page;

#define K 20
#define SIZE_OF_HEADER 8
#define SIZE_OF_INT 32
#define PAGESIZE 8192

/*This function rounds up to the next power of 2
  Note that i starts at -3.  This is the case because the
  smallest amount we allocate is 16bytes.
  THIS FUNCTION IS NOT USED IN THE FINAL IMPLEMENTATION!  IT
  WAS INCORPORATED DIRECTLY INTO MALLOC
*/
int getIndex(long int size) { 
  int i = -3;
  assert(size >= 0);
  if(size < 8) return 0;
  while(size > 1) {
    i++;
    size = size >> 1;
  }
  return i;
}

void printArray() {
  /* This is strictly for debugging purposes.  
     It prints out lists of free memory and such...*/
  int i;
  list * low = (list *)dseg_lo;
  list * h;
  for(i = 0; i < K; i++) {
    printf("i = %d:  ", i);
    if(low[i].next == NULL)
      printf("No Blocks Of Size %lx (%ld)\n", 1L << (i+4), 1L << (i+4));
    else {
      h = &(low[i]);
      while(h->next != NULL) {
	printf("\tNext Block of Size %lx (%ld) located at %lx.\n", 1L << (i+4), 1L << (i+4), (long int)(h->next));
	h = h->next;
      }
    }
  }
}  

/*Memory Initialization Function
  Allocate 160 bytes for all the initial headers */
int mm_init (void) {
  long int * low = (long int *)dseg_lo;
  mem_sbrk((K)*8);
  bzero((void *)low, (K)*8); /* initialize everything to NULL */
  return -1;
}

void *mm_malloc (size_t size) {
  /* This implementation of malloc takes in a size and returns a pointer to a block
     of memory that is equal to the size rounded up to the next power of 2.  This
     may be slightly inefficient on space, but it is extremely quick, and the tradeoff
     seems reasonable.  It calculates the next power of 2, uses it as an index into
     the array of headers (index - 4), and checks to see if there is a free block of
     that size.  If there is, it returns it.  If not, it generates one and returns
     that.  It also updates the list in the headers as necessary.*/  
  list ** low = (list **)dseg_lo;
  long int answer;
  int index = -3;
  long int x = size + SIZE_OF_HEADER;
  assert(x >= 0);
  if(x < 8) index = 0;
  while(x > 1) {
    index++;
    x = x >> 1;
  }

  if(low[index] == NULL) {
    low[index] = (list *)((long int)dseg_hi + 1L);
    low[index]->next = NULL;
    mem_sbrk(1L << (index + 4));
  }
  answer = (long int)(low[index]);
  low[index] = low[index]->next;
  ((header *)answer)->index = index;
  return (void *)answer + SIZE_OF_HEADER;
}

void mm_free (void *ptr) {
  /* This implementatin of free takes the pointer, finds the correct index into the
     array of block headers, and adds the block to the head of the list of free
     blocks.  The extent of the error checking involves checking the bounds of the
     pointer (that it is actually within the heap).
*/
  header * block = (header *)((long int)ptr - SIZE_OF_HEADER);
  int index = (block->index);
  list * low = (list *)dseg_lo;

  if((long int)ptr < (long int)dseg_lo || (long int)ptr > (long int)dseg_hi) return;
  ((list *)block)->next = low[index].next;
  low[index].next = (list *)block;
}
