/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

/* malloc.c - A dynamic memory allocator.  The method we use is an explicit free
   list.  The head of this list is kept at the start of the heap and is 8 bytes
   long.  The next word is the start of the actual memory being managed. For the
   free list, each block has a header and a footer.  In the header we keep the 
   size and a flag to indicate allocation, 0 for unallocated.  The size includes
   the header and the footer in words. In order to do this, the blocks must be 
   kept even. Also each block in the free list has a forward pointer and a backward 
   pointer that points towards the block closer to the head.  When we malloc, we 
   search the list for a block that is large enough to accomadate the requested size. 
   If one is found, it is checked to see if it could be split.  If it is split, the
   end part is returned to the user.  On the free, we use right and left coalescing.
*/
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define WORDSIZE 8
#define MINBLOCKSIZE 4

#define DEBUG 0

#define ulong unsigned long

#define assign(address, word) \
do { (*((unsigned long *)(address))) = (unsigned long)(word); } while(0)

#define getword(address) *((unsigned long *)address)

#define is_allocated(header_or_footer) (header_or_footer & 1UL)

team_t team = {
    /* Team name to be displayed on webpage */
    "J&V",
    /* First member full name */
    "Jerry Abraham",
    /* First member email address */
    "joa@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Vishal Rao",
    /* Second member email address (blank if none) */
    "lvr@andrew.cmu.edu"
};

#ifdef DEBUG
void print_free_list(){
  unsigned long *ptr = (unsigned long *)(*((unsigned long *)dseg_lo));
  printf("free_list:\n");
  while (ptr){
    printf("  0x%p\tlength: %lu\n",(ptr+1),*ptr);
    ptr = (unsigned long *)(*(ptr + 1));
  }
}
#endif


int mm_init (void)
{
  ulong heap_size = dseg_hi - dseg_lo + 1;
  /* Check to see if the heap_size given is large enough to hold
     the minimum block size plus one word for the head of the 
     free list */
  if (heap_size < 5*WORDSIZE) { /* need to allocate */
    if (mem_sbrk(mem_pagesize()) == NULL)
      return -1;
    else heap_size = dseg_hi - dseg_lo + 1;
  }
  /* make sure that the heap size has an even number of words
     not including the head of the free list */
  if ((heap_size - WORDSIZE) % (2*WORDSIZE) != 0){
    ulong mem_increment = 2*WORDSIZE - (((heap_size - WORDSIZE) % (2*WORDSIZE)));
    if(mem_sbrk(mem_increment) == NULL)
      return -1;
    heap_size += mem_increment;
  }
  /* Sets up the head of the linked list, the header of the one block,
     the footer of the block, and the forward and backward pointers */
  assign(dseg_lo, dseg_lo+WORDSIZE);
  assign(dseg_lo+WORDSIZE, (heap_size - WORDSIZE)/WORDSIZE);
  assign(dseg_lo+2*WORDSIZE, NULL);
  assign(dseg_lo+3*WORDSIZE, NULL);
  assign(dseg_hi-7, (heap_size - WORDSIZE)/WORDSIZE);

  return 0;
}

void *mm_malloc (size_t size)
{
  /* Minimum Number of words that bounds the size given */
  ulong minwordstoallocate = (size % WORDSIZE) ? ((size/WORDSIZE)+1) : 
                                                  (size/WORDSIZE);
  /* round to even */
  ulong wordstogive = ((minwordstoallocate+1) >> 1) << 1;
  ulong blocksizetofind = wordstogive + 2;
  ulong curblocksize;

  /* Pointer starts at the first block in the free list */
  ulong *rovingPtr = (ulong*)getword(dseg_lo);

#if DEBUG
  printf("malloc: 0x%x\n",(int)size);
  print_free_list();
#endif

  if (size <= 0) return NULL;
  
  /* Search the free list */
  while (rovingPtr){
#if DEBUG
    printf("Searching the list:\n0x%p\n",rovingPtr+1);
#endif
    if(rovingPtr == NULL) break;
    curblocksize = getword(rovingPtr);
    if(curblocksize < blocksizetofind){
      /* Block to small, continue to next block in list */
      rovingPtr = (ulong *)(getword(rovingPtr + 1));
      continue;
    }
    if (curblocksize - blocksizetofind < MINBLOCKSIZE){
      /* Not big enough to split, return whole thing */
      assign(rovingPtr, curblocksize | 1);
      assign(rovingPtr + curblocksize - 1, curblocksize | 1);
      if(rovingPtr[1] != NULL)
        assign(rovingPtr[1] + 16, rovingPtr[2]);
            
      if(rovingPtr[2] != NULL)
        assign(rovingPtr[2] + 8, rovingPtr[1]);
      else
        assign(dseg_lo, rovingPtr[1]);
#if DEBUG
      printf("  returning 0x%p\n",rovingPtr+1);
#endif
      return (rovingPtr + 1);
    }
    else{ /* split and return end part to user */
      ulong residualsize = curblocksize - blocksizetofind;
      ulong * blocktoallocate = rovingPtr + residualsize;
#if DEBUG
      printf("Splitting block, residual: 0x%p\n",rovingPtr+1);
#endif
      assign (blocktoallocate, blocksizetofind | 1);
      assign (blocktoallocate + blocksizetofind - 1, blocksizetofind | 1);
      assign (rovingPtr, residualsize);
      assign (rovingPtr + residualsize - 1, residualsize);
#if DEBUG
      printf("  returning 0x%p\n",blocktoallocate+1);
#endif
      return (blocktoallocate + 1);
    }
  }
  /* If the pointer is NULL, then no block of adequate size was found
     in the free list.  Therefore we must increase the heap size.  
     We increase by the size of the words to allocate */
  if (rovingPtr == NULL){
    ulong mem_increment = blocksizetofind * WORDSIZE;
    ulong * newmemPtr;
    if ((newmemPtr = mem_sbrk(mem_increment)) == NULL){
#if DEBUG
      printf("  returning NULL\n");
#endif
      return NULL;
    }else{
      assign (newmemPtr, blocksizetofind | 1);
      assign ((ulong *)newmemPtr + blocksizetofind - 1, blocksizetofind | 1);
#if DEBUG
      printf("  returning 0x%p\n",(ulong *)newmemPtr + 1);
#endif
      return ((ulong *)newmemPtr + 1);
    }
  }
  return NULL;
}

void mm_free (void *ptr)
{
  ulong * freePtr = (ulong *) ((char*)ptr - 8);
  ulong blocksize;
  if (freePtr == NULL) return;

  blocksize = (*freePtr) & ~1UL;
  assign(freePtr, blocksize);
  assign(freePtr + blocksize - 1, blocksize);

#if DEBUG
  printf("free: 0x%p\tlength: %lu\n",ptr,blocksize);
#endif
  /*  if (((char *)(freePtr - 1) != dseg_lo)  && ((freePtr[-1] & 1UL) == 0) && 
      ((char *)(freePtr+blocksize) < (dseg_hi + 1)) && ((freePtr[blocksize] % 2) == 0)){
    ulong newblocksize = blocksize + freePtr[blocksize] + freePtr[-1];
    if (*(freePtr + blocksize + 1) != NULL){
      *((ulong *)(*(freePtr + blocksize + 1)) + 2) = *(freePtr + blocksize + 2);
    }
    if(*(freePtr + blocksize + 1) != NULL){
      *((ulong *)(*(freePtr + blocksize + 2)) + 1) = *(freePtr + blocksize + 1);
    }
    else{
      *((ulong *)(dseg_lo)) = *(freePtr + blocksize + 1);
    }
    assign(freePtr - freePtr[-1], newblocksize);
    assign(freePtr + blocksize + freePtr[blocksize] - 1, newblocksize);
  }
  else */
  /* Right Coalescing.  Move the pointers right after the header of the current block */
  if (((char *)(freePtr+blocksize) < (dseg_hi + 1)) && (freePtr[blocksize] & 1UL) == 0){
    ulong newblocksize = blocksize + freePtr[blocksize];
    *(freePtr + 1) = *(freePtr + blocksize + 1);
    *(freePtr + 2) = *(freePtr + blocksize + 2);
    /* Update the pointers of the blocks that point to the right
       block in the free list */
    if (*(freePtr + 1) != NULL){
      *((ulong *)(*(freePtr + 1)) + 2) = (ulong)freePtr;
    }
    if (*(freePtr + 2) != NULL){
      *((ulong *)(*(freePtr + 2)) + 1) = (ulong)freePtr;
    }
    else {
      *((ulong *)(dseg_lo)) = (ulong)freePtr;
    }
    *(freePtr) = newblocksize;
    *(freePtr + newblocksize - 1) = newblocksize;
    /*blocksize = newblocksize;*/
#if DEBUG
    printf("Coalescing right: 0x%p\t0x%p\n", ptr, freePtr+blocksize+1);
#endif
  }
  else
    /* Left Coalesce, Just update the header of the left block
       and the footer of the block being freed with the new size */
  if (((char *)(freePtr - 1) != dseg_lo)  && ((freePtr[-1] & 1UL) == 0)  ){

    ulong newblocksize = blocksize + freePtr[-1];
    *(freePtr - freePtr[-1]) = newblocksize;
    *(freePtr + blocksize - 1) = newblocksize;
#if DEBUG
    printf("Coalescing left: 0x%p\t0x%p\n",ptr,(ulong *)ptr-freePtr[-1] +1);
#endif
  }
  else{
    /* Can't coalesce, add to front of free list */
    *(freePtr + 1) = *((ulong *)dseg_lo);
    
    *(freePtr + 2) = NULL;
    /* Update back pointer of previous block at beginning of list */
    if(*((ulong *)dseg_lo) != NULL){
      assign( (ulong *)(*((ulong *)dseg_lo)) + 2, freePtr);
    }      
    assign((ulong *)dseg_lo, freePtr);
#if DEBUG
    printf("Inserting into free list: 0x%p\n", freePtr);
#endif
  }
#if DEBUG
  print_free_list();
#endif
  return;
}

