/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "We Like Roofies",
    /* First member full name */
    "Joel Lucas",
    /* First member email address */
    "jlucas",
    /* Second member full name (leave blank if none) */
    "Matt Dobson",
    /* Second member email address (blank if none) */
    "mcd"
};

// pointers to all the free space after
// all the different size memory segments

// pointer to blocks
 char *segments[64] = {0};

// helper function that returns n where 2^n >= size
static inline int Return_N(int size)
{
  int i=0;

  while (i<64)
    {
      if ((1<<i)>=size)
	return i;
      else 
	i++;
    }
  return i;
}

//-------------------------- mm_init
int mm_init (void)
{
  int i; 
   
  for (i=0; i<64; i++) 
    segments[i] = 0;
  return 0;
}

//-----------------------------malloc
void *mm_malloc (size_t size)
{
  char *ptr; // pointer to the new memory
  int b; // value of Return_N(size)

  b = Return_N(size);
  if (segments[b]) // if there is something at this segment
  {
    ptr = segments[b]; // return value is equal to this address

    segments[b] = *(void **)ptr;
    return ptr; // return pointer to block of size 2^b bytes
  }    
  // else we need to increase the heap:
  size = (1<<b) + 8;
  ptr = (void *)mem_sbrk(size); // get a chunk of 2^b + 8 bytes

  *(long int *)ptr = b; // set first byte to give size of chunk
  ptr += 8;             // for use in freeing later

  return ptr; // return pointer 
}
//------------------------free
void mm_free (void *ptr)
{
  int b = *(long int *)(ptr-8); // set b equal to the size of this block
  *(void **)ptr = segments[b]; 
  segments[b] = ptr;
}

