/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Memory-Stealers",
    /* First member full name */
    "Jianping Liu",
    /* First member email address */
    "jianpi@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Rong Chen",
    /* Second member email address (blank if none) */
    "rchen@andrew.cmu.edu"
};


/***** free list block structure: size in head w/ flag, pointer to next in head+1;   -----*
 ***** time overhead in searching over the list since it's not bidirectional         -----*/

static long *circle;

int mm_init (void)
{ ptrdiff_t PageSize = mem_pagesize(), nBlk = 8*PageSize;
  size_t lenWord = sizeof(char *);
 
  if((PageSize & 7) != 0) { 
    printf("Warning: PageSize not a multiple of 8, which is common for most machines\n");
    PageSize = PageSize & -8;
  }

  /***** because in mem_sbrk, (char *)dseg_hi is incremented by bytes due to (char *) ---*/
  if( mem_sbrk(nBlk*8) == NULL ) {
    printf("not enough memory for your heap !!!\n");
    return -1; 
  }

  /***** init the base pointer circle ----*/
  circle = (long *)dseg_lo;
  *(circle+1) = (long)circle;
  *circle = nBlk * lenWord;

  return 0;
}


long *moreMem(size_t sizeAlign)
{ ptrdiff_t PageSize = mem_pagesize(), nBlk = 8*PageSize;
  char *old_hi;
  long *newhd, *topfree;

  old_hi = mem_sbrk(nBlk*8);
  if(old_hi == (char *)-1) {
    printf("Failed get more memory from the system !!!\n"); 
    return NULL;
  }

  newhd = (long *)old_hi;
  *newhd = nBlk*8;

  /***** looking for the top of the free list to insert the fresh block, ---*/
  for(topfree=circle; ; topfree = (long *) *(topfree+1))
    if( topfree >= (long *) *(topfree+1)) break;
  *(newhd+1) = *(topfree+1);
  *(topfree+1) = (long)newhd;

  circle = topfree;
  return newhd;
}

/**** dynamic memory allocation using explicit list with next-fit method allocation --*/
void *mm_malloc (size_t size)
{ long *loop, *p2nd, *pre;
  size_t sizeAlign, lenWord = sizeof(char *); 
  
  /**** make sure the allocated block be word-size aligned and header, lenWord==8   ----*/
  sizeAlign = 8*((size-1)/8) + 16;
  pre = circle;

  /**** search for a big enough block; if necessary, split or call for moreMem; reset infos ---*/
  for( loop = (long *) *(pre+1); ; pre=loop, loop = (long *) *(loop+1) ) {
    if( *loop >= sizeAlign ) {
      if( *loop == sizeAlign ) {
	if( loop == pre ) {
	  printf("Danger! it's the only one in the free list\n");
	  if( (loop = moreMem(sizeAlign)) == NULL ) {
	    printf("CANT do any allocation after this one anymore !!!\n");
	    return (void *)(loop+1);
	  }
	  continue;
	}
	else	*(pre+1) = *(loop+1);
	circle = pre;
      }
      /*** next: splitting out the high-addressed part to the user ---*/
      else {
	circle = loop;
	*loop -= sizeAlign;
	loop += *loop/8;
	*loop = sizeAlign;
      }
      *loop += 1;
      return (void *)(loop+1);
    }

    /*** if no large enough free block, grap another huge block from the heap ---*/
    if( loop == circle ) {
      if( (loop = moreMem(sizeAlign)) == NULL ) return NULL;
      loop = circle;
      continue;
    }
  }
}


/**** dynamic free memory using sorted explicit list for free blocks with coalescing ----*/
void mm_free (void *ptr)
{ long *ptr_1, *loop, cond_hi, cond_lo;

  ptr_1 = (long *)ptr - 1;
  *ptr_1 &= ~7;

  /***** search for the position at which to insert the freed block ----*/
  /***** special case when only one existing block in the free list ----*/
  for(loop=circle; !(ptr_1 > loop && ptr_1 < (long *) *(loop+1)); loop = (long *) *(loop+1) ) {
    if( loop >= (long *) *(loop+1) && ptr_1 > loop ) break;
    if( (long *) *(loop+1) == circle ) {
      *(loop+1) = (long) ptr_1;
      *(ptr_1+1) = (long) loop;
      return;
    }
  }

  /***** check the status of adjacent blocks ---*/
  cond_hi = ( ptr_1 + *ptr_1/8 == (long *) *(loop+1) );
  cond_lo = ( loop + *loop/8 == ptr_1 );

  /**** no coalescing for isolated block ---*/
  if( !cond_hi && !cond_lo ) {
    *(ptr_1+1) = *(loop+1);
    *(loop+1) = (long) ptr_1;
  }

  /**** coalescing with high addressed block ---*/
  if( cond_hi && !cond_lo ) {
    *ptr_1 += *((long *) *(loop+1));
    *(ptr_1 + 1) = *( (long *) *(loop+1) + 1);
    *(loop+1) = (long) ptr_1;
  }

  /**** coalescing with low addressed block ---*/
  if( !cond_hi && cond_lo ) *loop += *ptr_1;

  /**** coalescing bidirectionally with both high/low addressed blocks ---*/
  if( cond_hi && cond_lo ) {
    *loop += *ptr_1 + *((long *) *(loop+1));
    *(loop+1) = *( (long *) *(loop+1) + 1);
  }

  //  circle = loop;
}

