/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Memory-Stealers",
    /* First member full name */
    "Jianping Liu",
    /* First member email address */
    "jianpi@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Rong Chen",
    /* Second member email address (blank if none) */
    "rchen@andrew.cmu.edu"
};

static long *circle;
static long *base;

int mm_init (void)
{ ptrdiff_t PageSize = mem_pagesize(), nBlk = 8*PageSize;
  size_t lenWord = sizeof(char *);
 
  if((PageSize & 7) != 0) { 
    printf("Warning: PageSize not a multiple of 8, which is common for most machines\n");
    PageSize = PageSize & -8;
  }

  /***** because in mem_sbrk, (char *)dseg_hi is incremented by bytes due to (char *) ---*/
  if( mem_sbrk(nBlk*8) == NULL ) {
    printf("not enough memory for your heap !!!\n");
    return -1; 
  }

  base = (long *)dseg_lo;
  if(dseg_lo==NULL) { printf("no heap allocated!!!\n"); return -1; }
  else {
    /**** initialize the block info, block size refers to the bytes so free low bits --*/
    circle = base;
    *(circle+1) = (long)circle;
    *circle = nBlk * lenWord;
  }

  return 0;
}


long *moreMem(size_t sizeAlign)
{ ptrdiff_t PageSize = mem_pagesize(), nBlk = 8*PageSize;
  char *old_hi;
  long *newhd, *topfree;

  old_hi = mem_sbrk(nBlk*8);
  if(old_hi == (char *)-1) {
    printf("Failed get more memory from the system !!!\n"); 
    return NULL;
  }

  newhd = (long *)old_hi;
  *newhd = nBlk*8;
  //  printf("new block starts at 0x%lx w/ size 0x%lx \n", (long)newhd, *newhd);

  //  printf("Got new large block :)\n");
  for(topfree=circle; ; topfree = (long *) *(topfree+1))
    if( topfree >= (long *) *(topfree+1)) break;
  *(newhd+1) = *(topfree+1);
  *(topfree+1) = (long)newhd;

  circle = topfree;
  return newhd;
}

/**** dynamic memory allocation using explicit list with next-fit method allocation --*/
void *mm_malloc (size_t size)
{ long *loop, *p2nd, *pre;
  size_t sizeAlign, lenWord = sizeof(char *); 
  
  /**** make sure the allocated block be word-size aligned and header & footer, lenWord==8 --*/
  sizeAlign = 8*((size-1)/8) + 16;
  pre = circle;

  for( loop = (long *) *(pre+1); ; pre=loop, loop = (long *) *(loop+1) ) {
    if( *loop >= sizeAlign ) {
      if( *loop == sizeAlign ) {
	if( loop == pre ) {
	  printf("Danger! it's the only one in the free list\n");
	  if( (loop = moreMem(sizeAlign)) == NULL ) {
	    printf("CANT do any allocation after this one anymore !!!\n");
	    return (void *)(loop+1);
	  }
	  continue;
	}
	else	*(pre+1) = *(loop+1);
      }
      else {
	*loop -= sizeAlign;
	loop += *loop/8;
	*loop = sizeAlign;
      }
      circle = pre;
      *loop |= 1L;
      return (void *)(loop+1);
    }
    if( loop == circle ) {
      //   printf("Try to get more memory !\n");
      if( (loop = moreMem(sizeAlign)) == NULL ) return NULL;
      loop = circle;
      continue;
    }
  }
}


/**** dynamic free memory using explicit list with coalescing --*/
void mm_free (void *ptr)
{ long *ptr_1, *loop, cond_hi, cond_lo;

  ptr_1 = (long *)ptr - 1;
  *ptr_1 &= ~7;

  for(loop=circle; !(ptr_1 > loop && ptr_1 < (long *) *(loop+1)); loop = (long *) *(loop+1) ) {
    if( loop >= (long *) *(loop+1) && ptr_1 > loop ) break;
    if( (long *) *(loop+1) == circle ) {
      //      printf("-------Currently only one free block in the list\n");
      *(loop+1) = (long) ptr_1;
      *(ptr_1+1) = (long) loop;
      return;
    }
  }

  cond_hi = ( ptr_1 + *ptr_1/8 == (long *) *(loop+1) );
  cond_lo = ( loop + *loop/8 == ptr_1 );

  /**** isolated --*/
  if( !cond_hi && !cond_lo ) {
    *(ptr_1+1) = *(loop+1);
    *(loop+1) = (long) ptr_1;
  }

  /**** with hi --*/
  if( cond_hi && !cond_lo ) {
    *ptr_1 += *((long *) *(loop+1));
    *(ptr_1 + 1) = *( (long *) *(loop+1) + 1);
    *(loop+1) = (long) ptr_1;
  }

  /**** with low --*/
  if( !cond_hi && cond_lo ) *loop += *ptr_1;

  /**** with both -*/
  if( cond_hi && cond_lo ) {
    *loop += *ptr_1 + *((long *) *(loop+1));
    *(loop+1) = *( (long *) *(loop+1) + 1);
  }

  //  circle = loop;
}

