/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Gettin' Jiggy With It",
    /* First member full name */
    "Jian B Shih",
    /* First member email address */
    "jbs@cyrus.andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Daniel K Tennant",
    /* Second member email address (blank if none) */
    "dkt@andrew.cmu.edu"
};


int mm_init (void)
{

  /*allocates an initial heap size of one page, plus headers */
  if ( mem_sbrk(mem_pagesize()+24) == NULL)
    return -1;

  /*initializes the offset value of where we want to start searching the heap for free blocks */
  *((long int *)dseg_lo) = 2;
 
  /* makes the first block in the heap out of all the available space */
  *((long int *)dseg_lo +1)=(mem_pagesize()+8); 
    return 0;
}


/*  This malloc uses next fit, and lazy coalescing
    Headers only contain size of the block, and a flag as to whether or not
    it is free.
    Since blocks must be 8-aligned, the least significant bit will never
    be used to represent the size of a block--therefore, we encoded the free
    flag in this bit
*/
void *mm_malloc (size_t size) 
{

  long int *next = 0x00;
  long int *current = 0x00;
  long int *header = 0x00;
  long int *last = 0x00;
  long int len = 0;
  long int offset = 0;
  short has_not_reset = 0;

  /*reads in the value of where the last malloc stopped searching */
  offset = *((long int *)dseg_lo);

  while(1)
    {
      /*  we don't want our loop to go through the heap more than once, so
	  keep track of whether we've rest to the beginning yet */
      has_not_reset=1;
      
      while((offset<(*dseg_lo))||has_not_reset)
	{

	  /* sets pointers */
	  current = (long int *)dseg_lo + offset ;
	  header = current - 1;
	  len = (((*header)>>1)<<1) ;
	  	  
	  if((dseg_lo +(8*(offset+1)+len))<dseg_hi)
	    {
	      next = current + (len/8) +1;
	    }
	  else
	    {
	      next=NULL;
	    }
	  
	  if(!(len^(*header)))
	    {
	      /* check for following free blocks and coalesce */
	      
	      while((next!=NULL)&&(!(((*(next-1)>>1)<<1)^(*(next-1)))))
		{		  
		  *header = len + (*(next-1)+8); 		  
		  len = (((*header)>>1)<<1);
		  
		  /* if free block begins below dseg_hi, link free blocks 
		     together  */

		  if((dseg_lo + (8*(offset+1)+len))<dseg_hi)
		    {
		      next = current + (len/8) +1;
		    }
		  else
		    {
		      next = NULL;
		    }
		}	   
	      if(size<=len)
		{
		  
		  /* split up blocks, while keeping blocks 8-aligned */
		  
		  if(size%8)
		    {
		      size = ((size/8)+1)*8;
		    }

		  /* create new header for new free block if enough room */
		  if((len>(size))&&((dseg_lo + (8*(offset+1)+size))<dseg_hi))
		    {
		      *header=size;
		      next = current + (size/8) +1;
		      *(next-1) = len - size -8;
		    } 
		  
		  /* set flag to represent full block */
		  *header = *header | 0x01;
		  
		  /* sets heap header to store current so we can use next fit algorithm */
		  *((long *)dseg_lo) = offset;
		  return current;
		}
	    }
	  
	  /* block already allocated or not big enough, so move to next block*/
	  offset = offset + (len/8)+1;
	  
	  /*  if at the end of heap, loop back to beginning */
	  if((dseg_lo + (8*offset))>=dseg_hi)
	    {
	      last = header; 
	      offset = 2;
	      has_not_reset=0;
	    }
	}
      
      /*  there is no space in heap for the block, so expand heap
	  we expand heap by 2*mem_pagesize() in order to minimize the calls to
	  mem_sbrk
      */
      if(mem_sbrk(2*mem_pagesize())==NULL)
	return NULL;  
     
      if((((*last)>>1)<<1)^(*last))
	{    
	  /*if the last block in the list is a full block, create a new empty block */   
	  *(last + ((*last -1)/8)+1 )=(2*mem_pagesize())-8;
	}
      else
	{
	  /*if the last block in the list is empty, extend its size by the added space*/
	  *last = *last +(2*mem_pagesize());
	}
    }
  
  return NULL;
}

void mm_free (void *ptr)
{

  long int * header = 0x00;

  /* get access to header of ptr */
  header = (long int *)(ptr);
  header = (header -1);

  /* check to make sure header is in bounds */
  if (header < (long *)dseg_hi && header >= (long *)dseg_lo)
    *header = *header ^ 0x01;
}

