/* $Id$ */
/*
Lab 3 Comments: (Rich Friedberg and Ian McCullough)

	Things we completed:
	
	Made malloc system that utilizes two doubly linked lists of blocks, one
for freed blocks and one for allocated blocks. Also implmented free.

	Our mm_init calls sbrk for the first block and sets the two list
pointers to NULL;

	Our mm_malloc handles the following conditions in the following ways
(in order): 
	
		Checks the free list for a best fit by size, uses that block. 
		Frees any surplus above and beyond what was used in the old block.
		
		Memory available in heap already allcoated with sbrk available for
		new blocks.  Makes a new block and prepends to the list of
		allocated blocks.
		
		No memory available in unused heap, no freed blocks available. 
		Calls sbrk and then allocates a new block in it and prepends to the
		allocated list. Unused portions left for future use (not blockified
		and freed).

	Our mm_free simply removes the block from the allocated list and puts
it in the free list. 


	Things we couldn't get to work:
	
	Coalescing. We had our previous algorithm working to the 100% grade
level so we didnt bother to finish debugging this.  It was being a time
sink.  The code appears commented out at the bottom.

	Things we would have done additionally with more time:
	
	Segmenting wrapper: i.e. redirect all allocs for size < pagesize /2 to
a separate allocation mechanism for segemented small storage.  Never got
there.
*/

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* This stuff should really be in an included file */

#define HeaderPtrFromUserPtr(p) ((LLPtr)((unsigned long)p - (unsigned long)sizeof(LinkedList)))
#define UserPtrFromHeaderPtr(p) ((LLPtr)((unsigned long)p + (unsigned long)sizeof(LinkedList)))
#define BLOCKLOG 12
#define RoundForAlign(p) (((p) & 7) ? ((((p) + 8) >> 3 ) << 3) : p )
#define BlockSizeFromSize(s) (RoundForAlign(s) + sizeof(LinkedList))
#define HEAPSIZE ((unsigned long)(dseg_hi - dseg_lo))

typedef struct __linked_list {
	struct __linked_list *prev;
	struct __linked_list *next;
 	unsigned long size;
} LinkedList, *LLPtr;

typedef struct __heap_header {
	LLPtr allocated;
	LLPtr free;
	void *baseOfUnusedHeap;
} HeapHeader, *HeapHeaderPtr;
#define PAGESIZE  mem_pagesize()


LLPtr BestFit(LLPtr head, unsigned long desiredSize);
//void Coalesce(LLPtr block);
LLPtr RemoveFromList(LLPtr list, LLPtr blockToRemove);
LLPtr AddToHeadOfList(LLPtr list, LLPtr blockToAdd);



/*END INCLUDE STUFF*/



extern unsigned long numops;
team_t team = {
    /* Team name to be displayed on webpage */
    "Malloc this!",
    /* First member full name */
    "Ian P. McCullough",
    /* First member email address */
    "ipm",
    /* Second member full name (leave blank if none) */
    "Richard I. Friedberg",
    /* Second member email address (blank if none) */
    "rif"
};


int mm_init (void)
{
	void *initptr;
	HeapHeader temp;

// On first startup just allocate a page if possible and dump out....
	if (dseg_hi < dseg_lo)
	{
		initptr = mem_sbrk(PAGESIZE);
		if (!initptr) return -1;
	}

// On subsequent reinits all we really want to do is blow away the list...
// Which is easy cause we'll just blow away the header...
	temp.allocated = NULL;
	temp.free = NULL;
	temp.baseOfUnusedHeap = (void *)((unsigned long)dseg_lo + (unsigned long)sizeof(HeapHeader));

	*((HeapHeaderPtr)dseg_lo) = temp;

	return 0;
}

void *mm_malloc (size_t size)
{
	HeapHeaderPtr heap = (HeapHeaderPtr) dseg_lo;
	LLPtr listWalker = NULL;
	void * result;
	unsigned long calc;


	// Look for a free block of this size...
	listWalker = BestFit(heap->free, size);
	if (listWalker != NULL)
	{
		
		unsigned long calc;
		long leftover;
		LLPtr newBlock;
		
		heap->free = RemoveFromList(heap->free, listWalker);

		// pointer to the next possible block...
		calc = BlockSizeFromSize(size);
		calc += (unsigned long)listWalker;
		newBlock = (LLPtr)calc;
		// free space above this block...
		leftover = BlockSizeFromSize(listWalker->size) - BlockSizeFromSize(size);
		// if its worth using...
		listWalker->size = RoundForAlign(size);
		heap->allocated = AddToHeadOfList(heap->allocated, listWalker);
		if (leftover > ((long)(sizeof (LinkedList) + 64)))
		{
			// truncate the existing block...
			newBlock->size = (leftover - sizeof (LinkedList) -64);
			heap->free = AddToHeadOfList(heap->free, newBlock);		
			//Coalesce(newBlock);	
		}
		

        result = UserPtrFromHeaderPtr(heap->allocated);	
     	return result;
    }
	// we dont have a winner in the free stuff...
	
	// do we need any new blocks or can we put it in existing allocated heap.
	if (((unsigned long)dseg_hi - ((unsigned long)heap->baseOfUnusedHeap)) > BlockSizeFromSize(size))
	{
		
		LLPtr newBlock = (LLPtr)(heap->baseOfUnusedHeap);
		newBlock->size = RoundForAlign(size);
		heap->allocated = AddToHeadOfList(heap->allocated, newBlock);

		heap->baseOfUnusedHeap += BlockSizeFromSize(size);
		
		result = UserPtrFromHeaderPtr(heap->allocated);

		return result;
	}
	// No free blocks... (or not big enough...)
	// Make a correct sized free block and call ourselves...
	calc = (unsigned long)((unsigned long)dseg_hi - (unsigned long)heap->baseOfUnusedHeap);
	calc = BlockSizeFromSize(size) - calc;
	calc = (((calc / PAGESIZE) + 1) * PAGESIZE); 
	result = mem_sbrk(calc);

	if (result == NULL)
		return NULL;

	calc = (unsigned long)((unsigned long)dseg_hi - (unsigned long)heap->baseOfUnusedHeap);
	// add the alloced block
	
	((LLPtr)heap->baseOfUnusedHeap)->size = (BlockSizeFromSize(size) - (unsigned long)sizeof(LinkedList));
	heap->allocated = AddToHeadOfList(heap->allocated, ((LLPtr)heap->baseOfUnusedHeap));
		
	result = UserPtrFromHeaderPtr(heap->allocated);
	
	heap->baseOfUnusedHeap = (void *)(((unsigned long)heap->baseOfUnusedHeap) + BlockSizeFromSize(size));
	return result;	
}


void mm_free (void *ptr)
{
	HeapHeaderPtr heap = (HeapHeaderPtr) dseg_lo;
	LLPtr blockToFree = HeaderPtrFromUserPtr(ptr);


	heap->allocated = RemoveFromList(heap->allocated, blockToFree);

	// Insert at the head of the free list....
	//Coalesce(blockToFree);
	
	heap->free = AddToHeadOfList(heap->free, blockToFree);

}

void Coalesce(LLPtr block)
{
	// No need for args here...  We know that the last block freed will
	// be at the head of the the free list.
	HeapHeaderPtr heap = (HeapHeaderPtr) dseg_lo;
	LLPtr walker, nextBlock = NULL, prevBlock = NULL;
	LLPtr blockBegin = block, blockEnd = block + BlockSizeFromSize(block->size);
	
	walker = heap->free;
	while (walker)
	{
		if (walker == blockEnd)
			nextBlock = walker;
		if ((walker + BlockSizeFromSize(walker->size)) == blockBegin)
			prevBlock = walker;
		walker = walker->next;
	}

	if (prevBlock && !nextBlock)
	{
		prevBlock->size += BlockSizeFromSize(block->size);
		return;
	}	
	
	if (nextBlock && !prevBlock)
	{
		heap->free = RemoveFromList(heap->free, nextBlock);
		block->size += BlockSizeFromSize(nextBlock->size);
		heap->free = AddToHeadOfList(heap->free, block);	
		return;
	}
	if (nextBlock && prevBlock)
	{
		heap->free = RemoveFromList(heap->free, nextBlock);
		prevBlock->size += BlockSizeFromSize(block->size) + BlockSizeFromSize(nextBlock->size);
		return;
	}
	
	heap->free = AddToHeadOfList(heap->free, block);	

}

LLPtr BestFit(LLPtr head, unsigned long desiredSize)
{
	LLPtr currentBestPtr = NULL;
	LLPtr walker = head;
	unsigned long currentBestSize = ~0;
	
	while (walker != NULL)
	{
		// if we've got an exact match we've got a best fit...
		if (walker->size == desiredSize) return walker;
		// Otherwise look for one that leaves the best overflow...
		if (walker->size > desiredSize && walker->size < currentBestSize)
		{
			currentBestPtr = walker;
			currentBestSize = walker->size;
		}
		walker = walker->next;
	}
	return currentBestPtr;
}



LLPtr RemoveFromList(LLPtr list, LLPtr blockToRemove)
{
// removing from a linked list:
// 
// I am either:
// 
// 1) at the head of the list (me->prev == null)
	if (blockToRemove->prev == NULL)
	{
	// 	I am either:
	// 	a) the only one (me->next == null)
		if (blockToRemove->next == NULL)
		// 		list = NULL;
			list = NULL;					
		// 	b) not the only one (me->next != NULL)
		else
		{	
		// 		me->next->prev = NULL
		// 		list = me->next;			
			blockToRemove->next->prev = NULL;
			list = blockToRemove->next;
		}
	}
// 2) at the end of the list (me->next == NULL)
	else if (blockToRemove->next == NULL)
	{	
	// 	I am either:
	// 	a) the only one (me->prev == null)
		if (blockToRemove->prev == NULL)
	// 		list = NULL;
			list = NULL;
	// 	b) not the only one (me->prev != NULL)
		else
	// 		me->prev->next = NULL
			blockToRemove->prev->next = NULL;
	// 
	}
// 3) in the middle (! 1 | 2)
	else
	{
	// 	me->next->prev = me->prev;
		blockToRemove->next->prev = blockToRemove->prev;
	// 	me->prev->next = me->next;
		blockToRemove->prev->next = blockToRemove->next;
	}

	blockToRemove->next = NULL;
	blockToRemove->prev = NULL;

	return list;
// 	
// return list....
// 
}

LLPtr AddToHeadOfList(LLPtr list, LLPtr blockToAdd)
{

	blockToAdd->next = list;
	blockToAdd->prev = NULL;
	if (!list) return blockToAdd;
	list->prev = blockToAdd;
	
	list = blockToAdd;
	return list;
}
