/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "whatever",
    /* First member full name */
    "Hope Welsch",
    /* First member email address */
    "hwelsch@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{
     int size;
     char* fail;

     size = mem_usage();  /* get the current size of the heap */
     if (size == -1) {  /* if the heap is empty */
       fail = mem_sbrk(1024); /* set the initial heap size */  
       if (fail == NULL) { /* mem_sbrk returned that there is no more memory left */
         return -1;
       }
       else { /* mem_sbrk worked */
         *(int*)(dseg_lo) = 1024;  /* sets the initial header size */
         *(int*)(dseg_hi-3) = 1024;  /* sets the initial footer size */
          return 0;
       }
     }
     else { /* the heap is not empty */
       *(int*)(dseg_lo) = size + 1;  /* sets the header size to the size of the heap */
       *(int*)(dseg_hi-3) = size + 1;  /* sets the footer size to the size of the heap*/
       return 0;
   }
}


void *mm_malloc (size_t size)
{
    int length;
    int temp;
    long* move;
    int freelength;
    int leftover;
    long* returnme;

    /* get the length (8 byte aligned) of the pointer you're going to need to allocate */
    length = size / 8; 
    if (size % 8 != 0) {
	length = length + 1;
    }
  
    /* look through the heap for a spot to allocate the space */
    /* first fit */
    
    temp = *(int*)dseg_lo; /* temp points to the length of the first block */
    move = (long*)dseg_lo; /* pointer to first thing in the heap */

    /* progress through the heap until you find a place to allocate or you hit the end of the heap */
    while (  (move < (long*)dseg_hi) || /* not past the end of the heap */
             (temp & 1)  ||    /* already allocated */
             (temp <= length+2) ) {  /* too small */ 
      move = move + temp;  /* move the pointer to the next header */
      temp = *(int*)move;  /* make temp be the length in this new header */ 
    }

   if (move >= (long*)dseg_hi)  { /* there is no more room so make more */
     if (length < 1024) { /* length will fit in 1024, so allocate that 1024 */
      mem_sbrk(1024);
     }
     else { /* length won't fit in 1024, so allocate enough for length */
       mem_sbrk(length); 
     }

     /* look again with the new heap and from the beginning of where you just added */
      while (  (move < (long*)dseg_hi) || /* not past the end of the heap */
               (temp & 1)  ||    /* already allocated */
               (temp <= length+2) ) {  /* too small */ 
           move = move + temp; /* move the pointer to the next header */
           temp = *(int*)move; /* make temp be the length in this new header */ 
     }

   }
   else { /* it will fit so allocate */
     returnme = move + 1; /* the pointer that needs to be returned at the end */
     freelength = temp; /* the length of the entire free block */
     leftover = freelength - length; /* the left over free space if a block of size length was allocated */
     if (leftover >= 3) { /* there is still enough room left to allocate another block */
       *(int*) move = length + 1;  /* sets header to the length and adds on a 1 because allocated */ 
       move = move + (length -1); /* move to the footer of the allocated block */
       *(int*) move = length + 1; /*  sets footer to be the same as the header */

       move = move + 1; /* move to the header of the remaining free block */

       *(int*)move = leftover; /* set the header to the length of the remaining free block */
       move = move + (leftover - 1); /* move to the footer of the free block */
       *(int*)move = leftover; /* set the footer to be the same as the header */
    }  
     else { /* not enough free space left so allocate the entire free block */
       *(int*) move = freelength + 1;  /* sets the header to the length and adds on a 1 because allocated */
       move = move + (freelength -1);  /* move to the footer */
       *(int*) move = freelength + 1; /*  sets the footer to the length and adds on a 1 because allocated */
    
     }
   }
   return returnme;
}

void mm_free (void *ptr)
{
  long* middle;
  long* next;
  long* prev;
  long* start;
  long* tempend;

  middle = ptr - 1;  /* make middle pointer to the header of ptr */

  *middle = *middle & -2;  /* changes the flag to a 0 to make it mean that its free */
  tempend = middle + (*middle -1); /* changes the flag of the footer */

   /* coalesce */
   prev = middle - 1; /* find the footer of the previous block */
   if ( (*prev & 1) == 0 ) { /* the previous block is free */
    start = prev - (*prev - 1);
    *start = *start + *middle;
   }
   else { /* the previous block is not free */
     *start = *middle;
   }
   
   next = middle + *middle;  /* find header of next block after middle*/
   if ( (*next & 1) == 0){ /* the next block is free */
      *start = *middle + *next;  /* add to this block if not allocated */
      next = next + (*next - 1); /* go to the end of the next block */
      *next = *start;
    }
   else { /* the next block is not free so make a footer */
     middle = middle + (*middle + 1);
     *middle = *start;
   }
}

