/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Transient / Piss-Clams - Improved Unoptimized Algorithm ]|[",
    /* First member full name */
    "Geoff Washburn",
    /* First member email address */
    "gw2",
    /* Second member full name (leave blank if none) */
    "Matthew O'Brien",
    /* Second member email address (blank if none) */
    "mobrien"
};

/* Here's our malloc algorithm.  It's basically a hybrid segregated
   fit / buddy-system algorithm, except that we couldn't seem to get 
   the coalescing code to ever work, so it does poorly on your artificial
   tests (though rather well on the others). */  

/* Disable debugging for optimal performance */
/* #define __DEBUG__ */

/* Filler for the debug code */
#define FILL 0xdeadbeefdeadbeef

/* Header Data Size */
typedef unsigned char hds; 
/* Header Block Size */
typedef void * hbs; 

/* According to the memory layout in the notes, the heap can be no larger 
   than 2^42 */
const hds MAX_POWER = 42;

/* Minium of 16 bytes, eight for the header, eight for the data */
const hds  MIN_POWER = 4;

/* To avoid repeated function calls - These values are fixed for the
   alpha */
const unsigned long page_size = 8192;
const hds log_page_size = 13;


hds log2(unsigned long const n) {

  unsigned long i;
  hds j;

  for(i = 1, j = 0; i < n; i <<= 1, j++)
    NULL;

  return j;

}

int mm_init (void) {

  hds i, log;

  log = log2(MAX_POWER * sizeof(void *));

#ifdef __DEBUG__
  if(dseg_lo < dseg_hi)
    printf("mm_init: Heap not empty\n");
#endif
  
  if(mem_sbrk((1 << log) + 1) == NULL) 
    return -1;

#ifdef __DEBUG__
  printf("mm_init: lookup table cleared\n");
#endif

  for(i = 0; i < MAX_POWER; i++)
    ((void **) dseg_lo)[i] = NULL;

  return 0;
}

void *mmi_get_memory(long size) {

  void *address;

#ifdef __DEBUG__
  long *filler; 
#endif

  /* Store the current address of the top of the heap */
  address = dseg_hi;

  if (mem_sbrk(size) == NULL) {
    return NULL;
  } else {

#ifdef __DEBUG__
    for(filler = ((long *) address); filler < ((long *) dseg_hi); filler++)
      *filler = FILL;
#endif

    return address;
  }

}

void *mmi_split_block(void const *block, hds const size, hds csize) {

  void *address, *temp;
  hds buddy;
  void **lookup_table = ((void **) dseg_lo);

#ifdef __DEBUG__
  hds tsize = ((hds *) block)[0];
  long *filler; 

    if(csize != ((hds *) block)[0])
      printf("mmi_split_block: Original block sizes not equal: %d vs %d\n", csize,((hds *) block)[0]);
#endif

  /* Iteratively split the block until it is the appropriate size */
  for(buddy = 0, temp = NULL, address = NULL; size < csize; buddy++) {

    csize--;
    address = block + (1 << csize);

#ifdef __DEBUG__
    if(address > (block + (1 << tsize)))
      printf("mmi_split_block: Split block outside original\n");
    if((address + (1 << csize)) > (block + (1 << tsize)))
      printf("mmi_split_block: Split block outside original\n");
    if(address > ((void *) dseg_hi))
      printf("mmi_split_block: Split block outside heap\n");
    if((address + (1 << csize)) > ((void *) dseg_hi))
      printf("mmi_split_block: Split block outside heap\n");
#endif
    
#ifdef __DEBUG__
    for(filler = ((long *) address); 
        filler < ((long *) (address + (1 << csize) - 1)); filler++)
      *filler = FILL;
#endif

        
    ((hds *) address)[0] = csize;
    ((hds *) address)[1] = buddy;
    ((hds *) address)[2] = 0;
    
    temp = lookup_table[csize];
    
    if(temp != NULL) {
      
#ifdef __DEBUG__
      if(((void **) temp)[1] != NULL)
        printf("mmi_split_block: Head of list shouldn't be pointing to anything\n");
#endif

      ((void **) temp)[1] = address;
    }

    ((void **) address)[1] = NULL;
    ((void **) address)[2] = temp;
    lookup_table[csize] = address;
  } 

#ifdef __DEBUG__
  if(csize != size)
    printf("mmi_split_block: Final block sizes not equal: %d vs %d\n", csize, size);
#endif

 ((hds *) block)[0] = csize;     
 ((hds *) block)[1] += buddy;    
 ((hds *) block)[2] = 1;    
 return block;

}

void *mmi_find_block (hds const size) { 

  hds i;
  void **lookup_table = ((void **) dseg_lo);
  void *address; 

  /* Search the free-list array to see if we have any free blocks
     of new_size or larger */
  for(i = size; (lookup_table[i] == NULL) && (i < MAX_POWER); i++) {
    NULL;
  }

#ifdef __DEBUG__
    if((i < MAX_POWER) && ((lookup_table[i] <= ((void *) dseg_lo))
      || (lookup_table[i] >= ((void *) dseg_hi))))
      printf("mmi_find_block: Free-list entry %d points outside the heap\n", i);
#endif

  /* If we searched through the free-list array and found nothing, 
     allocate the size we need off the heap */
  if (i >= MAX_POWER) {

    /* If what we're allocating is smaller than a page allocate a full page */
    i = log_page_size;
    if(log_page_size < size) 
      i = size;

    /* Grab memory */
    address = mmi_get_memory((1 << i));

#ifdef __DEBUG__
    if((address != NULL) && ((address <= ((void *) dseg_lo)) || 
       (address >= ((void *) dseg_hi))))
      printf("mmi_find_block: Allocated block %x points outside the heap\n", address);
#endif
    
    /* If we've been passed a null pointer return a null pointer */ 
    if(address == NULL) 
      return NULL;

    /* Set up the proper header information */
    ((hds *) address)[0] = i;    
    ((hds *) address)[1] = 0;  
    ((hds *) address)[2] = 1;
  
    } else {  
    
      /* We've found a free block of size 2^i, get it's location from the 
         lookup table */
      address = lookup_table[i];

#ifdef __DEBUG__
      if(((hds *) address)[0] != i)
        printf("mmi_find_memory: Block with incorrect size in free-list: %d vs %d\n",((hds *) address)[0], i);
      if(((hds *) address)[2] != 0)
        printf("mmi_find_memory: Non-empty block in free-list\n");
#endif
    
     ((hds *) address)[2] = 1;    

     /* Update the head of the free-list */
    
     lookup_table[i] = ((void **) address)[2];
#ifdef __DEBUG__
    if((((void **) address)[2] != NULL) && 
      ((((void **) address)[2] <= ((void *) dseg_lo)) || 
      (((void **) address)[2] >= ((void *) dseg_hi))))
      printf("mmi_find_block: Next block in free list %x points outside the heap\n", ((void **) address)[2]);
#endif

     if(((void **) address)[2] != NULL)
       ((void **)((void **) address)[2])[1] = NULL;
        
   }

   if(size < i)
     address = mmi_split_block(address, size, i);

#ifdef __DEBUG__
    if(address > dseg_hi)
      printf("mmi_find_memory: block outside heap\n");
    if((address + (1 << size)) > dseg_hi)
      printf("mmi_find_memory: Split block outside heap\n");
#endif

  return (address + sizeof(hbs));
 
}

void *mm_malloc (size_t size) {

  hds log;

  /* If they request a block of zero size, return NULL */ 
  if (size == 0) {
    return ((void *) NULL);

  } else {
    /* Calculate the log base two so that we know the index into our 
       lookup table*/
    log = log2(size + sizeof(hbs));

    /* If they want a block that's larger than the size of the heap, return 
       null */
    if (log > MAX_POWER) {
      return ((void *) NULL);

    /* If the amount they requested is smaller than the minmum size, round 
       up */
    } else if (log < MIN_POWER) {
      log = MIN_POWER;
    }
  }

  return (mmi_find_block(log));

}

void mm_free (void *ptr) {

  hds i;
  void **lookup_table = ((void **) dseg_lo);
  void *head, *temp;
  hds size, buddy;

  /* Move us to the front of our block */

  ptr -= sizeof(hbs);

  /* Find out the size, clear the allocation information */

  size = ((hds *) ptr)[0];
  ((hds *) ptr)[2] = 0;

  /* Splice it into the appriopriate free-list */

  temp = lookup_table[size];

  if(temp != NULL)
    ((void **) temp)[1] = ptr;

  ((void **) ptr)[1] = NULL;
  ((void **) ptr)[2] = temp;
  lookup_table[size] =  ptr;


  /* Coalescing code that just doesn't quite work */

  /*

  for(i = 0; i < MAX_POWER; i++) {
    for(head = lookup_table[i]; head != NULL; head = ((void **) head)[1]) {
      buddy = ((hds *) head)[1];
      if(buddy > 0) {
        temp = head + (1 << i);

        printf("%x %x %x %x %x\n", i, buddy, ((hds *) temp)[0], ((hds *) temp)[1], ((hds *) temp)[2]);


	if( (((hds *) temp)[1] == (buddy - 1)) && 
            (((hds *) temp)[2] == 0) && (((hds *) head)[0] == i)) {

 	  ((hds *) head)[0]++;
 	  ((hds *) head)[1]--;
 	  ((hds *) head)[2] = 0;

          if(((void **) temp)[1] != NULL) {
            ((void **)((void **) temp)[1])[2] = ((void **) temp)[2];
	  } else { 
            lookup_table[i] = ((void **) temp)[2];
          }

          if(((void **) temp)[2] != NULL) 
              ((void **)((void **) temp)[2])[1] = ((void **) temp)[1];


          if(((void **) head)[1] != NULL) {
            ((void **)((void **) head)[1])[2] = ((void **) head)[2];
	  } else { 
            lookup_table[i] = ((void **) head)[2];
          }

          if(((void **) head)[2] != NULL) 
              ((void **)((void **) head)[2])[1] = ((void **) head)[1];
	  

          temp = lookup_table[i + 1];

          if(temp != NULL)
            ((void **) temp)[1] = head;;

          ((void **) head)[1] = NULL;
          ((void **) head)[2] = temp;
          lookup_table[i + 1] =  head;
	 
	  } 
      } 
    }
  }
  */
}



