/* $Id$ */

/*
 *  George Skoptsov
 *  gls@andrew.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Dazed and Confused",
    /* First member full name */
    "George Skoptsov",
    /* First member email address */
    "gls@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Alisa Yurovsky",
    /* Second member email address (blank if none) */
    "alisa@andrew.cmu.edu"
};

#define pagesize 8192
#define allocated 2

#define access(origin, offset, type) * (long *) (origin + offset * sizeof(type))
#define accessByte(origin, offset, type) * (long *) (origin + offset)
#define printf ;//just to get rid of annoying printfs

struct header // this is to give some structure to our headers
{
    struct header *next; // next free block in the list
    unsigned long int size; // size of the block in terms of headers 
    // (16 byte chunks)
};

#define base ((struct header *) (dseg_lo + 16)) // struct header
// the base of the free list. we leave 8 bytes unused, for memory alignment
#define freelist (*(struct header **) (dseg_lo)) //struct header *
// just a pointer to the free list, used for communication betwee my functions
#define pointerHead(origin, offset, type) ((struct header *) (origin + offset * sizeof(type)))
// a useful macro 

// function that was used for debugging the free list
void view_list()
{
    struct header *next = freelist->next;
    
    printf("\t VIEW LIST \n\n");
    
    if(next == freelist)
    {
	printf("***EMPTY***\n");
	return;
    }
    
    while(next != freelist && next != NULL )
    {
	printf("address: %x\t hsize: %x \t next: %x\n", next, next->size, next->next);
	next = next->next;
    }
    
    if(next == NULL)
	printf("***ERROR***\n The list is not circular\n");
    
    printf("\n");
    
    return;
}

    
// init
int mm_init (void)
{
    char * add;

    // set up the initial heap
    if((add = mem_sbrk(allocated * pagesize)) == NULL)
	return -1;
    // set up the headers and the control structures
    base->size = 0;
    base->next = base; // have our free list right after the base
    freelist  = base;
    // set up the header of the initial free block
    pointerHead(add, 4, long)->size = (allocated * pagesize -  32 - 1)/ sizeof(struct header) + 1;
        
    mm_free((void *)(pointerHead(add, 4, long) + 1)); // put it onto the free list
        
    return 0;
}

// function that increases the amount of heap
// originally, it was allocating memory in multiples of
// pagesize, but then it turned out that the performance was
// better when it allocated just the needed amount.
// Probably, it's a glitch in the grading mechanism, since
// pagesize allocation seems a better way to go. 
struct header *add_heap(long hsize)
{
    char * add;
    
    // allocate new memory based on size needed
    add = mem_sbrk(hsize * sizeof(struct header));
    //if no memory left, return NULL
    if(add == NULL)
	return NULL;
    // set up the header of the new block
    pointerHead(add, 0, char)->size = hsize;
    // put it on the free list
    mm_free((void *)(pointerHead(add, 0, char) + 1));
    return freelist;
}

    

void *mm_malloc (size_t size)
{
    

    struct header *prev, *curr;
    unsigned long hsize; //size of the block in terms of headers
//    int i=0; 
//    unsigned long temp=0;
    
    hsize= ((size + sizeof(struct header) - 1) >> 4) + 1;
    printf("size requested: %x, hsize: %x\n ", size, hsize);

    prev = freelist;
    

    // increase by
    curr = prev->next;
    
    while(1) // we'll break in the middle 
    {
	if(curr->size >= hsize)
	{
	    if(curr->size == hsize) // if equal exactly, 
		prev->next = curr->next; // take it out of the list 
	    else
	    {
		// if not, cut the block and take the latter
		curr->size -= hsize; // decrease size
		curr += curr->size; // move curr over
		// set the size for the new (allocated) block 
		curr->size = hsize;
	    }
	    freelist = prev; // make the prev next in list
	    
	    return (void *)(curr + 1); // skip the header and return
	}
	if(curr == freelist) // at which point we hit our starting point
	{
	    if((curr = add_heap(hsize)) == NULL) //if no more memory
		return NULL;
	}
	// move over to the next block
	prev = curr;
	curr = curr->next;
    }
    
    printf("nothing\n");
    
    return NULL;
}

void mm_free (void *ptr)
{
    struct header * block, * curr;
//    printf("free\n");
    
    block = (struct header *) ptr - 1;
    // this makes sure that our block is between some curr and curr-next
    // or at the end of the list
    curr = freelist;
    while(!(block > curr && block < curr->next)) // do until block is between
    { // some two consecutive ones on the list
	if(curr >= curr->next && (block > curr || block < curr->next))
	    break; // break if the end  of the list is reached
	curr = curr->next;
	
    }

    // see if there is a free block next to ours higher in memory
    // then coalesce else make it perform the first half of 
    // sticking it into the list
    if(block + block->size == curr->next)
    {
	block->size += curr->next->size;
	block->next = curr->next->next;
    }
    else
	block->next = curr->next;

    // see if there is a free block next to ours lower in memory
    // the coalesce else make it finish sticking into the list
    if(curr + curr->size == block)
    {
	curr->size += block->size;
	curr->next = block->next;
    }
    else
	curr->next = block;

    // exit and leave the freelist pointing to the current block
    freelist = curr;
}

