/* $Id$ */

/*
 *  George Skoptsov
 *  gls@andrew.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Dazed and Confused",
    /* First member full name */
    "George Skoptsov",
    /* First member email address */
    "gls@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Alisa Yurovsky",
    /* Second member email address (blank if none) */
    "alisa@andrew.cmu.edu"
};


#define allocated 1

#define access(origin, offset, type) * (long *) (origin + offset * sizeof(type))
#define accessByte(origin, offset, type) * (long *) (origin + offset)
#define printf ;//

struct header
{
	struct header *next;
	unsigned long int size;
};

#define base ((struct header *) (dseg_lo + 16)) // struct header
#define freelist (*(struct header **) (dseg_lo)) //struct header *
#define pointerHead(origin, offset, type) ((struct header *) (origin + offset * sizeof(type)))

void view_list()
{
    struct header *next = freelist->next;
    
    printf("\t VIEW LIST \n\n");
    
    if(next == freelist)
    {
	printf("***EMPTY***\n");
	return;
    }
    
    while(next != freelist && next != NULL )
    {
	printf("address: %x\t hsize: %x \t next: %x\n", next, next->size, next->next);
	next = next->next;
    }
    
    if(next == NULL)
	printf("***ERROR***\n The list is not circular\n");
    
    printf("\n");
    
    return;
}

    

int mm_init (void)
{
    char * add;
    
    if((add = mem_sbrk(allocated * mem_pagesize())) == NULL)
	return -1;
    
    base->size = 0;
    base->next = base; // have our free list right after the base
    freelist  = base;
    
    pointerHead(add, 4, long)->size = (allocated * mem_pagesize() -  32 - 1)/ sizeof(struct header) + 1;
    
    
    mm_free((void *)(pointerHead(add, 4, long) + 1)); // put it onto the free list
    
    
    return -1;
}

struct header *add_heap(long hsize)
{
    char * add;
    
    //  if(hsize * sizeof(struct header) < mem_pagesize())
//    unsigned long hsize = (i * pagesize - 1) / sizeof(struct header) + 1;
//    unsigned long hsize = (i 
    add = mem_sbrk(hsize * sizeof(struct header));
    
    if(add == NULL)
	return NULL;
    
    pointerHead(add, 0, char)->size = hsize;
    mm_free((void *)(pointerHead(add, 0, char) + 1));
    return freelist;
}

    

void *mm_malloc (size_t size)
{
    

    struct header *prev, *curr;
    unsigned long hsize;
    int i=0;
    unsigned long temp=0;
    
    
    

    hsize= (size + sizeof(struct header) - 1) / sizeof(struct header) + 1;
    printf("size requested: %x, hsize: %x\n ", size, hsize);

    prev = freelist;
    

    // increase by 
    for(curr = prev->next; ; prev = curr, curr = curr->next)
    {
	if(curr->size >= hsize)
	{
	    if(curr->size == hsize) // if equal exactly, 
		prev->next = curr->next; // 
	    else
	    {
		curr->size -= hsize;
		printf("new size: %x\n ", curr->size);
		printf("curr is was at %x ", curr);
		curr += curr->size;
//		assert(curr + hsize < dseg_hi);
		
		printf("and now is at %x\n", curr);
		printf("meanwhile, dseg_hi is %x\n", dseg_hi);
		
		curr->size = hsize;
	    }
	    freelist = prev; // make the prev next in list
	    
	    return (void *)(curr + 1); // skip the header and return
	}
	if(curr == freelist) // at which point we hit our starting point
	{
//	    while(temp<size)
//	    {
//		temp+=pagesize;
//		i++;
//	    }
	    
	    if((curr = add_heap(hsize)) == NULL)
		return NULL;
	}
	
    }
    
    printf("nothing\n");
    
    return NULL;
}

void mm_free (void *ptr)
{
    struct header * block, * curr;
//    printf("free\n");
    
    block = (struct header *) ptr - 1;
    // this makes sure that our block is between some curr and curr-next
    // or at the end of the list
    for(curr = freelist; !(block > curr && block < curr->next); curr = curr->next)
	if(curr >= curr->next && (block > curr || block < curr->next))
	    break;
    
    // see if there is a free block next to ours higher in memory
    // then coalesce else make it perform the first half of 
    // sticking it into the list
    if(block + block->size == curr->next)
    {
	block->size += curr->next->size;
	block->next = curr->next->next;
    }
    else
	block->next = curr->next;

    // see if there is a free block next to ours lower in memory
    // the coalesce else make it finish sticking into the list
    if(curr + curr->size == block)
    {
	curr->size += block->size;
	curr->next = block->next;
    }
    else
	curr->next = block;
    
    freelist = curr;
    
}

