/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "yflow",
    /* First member full name */
    "Gregory Smith",
    /* First member email address */
    "ghs",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

void *get_list_ptr(long size)
{
  int i = 0;
  while (size > 0)
    {
      i++;
      size = size >> 1;
    }
  i = i - 2;
  return (void *) ((long *) dseg_lo + i);
};

int mm_init (void)
{
  void *ptr;
  int i;
  long size;
  if (mem_usage() < mem_pagesize())
    {
      // get a new page
      ptr = mem_sbrk(mem_pagesize());
      if (ptr == NULL)
	return -1;
    }
  (char *) ptr = dseg_lo;
  // initalize the array
  for (i = 1; (1 << i) < DSEG_MAX; i++)
    {
      * (long **) ptr = NULL;
      ptr = ((long *) ptr) + 1;
    };
  // make sure everything starts out 2 byte aligned
  // if i is even, add a pointer to dseg_lo, then 1 (to make it allocated)
  if (i % 2 == 0)
    {
      * (char **) ptr = dseg_lo;
      ptr = ((long *) ptr) + 1;
      * (long *) ptr = 1L;
      ptr = ((long *) ptr) + 1;
    }
  else
    {
      * (char **) ptr = dseg_lo;
      ptr = ((long *) ptr) + 1;
      
    }
  
  // the rest of the memory will be marked as free
  // ptr should point to the first block of the big space of memory
  // put the size (in bytes) of this giant block into *ptr and mark them as free
  size = (dseg_hi - (char *) ptr) & (~7);
  * (long *) ptr = size;
  * (long *) (ptr + size - 8) = size;
  // it's the first and last; therefore its pointers are both null
  * (long **) (ptr + 8) = NULL;
  * (long *) (ptr + size - 16) = NULL;
  // lastly it needs a pointer made to it in the array
  * (long *) (get_list_ptr((long)(* ((long *) ptr)) - 32)) = (long)ptr;
  return 0;
}

void *next(void *ptr)
{
  return ((void *)  ((long) (((long *) ptr + 8)) & (long ) (~0L << 1)));
}

void *prev(void *ptr)
{
  return (void *) ((long) ((long *) ptr + ((* (long *) ptr)) - 16) & (~0L << 1));
}

void *sizeb(void *ptr)
{
  return (void *) ((long) ((long) ptr + ((* (long *) ptr)) - 8) & (~0L << 1));
}

void remove_block(void *ptr)
{
  if (* (long **) prev(ptr) == NULL)
    {
      * (long **) get_list_ptr((* (long *) ptr) & (~0 << 1)) = (long *) next(ptr);
    }
  else
    {
      * (long **) next(* (long **) prev(ptr)) = (long *) next(ptr);
    }
  if (* (long **) next(ptr) != NULL)
    * (long **) prev(* (long **) next(ptr)) = (long *) prev(ptr);
}
	
void add_block(void *ptr)
{
  * (long **) prev(ptr) = NULL;
  * (long **) next(ptr) = * (long **) get_list_ptr(* (long *) ptr);
  if (* (long **) next(ptr) != NULL)
    {
      * (long **) prev(* (long **) next(ptr)) = (long *) ptr;
    }
  * (long **) get_list_ptr(* (long *) ptr) = (long *) ptr;
}

void set_used(void *ptr)
{
  * (long *) ptr = * (long *) ptr | 1L;
  * (long *) sizeb(ptr) = * (long *) sizeb(ptr) | 1L;
}

void set_free(void *ptr)
{
  * (long *) ptr = * (long *) ptr & (~0 << 1);
  * (long *) sizeb(ptr) = * (long *) sizeb(ptr) & (~0 << 1);
}

int is_free(void *ptr)
{
  if (((long *) ptr) > (long *) dseg_lo && ((long *) ptr) < (long *) dseg_hi)
    {
      return !(* (long *) ptr & 1L);
    }
  else
    {
      return 1L;
    }
}

void coalesce(void *ptr)
{
  // 3 cases here
  // if the one in front of me is free, coalesce with it
  if (is_free((long *) ptr + * (long *) ptr))
    {
      // remove both blocks from their lists
      remove_block(ptr);
      remove_block((long *) ptr + * (long *) ptr);
      
      // modify the sizes
      * (long *) ptr = * (long *) ptr + * ((long *) ptr + * (long *) ptr);
      * ((long *) ptr + * (long *) ptr) = * (long *) ptr;
      set_free (ptr);
      
      // readd the block
      add_block(ptr);
    }
  // if the one in back is free, coalesce it!
  if (is_free((long *) ptr - * ((long *) ptr - (* (long *) (ptr - 8)))))
    {
      coalesce((long*) ptr - * ((long *) ptr - (* (long *) (ptr -8))));
    }
}

void *mm_malloc (size_t size)
{
  void *ptr;
  void *newblock;
  // round the size up to alignment
  size = (long) ((size + 7) & (~7));
  // begin at the first block size this would fit in, search the list until we find a 
  // non-NULL pointer
  ptr = (long *) get_list_ptr(size + 32);
  while ((* (long **) ptr) == NULL)
    (long *) ptr = (long *) ptr + 1;
  // if it is not dseg_lo, there is a free block
  if ((long *) ptr != (long *) dseg_lo)
    { 
      ptr = * (long **) ptr;
      if (((* (long *) ptr) - size - 8) > 2)
	// split the block
	{
	  // remove the block from the old list

	  remove_block(ptr);
	  // set up the new block
	  (long *) newblock = (char *) ptr + (size) + 32;
	  * (long *) newblock = * (long *) sizeb(ptr) - size - 32;
	  * (long *) sizeb(newblock) = * (long *) newblock;
	  * (long *) ptr = (size + 32);
	  * (long *) sizeb(ptr) = * (long *) ptr;
	  // set the free bits in the old block
	  set_used(ptr);
	  // set the free bits in the new block
	  set_free(newblock);
	  // add the new block to a free list
	  add_block(newblock);
	  // and return the allocated block
	  return (void *) ptr;
	}
      else 
	// remove the block, return the pointer
	{
	  // set the free bits
	  set_used(ptr);
	  // remove the block
	  remove_block(ptr);
	  
	  return (void *) ptr;
	}	
    }
  else
    {
      // make the heap bigger, coalesce, and try again
      // a page at a time is easier at the moment
      newblock = (long *) mem_sbrk(mem_pagesize());
      if (newblock == NULL)
	{
	  return NULL;
	};
      * (long *) newblock = mem_pagesize();
      * (long *) sizeb(newblock) = * (long *) newblock;
      
      // set the free bits in the new block
      set_free(newblock);
      
      // add the new block to a free list
      add_block(newblock);
      
      // coalesce it
      coalesce(newblock);
      
      return mm_malloc(size);
    }
  return NULL;
}

void mm_free (void *ptr)
{
  // I'm assuming ptr points to an allocated block of memory
  // mark it as free
  set_free(ptr);
  // add the block to the appropriate list
  add_block(ptr);
  // coalesce (immediate)
  coalesce(ptr);
}
