/* $Id: malloc.c,v 1.9 1999/03/10 02:21:16 et213 Exp et213 $ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
  /* Team name to be displayed on webpage */
  ".",
  /* First member full name */
  "Evan C. Tsue",
  /* First member email address */
  "ect",
  /* Second member full name (leave blank if none) */
  "",
  /* Second member email address (blank if none) */
  ""
};

/* This time we'll use a free-list, first fit w/delayed coalescing */

typedef unsigned long word;

#define DATA_BEGIN 16

struct free_header 
{
  word length;
  struct free_header *next;
  struct free_header *prev;
};

int mm_init (void)
{
  word heap_size;
  word *fh;

  if(dseg_hi - dseg_lo < 31)
    if(mem_sbrk(mem_pagesize()) == NULL)
      return -1;

  /* Note on structure:
   *   0-7:   head pointer
   *   8-15:  tail pointer
   */
  fh = (word *) ((word) dseg_lo + DATA_BEGIN);
  heap_size = (word) dseg_hi + 1 - (word) fh; 
  *((word *) dseg_lo) = *((word *) (dseg_lo + 8)) = (word) fh;
  *((word *) (dseg_hi - 7)) = *fh = heap_size;
  *(fh + 1) = *(fh + 2) = NULL;
  return 0;
}

void *mm_malloc (size_t size)
{
  word min_alloc, free_alloc;
  struct free_header *fptr, *fptr_new, *fptr_next, *fptr_prev,
    *fptr_coalesce, *fpfirst;
  word *wptr0, w_temp, *wfptr_new;

  min_alloc = (((size + 7) >> 3) << 3) + 16;  

  /* Do a best fit */
  fpfirst = (struct free_header *) *((word *) dseg_lo);
  fptr = NULL;
  w_temp = ~0UL;
  for(; fpfirst; fpfirst = fpfirst->next)
    if(fpfirst->length >= min_alloc && fpfirst->length < w_temp)
      {
	fptr = fpfirst;
	w_temp = fptr->length;
      }

  /* Coalesce (we are using a deferred coalescing scheme) */
  if(!fptr)
    {
      fptr_coalesce = NULL;

      /* Since we are going to iterate over all of the free blocks,
	 we can get a brand new exact reading for this size 
	 basically for free */
      w_temp = ~0UL;
      for(fptr = (struct free_header *) *((word *) dseg_lo); fptr;
	  fptr = fptr->next)
	{
	  /* Coalesce the blocks that are higher in memory 
	     (i.e. have a greater address) */
	  fptr_new = (struct free_header *) ((word) fptr + fptr->length);
	  while((word) fptr_new <= (word) dseg_hi
		&& (fptr_new->length & 0x1UL) == 0)
	    {
	      fptr_next = fptr_new->next;
	      fptr_prev = fptr_new->prev;
	      if(fptr_next)
		fptr_next->prev = fptr_prev;
	      else
		*((word *) dseg_lo + 1) = (word) fptr_prev;
	  if(fptr_prev)
	    fptr_prev->next = fptr_next;
	  else
	    *((word *)((word) dseg_lo)) = (word) fptr_next;
	  fptr->length += fptr_new->length;
	  *((word *) ((word) fptr + fptr->length - 8)) = fptr->length;

	  if(fptr->length >= min_alloc)
	    fptr_coalesce = fptr;

	  fptr_new = (struct free_header *) ((word) fptr + fptr->length);
	}

    }
  if(fptr_coalesce)
    {
      fptr = fptr_coalesce;
      goto do_alloc;
    }

  /* End Coalesce */

  /* We have run out of memory, we need to allocate more */

  free_alloc = min_alloc; 

  /* Check the previous block to see if we can coalesce */
  wptr0 = ((word *) (dseg_hi - 7));
  if((*wptr0 & 0x1UL) == 0)
    {
      fptr = (struct free_header *) ((word) wptr0 - *wptr0 + 8);
      w_temp = 1;
      free_alloc -= *wptr0;
    }
  else
    {
      fptr = (struct free_header *) ((word) wptr0 + 8);
      w_temp = 0;
    }
  /* w_temp = 0 represents that we cannot coalesce */

  /* Try allocating more memory from the heap, if we can't get any
     more, return NULL for failure */
  if(mem_sbrk(free_alloc) == NULL)
    return NULL;

  /* Fix the boundary tags */
  fptr->length = (word) dseg_hi + 1 - (word) fptr;
  *((word *) (dseg_hi - 7)) = fptr->length;

  /* Add this new block to the free list. */

  /* Since we are coalescing, we don't have to change any of the
     pointers, only the size of the structure, so don't do anything */
  if(!w_temp)
    {
      /* We need to append this new block of memory to the end
	 of the free list */
      fptr_new = (struct free_header *) *((word *) dseg_lo + 1);

      /* If there is no tail, we are the only element in the list */
      if(!fptr_new)
	{
	  *((word *) dseg_lo) = (word) fptr;
	  fptr->next = fptr->prev = NULL;
	}
      /* Otherwise, append this to the previous element */
      else
	{
	  fptr_new->next = fptr;
	  fptr->prev = fptr_new;
	  fptr->next = NULL;
	}

      /* Set this to be the last element */
      *((word *) dseg_lo + 1) = (word) fptr;
    }
}
  
  /* Now allocate the memory requested for the object */
do_alloc:
  free_alloc = fptr->length - min_alloc;

  /* Play with this size */
  if(free_alloc < 32)
    {
      /* Take this frame out of the free list */
      fptr_next = fptr->next;
      fptr_prev = fptr->prev;

      if(fptr_next)  fptr_next->prev = fptr_prev;
      else  *((word *) dseg_lo + 1) = (word) fptr_prev;

      if(fptr_prev)  fptr_prev->next = fptr_next;
      else  *((word *) dseg_lo) = (word) fptr_next;

      /* Fix the boundary tags */
      fptr->length |= 0x1UL;
      *((word *) ((word) fptr + fptr->length - 9)) = fptr->length;
    }
  else
    {
      /* We need to split the frame */
      wfptr_new = (word *) ((word) fptr + min_alloc);

      /* We need to replace this frame in the free list with the
	 new frame */

      fptr_next = fptr->next;
      fptr_prev = fptr->prev;
      *(wfptr_new + 1) = (word) fptr_next;
      *(wfptr_new + 2) = (word) fptr_prev;

      if(fptr_next)
	fptr_next->prev = (struct free_header *) wfptr_new;
      else
	*((word *) dseg_lo + 1) = (word) wfptr_new;

      if(fptr_prev)
	fptr_prev->next = (struct free_header *) wfptr_new;
      else
	*((word *) dseg_lo) = (word) wfptr_new;
	  
      /* Now we need to fix the boundary tags of the new frame */
      *wfptr_new = free_alloc;
      *((word *) ((word) wfptr_new + free_alloc - 8)) = free_alloc;

      /* Now fix the boundary tags of the allocated frame */
      fptr->length = 
	*((word *) ((word) fptr + min_alloc - 8)) = min_alloc | 0x1UL;
    }
  return (void *)((word) fptr + 8);
}

void mm_free (void *ptr)
{
  word *fptr, *fptr_new;

  /* We want to free up this block and put it at the tail of the free list */
  fptr = (word *) ptr - 1;

  /* Fix up the boundary tags */
  *fptr &= ~0x7UL;
  *((word *) ((word) fptr + *fptr - 8)) = *fptr;

  fptr_new = (word *) *((word *) dseg_lo + 1);

  /* If there is no tail, this is the only element in the list */
  if(!fptr_new)
    {
      *((word *) dseg_lo) = (word) fptr; 
      *(fptr + 1) = *(fptr + 2) = NULL;
    }
  else
    {
      *(fptr_new + 1) = (word) fptr;
      *(fptr + 2) = (word) fptr_new;
      *(fptr + 1) = NULL;
    }  
  /* Set this to be the last element */
  *((word *) dseg_lo + 1) = (word) fptr;   
}
