/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */
/* note to graders!!!! 

you are never going to make this file pretty, but to make it a little easier, open emacs this wide 

<------------------------------------------------------------------------------------------------------------>

Enjoy!!

*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Coilition for the ethical treatment of undergrads",
    /* First member full name */
    "Tim Howe",
    /* First member email address */
    "th3i@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Dan Rodriguez",
    /* Second member email address (blank if none) */
    "drr2@andrew.cmu.edu"
};

/* a little bit of pre-expliantion, we are implementing a "buddy" style system.
   the heap is divided into two parts, a hash table and the user memory;  In the hash
   table we have the 64 possible powers of 2 for the length of the block, the 32 possible
   subdivisions for each (actually less but it is harder to acess correctly that way).  
   The table is in the form of long_ints so that I can use position 0 as a counter.  

   Each allocated memory block has an 8-byte header (to make it allign correctly) 
   consisting of 3 short (2 byte) ints.  The first is a boolean signifying if the block
   contains data or is empty.  The second details it's length as a power of 2.  The 3rd 
   is it's position in it's column of the matrix (real-time lookup, convinient).
*/

long pow_of_2 (int n)
{
  return 1L << n;  /* Convinient function the returns powers of 2 */
}


/* Init does two things,  First it checks to see how large the existing heap is and allocates accordingly
   second it sets up our matrix (64x32) at the beginning of the heap */
int mm_init (void)
{
  long mem = mem_usage();
  long **arr;
  int x;
  short *isdata, *length, *arrloc;
  if (mem >= 24576L){ /* = 8k for memory + 64x32 matrix for my 'hash' table*/
    arr = (long **)dseg_lo; /*set beginning pointer to start of heap*/
    for (x=0;x<64;x++){
      arr[x]=(long *)((long)dseg_lo + (256 * x)); /*this sets up the subsequent arrays, each of size 32*/
    }                                             /*256 = 32 * 8 */
    for (x=0; x<32; x++){
      arr[x][0] = 0L;  /*zero out the first byte in each block*/
    }
    for (x = 0;((pow_of_2(x) != (mem - 16384L)) && (x < 63)); x++);;
    if ((pow_of_2(x) - mem - 16384L) < 0){  /*random error checking */
      return -1;
    }
    arr[x][0] = 1;    /*set up the first entry in the matrix*/
    arr[x][1] = (long)dseg_lo + 16384L + 8L; 

    isdata = (short *)(((long)dseg_lo) + 16384L); /*set up the header for the first empty block*/
    length = (short *)(((long)dseg_lo) + 16386L); /*not: 3 shorts*/
    arrloc = (short *)(((long)dseg_lo) + 16388L);

    isdata[0]=0;
    length[0]=x;
    arrloc[0]=1;
    return 0;
  }
  if (mem == -1){     /*case if there is not already memory allocated */
    mem_sbrk(24576L); /*allocate us some memory */
  } else {
    mem_sbrk(24576L - mem);  /*case if (somehow) there is memory, but not enough, make up the difference*/
  }
  arr = (long **)dseg_lo;    
  for (x = 0; x < 64; x++){
    arr[x] = (long *)((long)dseg_lo + (256 * x));
  }                                                /*set up the array like above*/
  for (x = 0; x < 32; x++){
   
    arr[x][0]=0;    /*0 out the marker row */
    
  }

  arr[13][0]=1;
  arr[13][1]= (long)dseg_lo + 16384L + 8L;        /*same as before*/

  isdata = (short *)((long)dseg_lo + 16384L);
  length = (short *)((long)dseg_lo + 16384L + 2L);
  arrloc = (short *)((long)dseg_lo + 16384L + 4L);

  isdata[0]=0;
  length[0]=13;
  arrloc[0]=1;
  return 0;
}

void *mm_malloc (size_t size) 
{
  long **CtrlStruct = (long **)dseg_lo;  /*set our pointer to desg_lo */
  short* isdata;
  short* length;
  short* arrloc;
  long finalsize = size + 8L; /*add 8 to account for the header block */
  int i, j, k, x;  
  
  for (x = 0; x < 64; x++){
    CtrlStruct[x]=(long *)((long)dseg_lo + (256 * x));
  }   /* initalize the array */
    
  /* This loop rounds size up to the nearest power of 2 */
 
  for (k = 62; pow_of_2(k) >= finalsize ; k--);;
  k++;  /* 2^k k is the blocksize we need */
    
  if (k < 0) return NULL;  /* very bad things */
 
  for (j = k; (CtrlStruct[j][0]==0) && (j <= 32); j++);; /* start looking at the block of the right size */
  i=j;                                        /* and increase until you find a free one */

  /* if you never find a free one, put some more on unitl you have enough */
  while ((CtrlStruct[i][0] == 0) || (i < k)){
    long mem = mem_usage();
    long hi = (long)dseg_hi + 1;
    for (i = 62; pow_of_2(i) > (mem - 16384L) ; i--);;
    i++;
    mem_sbrk(pow_of_2(i));
    CtrlStruct[i][0]=1;
    CtrlStruct[i][1]=hi + 8L;
    isdata = (short *) hi;
    length = (short *) (hi + 2L);
    arrloc = (short *) (hi + 4L);
    isdata[0] = 0;
    length[0] = i;
    arrloc[0] = 1;     
  }

  /* now subdivide the larger block into halves until you get the right size.*/
  while (i > k){
    i--;
    CtrlStruct[i+1][0]--;
    CtrlStruct[i][0] += 2L;
    CtrlStruct[i][CtrlStruct[i][0]-1L]=CtrlStruct[i+1][CtrlStruct[i+1][0]+1L]+pow_of_2(i); /*split in half*/
 
    isdata = (short *)(CtrlStruct[i][CtrlStruct[i][0] - 1] - 8L);  /*set up the header */
    length = (short *)(CtrlStruct[i][CtrlStruct[i][0] - 1] - 6L);
    arrloc = (short *)(CtrlStruct[i][CtrlStruct[i][0] - 1] - 4L);
    isdata[0] = 0;
    length[0] = i;
    arrloc[0] = CtrlStruct[i][0] - 1;

    CtrlStruct[i][CtrlStruct[i][0]]=CtrlStruct[i+1][CtrlStruct[i+1][0]+1L];  /*the other half */

    isdata = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 8L);
    length = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 6L);
    arrloc = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 4L);
    isdata[0] = 0;
    length[0] = i;
    arrloc[0] = CtrlStruct[i][0];
  }
    
  /* from above we know that the last block in the correct size array is the one we want , so lets set it up*/
  isdata = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 8L);
  length = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 6L);
  arrloc = (short *)(CtrlStruct[i][CtrlStruct[i][0]] - 4L);
  isdata[0] = 1;
  length[0] = i;
  arrloc[0] = -1;
  CtrlStruct[i][0]--;
  return (char *)CtrlStruct[i][CtrlStruct[i][0]+1];  /* now return the result */
  
}

/* some tricky coding ahead, watch out! */
void mm_free (void *ptr)
{
  short *isdata = (short *)((long)ptr - 8L);
  short *length = (short *)((long)ptr - 6L);
  short *arrloc = (short *)((long)ptr - 4L);
  long **arr = (long **)dseg_lo;
  long len;
  int x;
  
  for (x = 0; x < 64; x++){
    arr[x]=(long *)((long)dseg_lo + (256 * x));
  }   /* set up the array */

  len = (long)pow_of_2(length[0]); /* the length of our segment */

  if (!isdata[0]) {
    return;  /*if it is already free, we are done*/
  }
  
  if (((long)ptr + len - 8L) >= (long)dseg_hi){   /*if it is too big, we are done */
    arr[length[0]][0]++;
    arr[length[0]][arr[length[0]][0]]=(long)ptr;
    isdata[0]=0;
    
    return;
  }
  else {
    short *next = (short *)((long)ptr - 8L + len);       /*first let's look at the next block*/
    short *nextlen = (short *)((long)ptr - 6L + len);
    short *nextarrloc = (short *)((long)ptr - 4L + len);

    if ((next[0]) || (nextlen[0] != length[0])){     /*if the next block is taken or is the wrong size, cont*/
      if (((long)ptr - len) < ((long)dseg_lo + 16384L)){ /*if the previous block it OOR we're done */
	arr[length[0]][0]++;  
	arr[length[0]][arr[length[0]][0]]=(long)ptr;
	isdata[0]=0;
	return;
      }
      next = (short *)((long)ptr - 8L - len);           /*if we know the next block is no good, look at the */
      nextlen = (short *)((long)ptr - 6L - len);        /*previous block */
      nextarrloc = (short *)((long)ptr - 4L - len);
      if (nextlen[0] != length[0]){   /*if the lengths aren't the same, move on */
	arr[length[0]][0]++;
	arr[length[0]][arr[length[0]][0]]=(long)ptr;
	isdata[0]=0;
	return;
      }

      /* if all is well, then concatanate the two blocks together and do the necessary
	 bookkeeping */
      arr[nextlen[0]][nextarrloc[0]] = arr[nextlen[0]][arr[nextlen[0]][0]];  
      arr[nextlen[0]][0]--;
      nextlen[0]++;
      arr[nextlen[0]][0]++;
      arr[nextlen[0]][arr[nextlen[0]][0]] = (long)ptr - length[0];
      nextarrloc[0] = arr[nextlen[0]][0];
      mm_free((void *)((long)ptr - length[0]));
      return;

    }
    /* if the conditions are met for the next block, concatanate */
    if (!next[0]){
      arr[nextlen[0]][nextarrloc[0]] = arr[nextlen[0]][arr[nextlen[0]][0]];
      arr[nextlen[0]][0]--;
      length[0]++;
      arr[length[0]][0]++;
      arr[length[0]][arr[length[0]][0]] = (long)ptr;
      arrloc[0] = arr[length[0]][0];
      mm_free(ptr);
    }
    return;
  }

}
