/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Dave",
    /* First member full name */
    "David Koes",
    /* First member email address */
    "dkoes",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};
/* Uses segregated free lists and stores lists in the heap as instructed.
   This screws up some of the tracefiles because I end up having to use
   two memory pages instead of one since I'm not using global variables.
   I'd assume this won't be counted against me.
   
*/

typedef long Align; //for 8 byte alignment on alpha, idea from KnR

union boundary  //boundary tags
{
	struct
	{
		unsigned int displacement;  //displacement to next or previous block, four bytes
		unsigned char allocated;	//true if not bounding free block, one byte
	} tag;
	
	Align x; //8byte alignment
};

typedef union boundary BoundaryTag;

//I miss C++
#define true 1
#define false 0

//the start of each free list is stored at the very start of the heap
#define list1_2 (*((BoundaryTag**)dseg_lo))
#define list3 (*((BoundaryTag**)dseg_lo + 1))
#define list4 (*((BoundaryTag**)dseg_lo + 2))
#define list5_8 (*((BoundaryTag**)dseg_lo + 3))
#define list9_16 (*((BoundaryTag**)dseg_lo + 4))
#define list17_32 (*((BoundaryTag**)dseg_lo + 5))
#define list33_64 (*((BoundaryTag**)dseg_lo + 6))
#define list65 (*((BoundaryTag**)dseg_lo + 7))//anything larger than half a page gets put here

void *get_mem(size_t words, BoundaryTag **list); //finds free block of size words (includes tags)
void add_to_list(BoundaryTag *ptr); //adds already setup free block to appropriate list
void coalesce(BoundaryTag *ptr); //coalesce if necessary the block at ptr, updates list
BoundaryTag **get_list(BoundaryTag *ptr); //returns address of appropriate list for ptr
void unlink_ptr(BoundaryTag *ptr); //unlinks ptr from the appropriate list, displacement needs to be correct


void unlink_ptr(BoundaryTag *ptr)
{
	//printf("Unlinking %p\n", ptr );
	
	//unlink this ptr from it's list
	if( *(BoundaryTag**)(ptr+1) )  //prev not null
		*(BoundaryTag**)(*(BoundaryTag**)(ptr + 1) + 2) = *(BoundaryTag**)(ptr + 2); //previous's next now this guy's next
	else //prev null, first elem in the free list, no longer free, update list
		*get_list(ptr) = *(BoundaryTag**)(ptr + 2);
	if( *(BoundaryTag**)(ptr+2) ) //next not null
		*(BoundaryTag**)(*(BoundaryTag**)(ptr + 2) + 1) = *(BoundaryTag**)(ptr + 1); //and next's prev now this's prev		
}


BoundaryTag **get_list(BoundaryTag *ptr)
{
	unsigned int words;
	
	words = ptr->tag.displacement;
		
	if(words <= 4 )
	{
		return &list1_2;
	}	
	else if( words == 5 )
	{
		return &list3;
	}
	else if( words == 6 )
	{
		return &list4;
	}
	else if( words <= 10 )
	{
		return &list5_8;
	}
	else if( words <= 18 )
	{
		return &list9_16;
	}
	else if( words <= 34 )
	{
		return &list17_32;
	}
	else if( words <= 66 )
	{
		return &list33_64;
	}
	else
	{
		return &list65;
	}
}


void add_to_list(BoundaryTag *ptr) //prepends to free list
{
	unsigned int words;
	BoundaryTag **list;
	
	words = ptr->tag.displacement;
	list = get_list(ptr);
	
	//printf("Adding to list %p %d %p\n", list, words, ptr);
	
	*(BoundaryTag**)(ptr + 1) = NULL; //at start of list so prev null
	
	*(BoundaryTag**)(ptr + 2) = *list; //next is the first element on the list
	
	if( *list )
		*(BoundaryTag**)(*list+1) = ptr; //this element's previous needs to be updated from null
	
	*list = ptr; //beginning of list now new element

}
	
	
void coalesce(BoundaryTag *ptr) //will update the correct lists if necessary
{
	BoundaryTag *tmpptr;
	
	//printf("coalescing: %d \n", ptr->tag.displacement);
	
	if( ((ptr + ptr->tag.displacement) < (BoundaryTag*)dseg_hi) && !(ptr + ptr->tag.displacement)->tag.allocated ) 
	//not at end of heap and next block free so coalesce
	{
	
		
		tmpptr = (ptr + ptr->tag.displacement); //ptr to next block
		//printf("\tn%d %p\n", tmpptr->tag.displacement, tmpptr );
		//printf("\tpp%p\n", *(BoundaryTag**)(ptr+1) );
		//printf("\tnp%p\n", *(BoundaryTag**)(ptr+2) );
		//printf("\tlp%p %p\n", get_list(ptr), *get_list(ptr) );	
		
		//unlink both pointers	
		unlink_ptr(tmpptr);
		unlink_ptr(ptr);	

		ptr->tag.displacement += tmpptr->tag.displacement; //displacement greater now	
		(ptr + ptr->tag.displacement - 1)->tag.displacement = ptr->tag.displacement; //update end tag of block too	
		//now put it in the correct list
		add_to_list(ptr);
		
	}
	
	if( (ptr > ((BoundaryTag*)(dseg_lo) + 8)) && !(ptr - (ptr-1)->tag.displacement)->tag.allocated )
	//not at the start of the heap and previous block is free
	{
		tmpptr = ptr - (ptr-1)->tag.displacement; //prev block
		//printf("\tp%d\n", tmpptr->tag.displacement );

		//unlink both pointers
		unlink_ptr(tmpptr);
		unlink_ptr(ptr);
			
		tmpptr->tag.displacement += ptr->tag.displacement;
		(tmpptr + tmpptr->tag.displacement - 1)->tag.displacement = tmpptr->tag.displacement;
				
		add_to_list(tmpptr);
	}		
		//printf("\n");		
}


void *get_mem(size_t words, BoundaryTag **list)
{
	BoundaryTag *ptr;
	int moremem;
	
	for( ptr = *list; ; ptr = *(BoundaryTag**)(ptr+2) )
	{
		//printf("Iterating %p\n", ptr );
		if( ptr == NULL ) //list empty
		{
			if(list != &list65 ) //the current list isn't the biggest
			{
				return get_mem( words, list+1 ); //so try the next largest list
			}
			else //need to allocate more memory
			{
				moremem = mem_pagesize()*(8*words/mem_pagesize() + 1);//enough mem to fit words
				//printf("moremem %d\n", moremem);
				if( !mem_sbrk( moremem ) )
					return NULL; //no more memory
					
		   		((BoundaryTag*)(dseg_hi-7) )->tag.displacement = 
		   			((BoundaryTag*)(dseg_hi - moremem + 1))->tag.displacement = 
		   				moremem/8; 
		   			//set up boundary tags for new block
	   	
	 	   		((BoundaryTag*)(dseg_hi-7) )->tag.allocated = 
		   			((BoundaryTag*)(dseg_hi - moremem + 1))->tag.allocated = false; 
				
				add_to_list( (BoundaryTag*)(dseg_hi - moremem + 1));
				//printf("Just added a page.\n");
				coalesce( (BoundaryTag*)(dseg_hi - moremem + 1));
				
				return get_mem(words, list); //does a little extra work retraversing the list
						
			}
		}
		else if( ptr->tag.displacement >= words ) //big enough
		{
			if( ptr->tag.displacement - words < 4 ) //exactly right or two few free spaces to do anything with
			{
				//if(ptr->tag.allocated ) printf("Badness! %d %p\n", ptr->tag.displacement, *get_list(ptr));
				
				ptr->tag.allocated = true;
				(ptr + ptr->tag.displacement - 1)->tag.allocated = true; //end tag
				//unlink from free list -- no longer free
				unlink_ptr(ptr);
					
				//printf("Memory fit allocated %p l%p p%p n%p %p\n", ptr, get_list(ptr), *(BoundaryTag**)(ptr+1), *(BoundaryTag**)(ptr+2), *get_list(ptr));
				return (void*)(ptr+1); //actual block w/o boundary
					
			}
			else //more space than needed
			{
			//update allocated area, add remaining free part to free list
				size_t rest_size = ptr->tag.displacement - words;  //size of remaining block
				
				if(ptr->tag.allocated )
				{
					//printf("Badness! %d \n", ptr->tag.displacement);
				}
				//remainder
				
				//unlink from free list
				unlink_ptr(ptr);	
							
				(ptr + words)->tag.displacement = rest_size; //start tag
				(ptr + ptr->tag.displacement - 1)->tag.displacement = rest_size; //end tag
				(ptr + words)->tag.allocated = false;
				//(ptr + ptr->itag.displacement - 1)->tag.allocated = false;		//unnecessary	
						
				//allocated area
				ptr->tag.displacement = words;
				ptr->tag.allocated = true;
				(ptr + words - 1)->tag.displacement = words;
				(ptr + words - 1)->tag.allocated = true;	
		
				add_to_list( (ptr+words) ); //adds free block to appropriate list	
				
				//printf("Memory allocated %p\n", ptr);	
				return (void*)(ptr + 1);
				
			}
		}
	}
}				
			

int mm_init (void)
{
	if( !mem_sbrk( mem_pagesize() ) )
   		return -1; //initial allocation failed
   	
   	list1_2 = list3 = list4 = list5_8 = list9_16 = list17_32 = list33_64 = NULL; //lists start empty
   	
   	list65 = (BoundaryTag*)dseg_lo + 8;  //points to rest of page
   	
   	((BoundaryTag*)(dseg_hi-7 ))->tag.displacement = 
   		list65->tag.displacement = mem_pagesize()/8 - 8; 
   		//used 8 blocks, next free block not allocated yet, set up boundary tags
   	
   	((BoundaryTag*)(dseg_hi-7 ))->tag.allocated = list65->tag.allocated = false;  //not dseg_hi - 8 ?????
   	   	   	
   	*(BoundaryTag **)(&list65 + 2) = NULL; //previous free block doesn't exist
   	*(BoundaryTag **)(&list65 + 3) = NULL; //next free block isn't allocated yet
   	
   	return 0; 
   	
}

void *mm_malloc (size_t size)
{
	unsigned int nunits; //since have to be 8byte aligned, size/8 approx
	
	nunits = (size + 15)/8 + 1;  //amount needed including header
	
	//printf("Malloc called %d\n",nunits);
	if(nunits <= 4 )
	{
		return get_mem(nunits, &list1_2);
	}	
	else if( nunits == 5 )
	{
		return get_mem(nunits, &list3);
	}
	else if( nunits == 6 )
	{
		return get_mem(nunits, &list4);
	}
	else if( nunits <= 10 )
	{
		return get_mem(nunits, &list5_8);
	}
	else if( nunits <= 18 )
	{
		return get_mem(nunits, &list9_16);
	}
	else if( nunits <= 34 )
	{
		return get_mem(nunits, &list17_32);
	}
	else if( nunits <= 66 )
	{
		return get_mem(nunits, &list33_64);
	}
	else
	{
		return get_mem(nunits, &list65);
	}	
    
}

void mm_free (void *ptr)
{

//coalesces then add sfreed block to correct free list
	
	BoundaryTag *btptr;
	
	btptr = (BoundaryTag*)ptr - 1; //point btptr at boundary tag
	
	btptr->tag.allocated = (btptr + btptr->tag.displacement - 1)->tag.allocated = false;  //deallocate memory

	//printf("Freeing memory %d %p\n", btptr->tag.displacement, btptr);
	
	add_to_list(btptr); //sets pointers
	
	coalesce( (BoundaryTag*)btptr ); //coalesces and updates list if neccesary

}

