/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<FONT FACE=Verdana,Arial,Helvetica><I><U>malloc baldwin</U></I></FONT>",
    /* First member full name */
    "Chris Dornfeld",
    /* First member email address */
    "cdd2",
    /* Second member full name (leave blank if none) */
    "Janice Golenbock",
    /* Second member email address (blank if none) */
    "jsg"
};

typedef union header_union header;

struct headerFree_struct {
    unsigned long info; /* stores block size and allocated flag */
    header *next;       /* points to next free block */
    header *prev;       /* points to previous free block */
};

struct headerAlloc_struct {
    unsigned long info; /* stores block size and allocated flag */
    char data[1];       /* acts as a pointer to the block's data */
};

/* using a union means we can reuse this for free or allocated blocks */
union header_union {
    struct headerFree_struct free;
    struct headerAlloc_struct alloc;
};

struct footer_struct {
    unsigned long info;   /* stores block size and allocated flag */
    header next[1]; /* acts as a pointer to the next contiguous block */
};

typedef struct footer_struct footer;

header *freeListPtr;
header *heapStart;

/* comment out to suppress debugging output */
/* #define DEBUG */

#define ALLOC_MASK 1UL
#define WORD_SIZE 8
#define HEADER_SIZE WORD_SIZE
#define FOOTER_SIZE WORD_SIZE
/* minimum block size is 1 word for the header, 2 for pointers,
   1 for the footer */
#define MIN_BLOCK_SIZE 4 * WORD_SIZE

#define getSize(INFO) (INFO & (~ALLOC_MASK))
#define isUsed(INFO) (INFO & ALLOC_MASK)
/* calculate footer address for this block given its info block */
#define footerStart(THIS, INFO) ((footer *) ((THIS)->alloc.data + getSize(INFO) - WORD_SIZE)) 

/* write necessary data into a free block */
void writeFree(header *ourHdr, unsigned long size, header *prev, header *next) {
    footer *ourFtr = (footer *) ((unsigned long) ourHdr + HEADER_SIZE + size);

    /* set info blocks */
    ourFtr->info = ourHdr->free.info = getSize(size);

    /* set free list pointers */
    ourHdr->free.next = next;
    ourHdr->free.prev = prev;

    /* make the previous free block point to us */
    (ourHdr->free.prev)->free.next = ourHdr;

    /* make the next free block (if there is one)  point to us */
    if (ourHdr->free.next != freeListPtr) {
        (ourHdr->free.next)->free.prev = ourHdr;
    }
}

/* remove a block from the free list and make its previous and next
   blocks point to each other */
void spliceOut(header *ourHdr) {
    /* set previous free block to point to our next */
    (ourHdr->free.prev)->free.next = ourHdr->free.next;

    /* set next free block (if there is one) to point to our previous */
    if (ourHdr->free.next != freeListPtr) {
        (ourHdr->free.next)->free.prev = ourHdr->free.prev;
    }
}

/* write necessary data info an allocated block */
void writeAlloc(header *ourHdr, unsigned long size) {
    footer *ourFtr = (footer *) ((unsigned long) ourHdr + HEADER_SIZE + size);
    unsigned long newSize = getSize(size);

    /* set info blocks */
    ourFtr->info = ourHdr->free.info = newSize + ALLOC_MASK;

    spliceOut(ourHdr);
}

int mm_init (void) {
    unsigned long heapOffset, heapSize;

#ifdef DEBUG
    printf("Entering mm_init.\n");
#endif

    /* calculate offset of heap needed to satisfy alignment */
    heapOffset = (unsigned long) dseg_lo % 8;
    if (heapOffset != 0) {
        heapOffset = 8 - ((unsigned long) dseg_lo % 8);
    }

    /* calculate first block of heap, to be used as our free list pointer */
    freeListPtr = (header *) ((unsigned long) dseg_lo + heapOffset);

    /* calculate start of usable heap, just past the end of the free list
       pointer */
    heapStart = (header *) ((unsigned long) freeListPtr + MIN_BLOCK_SIZE);

    /* determine usable heap size */
    heapSize = (((unsigned long) dseg_hi - (unsigned long) heapStart + 1) >> 3) << 3;

    /* increase heap by one page if necessary */
    if (heapSize < MIN_BLOCK_SIZE || mem_usage() <= 0) {
        /* fail if mem_sbrk couldn't give us the memory */
        if (mem_sbrk(mem_pagesize()) == NULL) {
	    return -1;
	}
	heapSize = (((unsigned long) dseg_hi - (unsigned long) heapStart + 1) >> 3) << 3;
    }

    /* create free list pointer block */
    writeFree(freeListPtr, MIN_BLOCK_SIZE - HEADER_SIZE - FOOTER_SIZE, freeListPtr, heapStart);

    /* create free block out of remainder of heap */
    writeFree(heapStart, heapSize - HEADER_SIZE - FOOTER_SIZE, freeListPtr, freeListPtr);

#ifdef DEBUG
    printf("Free list pointer address: %d\nStart of heap: %d\n", (unsigned long) freeListPtr, (unsigned long) heapStart);

    printf("Exiting mm_init.\n\n");
#endif

    return 0;
}

void printFreeList() {
    header *heapPos = freeListPtr->free.next;
    unsigned long size, prev, next;

    printf("----- Free list: -----\n");

    while (heapPos != freeListPtr) {
        size = getSize(heapPos->free.info);
	prev = (unsigned long) heapPos->free.prev;
	next = (unsigned long) heapPos->free.next;

        printf("[ Address: %d | Size: %d | Prev: %d | Next: %d ]\n", (unsigned long) heapPos, size, prev, next);
	heapPos = heapPos->free.next;
    }
}

void *mm_malloc (size_t size) {
    header *heapPos, *newBlockStart;
    unsigned long pagesToAdd, actualSize, newBlockSize;

#ifdef DEBUG
    printf("Entering mm_malloc (%d bytes requested).\n", size);

    printFreeList();
#endif

    /* initialize heap position to first free block */
    heapPos = freeListPtr->free.next;

    /* figure out how big a block we'll need */
    /* round it up to the nearest word size */
    actualSize = size;
    if (actualSize < MIN_BLOCK_SIZE) {
        actualSize = MIN_BLOCK_SIZE;
    }
    if (actualSize % WORD_SIZE != 0) {
        actualSize += WORD_SIZE - (actualSize % WORD_SIZE);
    }

#ifdef DEBUG
    printf("Looking for block of actual size %d bytes.\n", actualSize);

    if (heapPos != freeListPtr) {
        printf("There are existing free blocks to check.\n");
    }
#endif

    /* try to find a free block */
    while (heapPos != freeListPtr && (unsigned long) heapPos < (unsigned long) dseg_hi && getSize(heapPos->free.info) < actualSize) {
#ifdef DEBUG
        printf("Rejected block of size %d at %d.\n", getSize(heapPos->free.info), (unsigned long) heapPos);
#endif
        /* advance to next free block */
	heapPos = heapPos->free.next;
    }

#ifdef DEBUG
    if ((unsigned long) heapPos >= (unsigned long) dseg_hi) {
        printf("heapPos >= dseg_hi!!!\n");
    }
#endif

    /* didn't find any usable free blocks */
    /* let's add some memory to the heap */
    if (heapPos == freeListPtr) {
#ifdef DEBUG
        printf("Didn't find any suitable existing free blocks.\n");
#endif

        pagesToAdd = (HEADER_SIZE + actualSize + FOOTER_SIZE) / mem_pagesize();
	if ((HEADER_SIZE + actualSize + FOOTER_SIZE) % mem_pagesize() != 0) {
	    pagesToAdd++;
	}

	newBlockStart = (header *) ((unsigned long) dseg_hi + 1);

#ifdef DEBUG
	printf("Allocating %d more pages starting at %d.\n", pagesToAdd, (unsigned long) newBlockStart);
#endif

	/* bail if we couldn't get the memory */
	if (mem_sbrk(mem_pagesize() * pagesToAdd) == NULL) {
	    return NULL;
	}

	/* align new block */
	if ((unsigned long) newBlockStart % WORD_SIZE != 0) {
	    newBlockStart = (header *) (WORD_SIZE - ((unsigned long) newBlockStart % WORD_SIZE));
	}

	/* figure out aligned size */
	newBlockSize = (((unsigned long) dseg_hi - (unsigned long) newBlockStart + 1) >> 3) << 3;

	heapPos = newBlockStart;

	/* initialize new block and splice it into the free list head */
	writeFree(heapPos, newBlockSize - HEADER_SIZE - FOOTER_SIZE, freeListPtr, freeListPtr->free.next);

#ifdef DEBUG
	printFreeList();
	printf("Converted to a block of size %d bytes at %d.\n", getSize(heapPos->free.info), (unsigned long) heapPos);
#endif
    } else {
#ifdef DEBUG
        printf("Found suitable block of size %d bytes at %d.\n", getSize(heapPos->free.info), (unsigned long) heapPos);
#endif
    }

    /* see if we can split the block we found into another free block */
    if (getSize(heapPos->free.info) > (actualSize + HEADER_SIZE + FOOTER_SIZE) + MIN_BLOCK_SIZE) {
	newBlockSize = getSize(heapPos->free.info);

	/* chop off allocated part */
	writeAlloc(heapPos, actualSize);

	/* make a new free block out of the rest, splice into the free list */
	writeFree((header *) ((unsigned long) heapPos + HEADER_SIZE + actualSize + FOOTER_SIZE), newBlockSize - actualSize - HEADER_SIZE - FOOTER_SIZE, freeListPtr, freeListPtr->free.next);
#ifdef DEBUG
        printf("Allocated %d bytes, created another free block of size %d.\n", actualSize, newBlockSize - actualSize - HEADER_SIZE - FOOTER_SIZE);
#endif

    } else {
#ifdef DEBUG
        printf("Not splitting.\n");
#endif

	/* reinitialize chosen block as allocated */
	writeAlloc(heapPos, getSize(heapPos->free.info));
    }

    /* return the address after the header of heapPos */
    heapPos = (header *) ((unsigned long) heapPos + HEADER_SIZE);

#ifdef DEBUG
    printFreeList();
    printf("Exiting mm_malloc, returning address %d.\n\n", (unsigned long) heapPos);
#endif

    return heapPos;
}

void mm_free (void *ptr) {
    footer *prevBlock;
    header *nextBlock, *freeStart;
    unsigned long origSize, totalSize;

#ifdef DEBUG
    printf("Entering mm_free.\n");
#endif

    freeStart = (header *) ((unsigned long) ptr - HEADER_SIZE);
    totalSize = origSize = getSize(freeStart->alloc.info);

#ifdef DEBUG
    printf("Requested block has size %d and starts at %d.\n", totalSize, (unsigned long) freeStart);
#endif

    /* try to coalesce backwards */
    prevBlock = (footer *) ((unsigned long) ptr - FOOTER_SIZE);

    while ((unsigned long) prevBlock > (unsigned long) heapStart && !isUsed(prevBlock->info)) {
        totalSize += getSize(prevBlock->info) + FOOTER_SIZE + HEADER_SIZE;
	freeStart = (header *) ((unsigned long) prevBlock - getSize(prevBlock->info) - HEADER_SIZE);
	/* remove previous free block from the free list */
	spliceOut(freeStart);

	prevBlock = (footer *) ((unsigned long) freeStart - FOOTER_SIZE);
    }

    /* try to coalesce forwards */
    nextBlock = (header *) ((unsigned long) ptr + origSize + FOOTER_SIZE);

    while ((unsigned long) nextBlock < (unsigned long) dseg_hi && !isUsed(nextBlock->free.info)) {
      totalSize += FOOTER_SIZE + HEADER_SIZE + getSize(nextBlock->free.info);
      /* remove next free block from the free list */
      spliceOut(nextBlock);

      nextBlock = (header *) ((unsigned long) nextBlock + HEADER_SIZE + getSize(nextBlock->free.info) + FOOTER_SIZE);
    }

#ifdef DEBUG
    printf("Freeing block of size %d starting at %d.\n", totalSize, (unsigned long) freeStart);
#endif

    /* initialize our coalesced free block and splice into the free list */
    writeFree(freeStart, totalSize, freeListPtr, freeListPtr->free.next);

#ifdef DEBUG
    printFreeList();
    printf("Exiting mm_free.\n\n");
#endif
}

