/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */


/* This memory allocation scheme  first fit for allocating memory.  The
   allocated memory and free space on the heap contains both a header and
   a footer for referencing purposes.  The headed and footer allow for 
   coalescing with both the previous and next free memory blocks. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <limits.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Chewelve",
    /* First member full name */
    "Michael Bode",
    /* First member email address */
    "bode",
    /* Second member full name (leave blank if none) */
    "Daniel Amin",
    /* Second member email address (blank if none) */
    "damin"
};

extern char* dseg_hi;
extern char* dseg_lo;

/* Constant Definitions */
#define FREELIST_HEAD ((long int *)(dseg_lo))
#define BLOCK_HEAD ((long int *)(dseg_lo+8))
#define MAX_FLAG (INT_MAX>>1<<1)
#define PAGE_SIZE (mem_pagesize())

/* The initialization process is as follows: a page of memory is obtained
from the heap and the first block (header) contains a size that points to
the last block which is marked with INT_MAX.  The next to last block 
(footer) contains the same size value as the header.  */
int mm_init (void)
{
  int ps = PAGE_SIZE;
  int space;  /* will be later assigned as an even number */
  long int* freelist_head = FREELIST_HEAD;

  if (mem_usage()!=-1)
    return -1;

  mem_sbrk(ps); 

  space = (((ps - 2) >> 3) + 1) >> 1 << 1;
 
  *freelist_head = space; 
  *(freelist_head + space -1) = space;
  *(freelist_head + space) = MAX_FLAG;
  return 0;
}

/* The malloc scheme is to use the first free block in memory that is 
greater than or equal to the size requested.  It will allocate 8 more
pages of memory whenever the heap is full.*/
void *mm_malloc (size_t size)
{
 
  long int* freelist_head = FREELIST_HEAD;
  int blocks_needed=(((size-1)>>3) + 4 ) >> 1 << 1;  /*to maintain bidirectional pointers*/ 
  
  if (size==0)
    return NULL;
 
  while(1)
    {
      if (*(freelist_head) == MAX_FLAG)
	{
	  
	  int ps = 8*PAGE_SIZE;
	  int new_size = ps>>3>>1<<1;
	  if (mem_sbrk(ps)==NULL)
	    {
	      printf("I'm out of pages");
	      return NULL;
	    }
	  
	  *(freelist_head) = new_size;
	  *(freelist_head + ((*(freelist_head)) & -2)) = MAX_FLAG;
	  *(freelist_head + ((*(freelist_head)) & -2) - 1) =  new_size;
	
	}
      
      if ((*freelist_head & 1) == 0) /*this is free memory, check it's size*/
	{
	  if(*freelist_head >= blocks_needed)
	    {
	      int old_size = *freelist_head;
	      *freelist_head = blocks_needed | 1;
   
	      *(freelist_head+blocks_needed-1) = blocks_needed | 1;
	      if (blocks_needed<old_size)
	      {
		*(freelist_head + blocks_needed) = old_size - blocks_needed;
		*(freelist_head+old_size-1) = old_size - blocks_needed;
	      }
	      return ((long int*)freelist_head+1);
	    }
	}	  
      
      freelist_head = freelist_head + ( *(freelist_head) & -2);
      
    }
 
    return NULL;
}

/* free uses the information in the block's header and footer to perform coalescing
if the previous, next, or both (the previous and next) blocks are free.
 */
void mm_free (void *ptr)
{
  int previous_free = 1, next_free = 1;
  int m1,n,m2,np,m1p,m2p;
  long int* freeptr = (long int*)ptr;
  freeptr = freeptr-1;

  n = (*freeptr);
  np = n>>1<<1;
  m1 = *(freeptr-1);
  m1p = m1>>1<<1;
  m2 = (*(freeptr + ((*freeptr) & -2)));
  m2p = m2>>1<<1;

  
  if (m1&1) /*previous block is full*/
      previous_free = 0;

  if (m2&1 || (m2==MAX_FLAG)) /*next block is full*/
      next_free = 0;

  if(next_free && previous_free)/*both free*/
    {
      *(freeptr-m1-1) = n+m1+m2;
      *(freeptr+n+m2-2) = n+m1+m2;
    }
  else if(next_free)/*ONLY next free*/
    {
      *(freeptr) = np+m2p;
      *(freeptr+np+m2p-1) = np+m2p;
    }
  else if(previous_free)/*ONLY previous free*/
    {
      *(freeptr+np-1) = np+m1p;
      *(freeptr-m1p) = np+m1p;
    }
  else /*NEITHER previous nor next free*/ 
    {
      *(freeptr) = np;
      *(freeptr+np-1) = np;
    }


}

