/* blk */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* I used the basic algorithm of First-Fit.  I defined the beginning of my
   heap to be a pointer to the first free space.  In the rest of my heap,
   all free blocks had a size and a pointer to the next free block, and all
   allocated blocks had a size only.  When passed a size allocate space for,
   if the size was small, I rounded the number to the next power of 2.  If 
   the size was large, I rounded it up to the next 8 bytes to fit alignment. */


team_t team = {
    /* Team name to be displayed on webpage */
  /* "Memory, all alone in the moonlight. Has the moon lost her memory?" */
    "She is smiling again...",
    /* First member full name */
    "barbara jensen",
    /* First member email address */
    "blk",
    /* Second member full name (leave blank if none) */
    "dean jackson",
    /* Second member email address (blank if none) */
    "dkj"
};

typedef struct head {
  void *free_block;
} head;

typedef struct block {
  int size;
  struct block *next;
} block;

/* Initialize my heap with lowest necessary amount of space.  Point the
   head of the heap to that space, and set its size and pointer  */
int mm_init (void)
{
  void *heaparea = mem_sbrk(32);
  if (heaparea == NULL) 
    return -1;

  ((head *)dseg_lo)->free_block = (dseg_lo + sizeof(head));
  ((block *)((head *)dseg_lo)->free_block)->size = (dseg_hi - dseg_lo - sizeof(head) + 1);
  ((block *)((head *)dseg_lo)->free_block)->next = NULL;
  return 0;
}

/* Rounds a number up to the next higher power of 2 */
int power2 (int n) 
{
  int p = 1;

  while (p < n) 
    p = (p << 1);

  return p;
}

/* Check if two free blocks are adjacent.  If so, merge them. */
block *merge (block *block1, block *block2)
{
  if (block1 == NULL)
    return block2;
  if (block2 == NULL)
    return block1;

  if (((char *)block1 + block1->size) == (char *)block2)
    {
      block1->size += block2->size;
      block1->next = block2->next;
      return block1;
    }
  else return block2;
}

void *mm_malloc (size_t size)
{
  block *working_block;
  block *new_free;
  block *last_block;
  block *last2;
  void *return_mem;
  size_t sizeleft;
  int off;

  working_block = (block *)((head *)dseg_lo)->free_block;
  last_block = NULL;
  last2 = NULL;

  if (size < mem_pagesize()/16)
    size = power2(size);
  else {
    if ((size % 8) != 0)
      size = ((size / 8) + 1) * 8;
  }
  size = size + sizeof(block)/2;

  /* Find first free block that fits the size */  
  while ((working_block != NULL) && (size > working_block->size)) {
    last2 = last_block;
    last_block = working_block;
    working_block = working_block->next;
  }
  
  if (working_block == NULL) {
    if ((last_block != NULL) && (((char *)last_block + last_block->size - 1) == dseg_hi)) {
      off = 1;
      sizeleft = (size - last_block->size);
    }
    else {
      off = 0;
      sizeleft = size;
    }
    
    //    factor = (sizeleft / mem_pagesize() + 1);
    //    (void *)return_mem = mem_sbrk(factor * mem_pagesize());
    (void *)return_mem = mem_sbrk(sizeleft);
    if (return_mem == NULL) 
      return NULL;
    
    working_block = (block *)return_mem;
    working_block->size = (sizeleft);
    working_block->next = NULL;

    if (off == 1) {
      working_block = merge(last_block, working_block);
      last_block = last2;
    }        
  }

  if ((working_block->size - size) <= sizeof(block)) 
    size = working_block->size;
  else {
    new_free = working_block->next;
    working_block->next = (block*)((char *)working_block + size);
    working_block->next->size = working_block->size - size;
    working_block->next->next = new_free;
  }
  
  if (last_block == NULL) 
    (block*)((head *)dseg_lo)->free_block = working_block->next;
  else 
    last_block->next = working_block->next;
  
  working_block->size = size;
  working_block->next = NULL;
  
  return_mem = (void *)((char *)working_block + sizeof(block)/2);
  return return_mem;
  
}

/* Find the free blocks before and after the ptr, and reset sizes and 
   pointers to correct information */
void mm_free (void *ptr)
{
  block *freed_block;
  block *next_block;
  block *new_block;
  block *last_block;
  
  freed_block = (block *)(ptr - (sizeof(block)/2));
  next_block = (block *)((head *)dseg_lo)->free_block;
  last_block = NULL;
  
  while ((next_block != NULL) && (next_block < freed_block)) {
    last_block = next_block;
    next_block = next_block->next;
  }
  
  if (last_block == NULL) 
    (block *)((head *)dseg_lo)->free_block = freed_block;
  else 
    last_block->next = freed_block;
  
  freed_block->next = next_block;

  new_block = merge(merge(last_block, freed_block), next_block);
 
}

