/* blk */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "She is smiling again...",
    /* First member full name */
    "barbara jensen",
    /* First member email address */
    "blk",
    /* Second member full name (leave blank if none) */
    "dean jackson",
    /* Second member email address (blank if none) */
    "dkj"
};

typedef struct head {
  void *free_block;
} head;

typedef struct block {
  int size;
  struct block *next;
} block;

int mm_init (void)
{
  void *heaparea = mem_sbrk(mem_pagesize());
  if (heaparea == NULL) 
    return -1;

  ((head *)dseg_lo)->free_block = (dseg_lo + sizeof(head));
  ((block *)((head *)dseg_lo)->free_block)->size = (dseg_hi - dseg_lo - sizeof(head) + 1);
  ((block *)((head *)dseg_lo)->free_block)->next = NULL;
  return 0;
}

block *merge (block *block1, block *block2)
{
  if (block1 == NULL)
    return block2;
  if (block2 == NULL)
    return block1;

  if (((char *)block1 + block1->size) == (char *)block2)
    {
      block1->size += block2->size;
      block1->next = block2->next;
      return block1;
    }
  else return block2;
}

void *mm_malloc (size_t size)
{
  block *working_block;
  block *new_free;
  block *last_block;
  block *last2;
  void *return_mem;
  int factor;
  size_t sizeleft;
  int off;

  working_block = (block *)((head *)dseg_lo)->free_block;
  last_block = NULL;
  last2 = NULL;
  if ((size % 8) != 0)
    size = ((size / 8) + 1) * 8;
  size = size + sizeof(block)/2;
  
  while ((working_block != NULL) && (size > working_block->size)) {
    last2 = last_block;
    last_block = working_block;
    working_block = working_block->next;
  }
  
  if (working_block == NULL) {
    if (((char *)last_block + last_block->size - 1) == dseg_hi) {
      off = 1;
      sizeleft = (size - last_block->size);
    }
    else {
      off = 0;
      sizeleft = size;
    }

    factor = (sizeleft / mem_pagesize() + 1);
    (void *)return_mem = mem_sbrk(factor * mem_pagesize());
    if (return_mem == NULL) 
      return NULL;
    
    working_block = (block *)return_mem;
    working_block->size = (factor * mem_pagesize());
    working_block->next = NULL;

    if (off == 1) {
      working_block = merge(last_block, working_block);
      last_block = last2;
    }        
  }

  if ((working_block->size - size) <= sizeof(block)) {
    size = working_block->size;
    if (working_block->next == NULL) {
      (void *)return_mem = mem_sbrk(mem_pagesize());
      if (return_mem == NULL) 
	return NULL;
      working_block->next = (block *)return_mem;
      working_block->next->size = mem_pagesize();
      working_block->next->next = NULL;
    }
  }
  else {
    new_free = working_block->next;
    working_block->next = (block*)((char *)working_block + size);
    working_block->next->size = working_block->size - size;
    working_block->next->next = new_free;
  }
  
  if (last_block == NULL) 
    (block*)((head *)dseg_lo)->free_block = working_block->next;
  else 
    last_block->next = working_block->next;
  
  working_block->size = size;
  working_block->next = NULL;
  
  return_mem = (void *)((char *)working_block + sizeof(block)/2);
  return return_mem;
  
}

void mm_free (void *ptr)
{
  block *freed_block;
  block *next_block;
  block *new_block;
  block *last_block;
  
  freed_block = (block *)(ptr - (sizeof(block)/2));
  next_block = (block *)((head *)dseg_lo)->free_block;
  last_block = NULL;
  
  while ((next_block != NULL) && (next_block < freed_block)) {
    last_block = next_block;
    next_block = next_block->next;
  }
  
  if (last_block == NULL) 
      (block *)((head *)dseg_lo)->free_block = freed_block;
  else 
    last_block->next = freed_block;
  
  freed_block->next = next_block;

  new_block = merge(merge(last_block, freed_block), next_block);
 
}

