/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jumping Monkeys",
    /* First member full name */
    "Chris Allwein",
    /* First member email address */
    "allwein",
    /* Second member full name (leave blank if none) */
    "John Corwin",
    /* Second member email address (blank if none) */
    "jcorwin"
};


#define SIGNBIT (1L<<63)

#define head ((long *)dseg_lo)
#define tail ((long *)(dseg_hi + 1))

#define page_size mem_pagesize()

/* Free blocks are positive */
long * firstfree = NULL;

long blocksize(size_t size)
{
  if (size % 8 == 0)
    return size / 8;
  else return (size + 8) / 8;
}

int mm_init (void)
{
  long initsize;      // The initial heap size

  long * mem = head;  // The initial heap

  if(mem_sbrk(page_size)==NULL)    // allocate some memory
    return -1;

  initsize = blocksize(page_size); 

  mem[0] = initsize - 2;              // set up the initial block in the heap
  mem[1] = NULL;
  mem[initsize - 1] = initsize - 2;

  firstfree = mem;     // set the free pointer to the start of the heap
  
  return 0;
}

void *mm_malloc (size_t size)
{
  long * cur = firstfree;
  long * last = NULL;
  long nextsize;
  long memsize = blocksize(size);

  while (cur)
  {
    if (cur[0] >= memsize)
    {
      nextsize = cur[0] - memsize - 2;
      if (nextsize >= 1)
      {
	// set the next block
	cur[memsize + 2] = nextsize;
	cur[cur[0] + 1] = nextsize;

	// set the free block pointer
	cur[memsize + 3] = cur[1];
		
	if (firstfree == cur)
	  firstfree = &cur[memsize + 2];
	else if (last)
	  last[1] = (long) &cur[memsize + 2];
	cur[0] = -memsize;
	cur[memsize + 1] = -memsize;
      }
      else // use the whole block
      {
	if (firstfree == cur)
	  firstfree = (long *) cur[1];
	if (last)
	  last[1] = cur[1];
	cur[cur[0] + 1] = -cur[0];
	cur[0] = -cur[0];
      }
      return &cur[1];
    }
    last = cur;
    cur = (long *) cur[1];
  }

  last = tail;
  last -= abs(last[-1]);
  // make the heap bigger
  if (last[0] > 0)
  {
    nextsize = memsize - last[0];
    if (mem_sbrk(nextsize * 8) == NULL)
      return NULL;
  }
  else
  {
    nextsize = memsize;
    if (mem_sbrk((nextsize + 2) * 8) == NULL)
      return NULL;
    last = tail - (nextsize + 2);
  }
  last[0] = -nextsize;
  last[nextsize + 1] = -nextsize;
  return &last[1];
}

long * remove_me(long * list,long *p)
{
  long * temp;
  long * last;

  if (list == NULL)
    return NULL;
  else if (list == p)
    return (long *) list[1];

  temp = list;
  last = NULL;
  while (temp && temp != p)
  {
    last = temp;
    temp = (long *) temp[1];
  }
  if (temp == p)
    last[1] = p[1];
  return list;
}

void mm_free (void *ptr)
{
  long * cur = ptr;
  //  long * next;
  long * prev;

  cur--;
  cur[0] = -cur[0];
  cur[cur[0] + 1] = cur[0];

  // Try to coalesc to the right
  /*  next = &cur[cur[0] + 2];
  if (next < tail && next[0] > 0)
  {
    // coalesc right
    cur[0] = cur[0] + next[0] + 2;
    cur[cur[0] + 1] = cur[0];

    firstfree = remove_me(firstfree,next);
    }*/

  // Try to coalesc to the left
  prev = &cur[-abs(cur[-1]) - 2];
  if (prev >= head && prev[0] > 0)
  {
    // coalesc left
    prev[0] = prev[0] + cur[0] + 2;
    prev[prev[0] + 1] = prev[0];

    return;
  }

  cur[1] = (long) firstfree;
  firstfree = &cur[0]; 
}
