/* $Id$ */

/*
 *  Andrew Paradise
 *  adp+@andrew .cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "",
    /* First member full name */
    "Andrew Paradise",
    /* First member email address */
    "adp@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Peter Fox",
    /* Second member email address (blank if none) */
    "pmf@andrew.cmu.edu"
};

int mm_init (void)
{
  long *list = (long *)dseg_lo+1l;
  if ((long)dseg_hi - (long)dseg_lo < 8)
    mem_sbrk(mem_pagesize());
  /*  *dseg_lo = ( ( ( ((long)list - (long)dseg_lo) )<<32 ) | 1);*/

  *(long*)dseg_lo = ( ((long)list - (long)dseg_lo) );
  *(long*)dseg_lo =  *(long*)dseg_lo<<32;
  *(long*)dseg_lo = *(long*)dseg_lo | 1;
  *list = 2l;
  return 0;
}


void *mm_malloc (size_t size)
{
  long int *dseg_lo8 = (long*)dseg_lo;
  long int *cp = (long*)(((long)(((long)(*dseg_lo8))>>32)&0xfffffffcl) + (long)dseg_lo8);
  long int endAlloc;
  long int *prevFree;
  long int *nextFree;  
  long int *nextUsed;
  prevFree = (long*)dseg_lo8;
  endAlloc = ((long)cp + ((size+(~size&7l)+1l)&~7l) + 8);
  /* while not tail... */
  while (!(~(*cp)&(*cp>>1)&1)){
    endAlloc = (long)cp+(long)size+8l;
    nextUsed = (long*)(((*cp)&0xfffffffcl) + (long)dseg_lo8);
    /* if enough space... */
    if (endAlloc < (long)nextUsed){
      nextFree = (long*)(((*cp>>32)&0xfffffffcl) + (long)dseg_lo8);
      /* case: split in free space is useable... add to free list */
      if ((long)*cp - endAlloc >= 2){
	/* set previous frees next pointer to start of new free */
	*prevFree = (*prevFree&0xffffffffl)|((((endAlloc-(long)dseg_lo8)&~3l)|2l)<<32);
	/* set next frees previous pointer to start of new free */
	*nextFree = (*nextFree&0xffffffffl)|((((endAlloc-(long)dseg_lo8)&~3l)|2l)<<32);
	
	/*make header... */
	/* set first halfheader to next allocated; */
	/*      set second halfheader to next free */
	*(long*)endAlloc = (*cp&0xffffffff) | 
	  (((((long)nextFree - (long)dseg_lo8)&0xfffffffc)|2)<<32);
	
	/* make footer... */
	/* set first halfheader to start of free; */
	/*      set second halfheader to previous free; */
	*(nextUsed-1l) = ((((endAlloc - (long)dseg_lo8)&0xffffffcl)|2l) |
	  (((((long)prevFree - (long)dseg_lo8)&~3l)|2l)<<32));

	/* allocate... */
	/* place header pointing to one past end of space needed plus header */
	*cp = ((*(long*)endAlloc - (long)dseg_lo8)|3l);
	/* return pointer to start of space */
	return (cp + 1);
      }else{
	/* fix freelist... */
	/* set previous free's next pointer to next free */
	*prevFree = ((*prevFree&0xffffffff)|(((((long)nextFree-(long)dseg_lo8)&~3l)|2)<<32));
	/*  set next free's previous pointer to previous free */
	*prevFree = ((*prevFree&0xffffffff)|(((((long)prevFree-(long)dseg_lo8)&~3l)|2)<<32));
	
	/* allocate... */
	/* change flag to indicate allocation */
	*cp = (*cp|3l);
	/* return pointer to start of space */
	return (cp + 1);
      }
    }else{
      /* continue... */
      /*set current pointer to next free */
      prevFree = cp;
      cp = nextFree;
    }
  }
  /* check space needs... */
  /* while (space needed plus header plus current pointer > dseg_hi) */
  /* the next line had (endAlloc + size > (long)dseg_hi) */
  while (endAlloc > (long)dseg_hi){
    /* increase heapsize by a page size */
    mem_sbrk(mem_pagesize());
  }
  /* fix freelist... */
  /* set previous frees next pointer to end of allocated */
  *prevFree = (*prevFree&0xffffffffl)|((((long)endAlloc-(long)dseg_lo8)&~3l)<<32);
  /*  make tailheader at end of allocated */
  *((long*)endAlloc) = 2L;
  
  /* allocate... */
  *cp = ((endAlloc-(long)dseg_lo8)&0xfffffffcl)|3l;
  /*  return pointer to start of space */
  return cp+1;
}  

void mm_free (void *ptr)
{
}
