/* $Id$ */
/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

/*

  NOTE: there is a previous version in the dir that scored twice as well as this one.
  The difference is that it used 2 static pointers (current, and first_unused below).
  This version saves them on the heap.

  PLEASE..PLEASE..PLEASE...if you don't really care about 2 static pointers (gradewise) 
  then grade the previous version. Thanks.

  real simple. first fit. lazy coalescing.
  8 byte header holding block size with the low bit 1 if used, 0 free

  uses a union that serves as long/pointer so as to avoid casting completely
  (ok...well close)
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define USED 1
#define FREE 0
#define HEADER_SIZE 8
/* to save/restore vars between function calls */
#define SAVE_CURRENT *((long *)dseg_lo)
#define SAVE_FIRST_UNUSED *((long *)(dseg_lo+8)) 
#define RESTORE_CURRENT (*((long *)dseg_lo))
#define RESTORE_FIRST_UNUSED (*((long *)(dseg_lo+8)))

team_t team = {
    /* Team name to be displayed on webpage */
    "Pirate Button",
    /* First member full name */
    "Andrew Brown",
    /* First member email address */
    "acb",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

union PTR
{
  long int l;
  long int *lp;
  void *v;
  union PTR *p;
};

inline void set_header(union PTR loc, long length, int used)
{
  length = length & ((-1) << 3);       /* make last 3 bits 0 */
  length = length | used;              /* sets the low bit   */
  *(loc.lp) = length;                  /* actually writes to mem */
}

int mm_init (void)
{
  union PTR temp;
  /* allocate 17 enuf to make usage 0 plus 2 pointers */
  mem_sbrk(17);

  /* save what will be current and first_unused pointers in heap */
  temp.v = dseg_lo + 16;
  /* save current */
  *((long *)dseg_lo) = temp.l;
  /* save first_unused......last cast...i swear */
  *((long *)(dseg_lo+8)) = temp.l;

  return 0;   /* normal exit */
}

void *mm_malloc (size_t size)
{
  union PTR current;      /* points to first free block                    */
  union PTR first_unused; /* points to first block of unused mem           */
  union PTR left_over;    /* more or less temp pointer                     */
  int   curr_correct = 0; /* bool indicating, 0, current needs to be fixed */
  union PTR return_value; /* hold return val if more crud done <  return   */
  union PTR search;   /* scans heap looking for big enuf free block        */
  long  free_sum = 0; /* coalescable free memory summed so far in the scan */
  union PTR free_beg; /* points to beginning of to-be coalesced block      */

  current.l = RESTORE_CURRENT;
  first_unused.l = RESTORE_FIRST_UNUSED ;

  /* round up size to nearest 8 multitple */
  size += (8 - (size % 8)) + HEADER_SIZE;

  if (size < 1) return NULL;   /* check for general nastiness   */
  
  /* while haven't found big enuf free block scan down the heap
               lazy coalescing as it goes                       */
  for (search.p = current.p, free_beg.p = current.p, curr_correct = 0;
       free_sum < size;
       search.l += ((*(search.lp)) & ((-1)<<3)))
    {
      /* if at end of unused memory */
      if (search.p == first_unused.p)
	{
	  /* if not enuf space in heap */
	  if (search.l + size >= dseg_hi)
	    {
	      /* if out of RAM..then...well bad */
	      if (mem_sbrk(size) == NULL)
		return NULL;
	    }
      	  /* mark that block as used */
	  set_header(search, size, USED);
	  
	  /* move first_unused to byte after the allocated space */
	  first_unused.l = search.l + size; 

	  /* sets current to first free block */
	  if (!curr_correct) SAVE_CURRENT = first_unused.l;
	  
	  /* app doesn't see header */
	  return_value.l = search.l + HEADER_SIZE;

	  SAVE_FIRST_UNUSED = first_unused.l;
	  return return_value.v;
	}
      /* if search points to beginning of free block */
      if ( ! (*(search.lp) & USED))
	{
	  /* corrects current to point to first free block */
	  if (!curr_correct) 
	    {
	      current.l = search.l;
	      curr_correct = 1;
	    }
	  /* if beginning of new chunk of free blocks */
	  if (free_sum == 0) free_beg.p = search.p;

	  /* increment free_sum by size */
	  free_sum += (*(search.lp)) & ((-1)<<3);
	}
      /* if not beginning of free block */
      else 
	{
	  /* if we should coalesce the previous blocks */
	  if (free_sum != 0)
	    {
	      /* set beginning of free blocks to have size 
		 of all free blocks following           */
	      set_header(free_beg, free_sum, FREE);
	      free_sum = 0;
	    }
	}
    }
  /* at this point free_beg points to beg of big enuf free block */
  /*   search.p points to the end, free_sum the total space      */

  /* mark the free_sum - size block with size and as free */
  if (free_sum - size > 0)
    {
      left_over.l = free_beg.l + size;
      set_header(left_over, free_sum - size, FREE);
    }
  /* change to-be-returned block to used */
  set_header(free_beg, size, USED);

  return_value.l = free_beg.l + HEADER_SIZE;
  
  SAVE_CURRENT = current.l;
  return (return_value.v); /* return pointer to space after header */
}

void mm_free (void *ptr)
{
  union PTR current;
  /* helper to make free call */
  union PTR p;
  p.v = ptr;
  /* test for basic bad ptr */
  if (p.l % 8)  return;
  /* go back to header */
  p.l -= HEADER_SIZE;

  current.l = RESTORE_CURRENT;
  /* update current if free something below it */
  if (p.v < current.v) 
    {
      current.l = p.l;  
      SAVE_CURRENT = current.l;
    }
  /* actually set block to FREE */
  set_header(p, (*(p.lp)) & ((-1)<<3) , FREE);
}

