/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
  /* Team name to be displayed on webpage */
  "warriors against hadiqueness",
  /* First member full name */
  "George Haff",
  /* First member email address */
  "haff",
  /* Second member full name (leave blank if none) */
  "Gary Stowasser",
  /* Second member email address (blank if none) */
  "gary"
};


/* coalesce assumes that there exist two adjacent free units, and that the input points to the first control block of the second.. it returns a pointer to the 1st control block of the new free unit */
unsigned long int *coalesce (unsigned long int *right)
{
  unsigned long int *left = right - 64;
  /* left now points to the second control block of the first (left) free unit */
  unsigned long int newsize = *left + *right + 128;
  /* new size is the sum of the old ones plus the size of the 2 control blocks that were erradicated */
  *(left - *left - 64) = newsize;
  /* first control block of left now first control block of new free unit */
  *(right + *right + 64) = newsize;
  /* 2nd c.b. of right now 2nd c.b. of new unit */
  return (left - *left - 64);
}

int mm_init (void)
{
  /* assumes pagesize > 128b and that all blocks will be at least 2-bit alligned (so the last bit of the size is a zero) */
  unsigned long int pagesize = mem_pagesize();
  unsigned long int free_space = pagesize - 128;

  if(mem_sbrk(pagesize))
    {
      *(unsigned long int*) (dseg_lo) = free_space;
      *(unsigned long int*) (dseg_lo + free_space + 64) = free_space;
      return 0;
    }
  else return -1;
  /* this initializes the heap to be all free space, with identical control blocks on each end (for forw. / rev. movement) */
  /* the control blocks consist of the size of the segment (plus 1 if alloc'd) */
}

void *mm_malloc (size_t size)
{
  unsigned long int newsize, pagesize = mem_pagesize();
  unsigned long int *p, *p2;
  unsigned long int size_long = size;
  int case1, case2, case3;
  
  printf("size: %u \n", size);
  size_long += 8 - (size_long % 8);
  p = (unsigned long int*) dseg_lo;
  
  while (1)
    /* loop until we reach a return statement */
    {
      case1 = (*p & 1)==0;
      /* the current block is not alloc'd */
      case2 = p < ((unsigned long int *)(dseg_hi));
      printf("p:     %p \n", p);
      printf("ds_hi: %p \n", ((unsigned long int *)(dseg_hi)));
      /* the current block is in range */
      case3 = *p >= size_long;
      /* the size passed to malloc will fit */
      if (case1 && case2 && case3)
	{
	  /* all cases met, add block in */
	  newsize = *p - size_long - 128;
	  *p = size_long | 1;
	  *(p + size_long + 64) = *p;
	  printf("adding block in\n");
	  /* create control blocks for new alloc'd region */
	  if (newsize > 0)
	      /* if we didnt fill the free block completely, create the new free section (by making its control blocks) */
	      {
		*(p + size_long + 128) = newsize;
		*(p + size_long + 128 + 64 + newsize) = newsize;
		printf("allocating the rest for new free space\n");
	      }

	  return (void *) (p + 64);
	}
      if (!case2)
	{
	  /* we are at the end.. (ie, we havent found enough space earlier) expand heap, coalesce, and see if that is sufficient (start the loop again from that free position we just made) */
	  p2 = mem_sbrk(pagesize);
	  printf("increasing heap\n");
	  if (p2 == NULL)
	    return NULL;
	  /* not enough room to expand the heap, so quit */
	  *p2 = pagesize - 128;
	  *(p2 + *p2 + 64) = *p2;
	  if ((1 & *p) == 0)
	    {
	      p = coalesce(p2);
	      printf("coalescing w/ new heap\n");
	    }
	  else
	    p = p2;
	}
      else
	{
	  p = p + (*p & ~1) + 128;
	  printf("going to next block, added %u \n", (*p&~1)+128);
	}
	  /* we are not in a free block, or it is of insufficient size, (and we are not at the end) so go to next one */
    }
}

void mm_free (void *ptr)
{
  /* control_block is what is stored in both of the control blocks for each memory segment.. it holds the size and also the allocation status in the lsb */
  unsigned long int *control_block_address = ((unsigned long int *) ptr) - 64;
  unsigned long int control_block = *control_block_address & (~1);
  /* wipes the alloc bit, so it is recognized as free, and actually returns the size of the unit */
  unsigned long int *second_control_block_address = control_block_address + control_block + 64;
  unsigned long int *last_control_block_address = control_block_address - 64;
  unsigned long int last_control_block = *last_control_block_address;
  /* second control block of unit just before the current one */
  unsigned long int *next_control_block_address = second_control_block_address + 64;
  unsigned long int next_control_block = *next_control_block_address;
  /* first control block of unit just after the current one */
  
  /* this section makes the allocated unit free (by changing the flag in both control blocks) */
  *control_block_address = control_block;
  *second_control_block_address = control_block;
  
  /* this section coalesces the "new" free unit with any other free units it shares a border with */
  if ((last_control_block & 1) == 0)
    coalesce(control_block_address);
  if ((next_control_block & 1) == 0)
    coalesce(next_control_block_address);
  /* both of these coalesce's do not accept the return value, as we dont need to know much about the new unit... all we need is already stored in the <whatever>_address variables above */
}
