/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

void add_free(long *ptr);
void remove_free(long *ptr);
long *search_free(size_t size);
int pick_list(size_t size);

team_t team = {
    /* Team name to be displayed on webpage */
    "Cantankerous Proto-Nazi",
    /* First member full name */
    "Yishan Wong",
    /* First member email address */
    "ywong@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Angela Saval",
    /* Second member email address (blank if none) */
    "saval@andrew.cmu.edu"
};

/*
    The current algorithm uses a next-fit implementation, with a
    segregated free list.  Next-fit was chosen since it was the simplest
    algorithm and fastest for continguous memory allocation.  A
    simple segregated free list reduces most fragmentation.

    There was code written to separate out a freed block when it was
    reallocated, so that its remainder could be added to the free
    list, but the segregated free lists do a better job fitting 
    blocks to each other.

    Coalescing code was written, but is commented out (see mm_free), 
    since it offered little benefit and introduced an enormous amount
    of overhead.  Also, since it would require the free-block
    separation code (previous paragraph) to effectively defragment 
    memory, which would introduce even _more_ overhead, it was 
    elected not to compile coalescing in the final implementation.
*/

int mm_init (void)
{

  mem_sbrk(mem_pagesize());

  ((long **)(dseg_lo))[0] = (long*)0x0L; /*used for teeny  free list */
  ((long **)(dseg_lo))[1] = (long*)0x0L; /*used for tiny   free list */
  ((long **)(dseg_lo))[2] = (long*)0x0L; /*used for small  free list */
  ((long **)(dseg_lo))[3] = (long*)0x0L; /*used for medium free list */
  ((long **)(dseg_lo))[4] = (long*)0x0L; /*used for large  free list */
  ((long **)(dseg_lo))[5] = (long*)0x0L; /*used for larger free list */
  ((long **)(dseg_lo))[6] = (long*)(dseg_lo + 56); /* lowest address */
  return 0;

}

void *mm_malloc (size_t size)
{

  long *tempbot, *tempval, *searched;
  size_t real_size;

  /* Get next available position */
  tempbot = ((long **)(dseg_lo))[6];

  /* Calculate the real size */
  real_size = ((2*sizeof(long) + size) & ~7) + 8;

  tempval = (long *)((long **)(dseg_lo))[6] + (real_size >> 3); 
  searched = search_free(size);

  /* Check if there's a free block first */
  if (searched > 0x0L)  return searched + 1;

  /* Give us a new page if we need it */
  if (tempval >= (long *)dseg_hi) {
    if (!mem_sbrk(real_size)) {
		return NULL;
	}
  }
  
  /* Mark off the boundary tags as used  */
  *(long *)((long **)(dseg_lo))[6] = real_size | 1;
  *((long *)((long **)(dseg_lo))[6] + ((real_size >> 3) - 1))=real_size|1;

  /* Update next pointer */
  ((long **)(dseg_lo))[6] = (long *)(((long **)(dseg_lo))[6]) + 
			    (real_size >> 3);
  return tempbot + 1;
}

void mm_free (void *ptr)
{
    long *p;
    /* --- Used for coalescing ---
    long *anx;
    long newlen;
       --------------------------- */
    p = (long *)ptr;
    p--;
    
    /* Marks boundary tags to unused */
    *p = (*p) & ~7;
    *(p + ((*p) >> 3) - 1) = *p;

    /* ---------- Coalescing code --------- */
    /* Coalesce previous
    while( ((*((long*)(p - 1))) & 1) == 0 
	  && ((p-1) > ((long*)(dseg_lo + 40))) ) {
	newlen = *p + *(p-1);
	anx = p - ((*(p-1)) >> 3);
	remove_free(anx);
	*anx = newlen;
	*(anx + ((*anx) >> 3) - 1) = newlen;
	p = anx;
    }*/

    /* Coalesce next 
    while( ((*(p + ((*p) >> 3))) & 1) == 0 
	  && (p + *(p + ((*p) >> 3))) < (long*)dseg_hi  ) {
	anx = p + ((*p) >> 3);
	newlen = *p + *anx;
	remove_free(anx);
	*p = newlen;
	*(anx + ((*anx) >> 3) - 1) = newlen;
    }*/
    /* -------- End coalescing code-------- */

    add_free((long *)(p));
}

void add_free(long *ptr)
{

    long *q;
    int i = pick_list(*ptr);
    q = (long*)((long **)(dseg_lo))[i];

    if ((long)*ptr < 0x20L) {
	return;
    }

    if ((long*)((long **)(dseg_lo))[i] > 0x0L) {
	(long *)*(q + 1) = ptr;  /*setting back of current*/
    }

    (long*)*(ptr + ((long)*ptr >> 3) - 2) = q; /*setting next of ptr*/
    (long*)*(ptr + 1) = (long *)0x0L; /*setting back of ptr*/
    (long*)((long **)(dseg_lo))[i] = ptr;
}



/* Removes a block from the free list.  Updates
   the back/forward pointers of the predecessor and
   successor blocks accordingly.  */
void remove_free(long *ptr)
{
    long *pf = (long*)*(ptr + ((long)*ptr >> 3) - 2);
    long *pb = (long*)*(ptr + 1);
    int i = pick_list(*ptr);

			
    if (pb > 0x0L) {  
	(long *)*(pb + ((long)*pb >> 3) - 2) = pf;
    }
    else { 
	((long **)(dseg_lo))[i] = pf;
	if (pf)
	    (long *)*(pf + 1) = (long *)0x0L; 
    }
    if (pf > 0x0L) { 
	(long*)*(pf + 1) = pb;
    } 
}



/*  Searches through the chosen list for block of
    appropriate size.  Returns zero if not found. */
long *search_free(size_t size) {
    /* the size that is passed in will be 8 bytes aligned */

    long sizeval;
    long *nextp;
    long tsval = 0;
    long *tempp;
    long counter = 0;
    int i = pick_list(size);
    nextp = (long*)((long **)(dseg_lo))[i]; 

    tsval = dseg_size;
    tempp = (long *)0x0L;

    while(nextp)  { 

	if ((counter > 0x200) || !(*nextp)) 
	    break; 
	
	sizeval = (long)*nextp;
	if (sizeval >= (long)size) {
	    if (sizeval >= (long)size) {
		remove_free(nextp);
		*(nextp + (sizeval >> 3) - 1) = sizeval | 1;
		*nextp = sizeval | 1;
		return nextp; 
	    }
	    if (tsval > sizeval) {
		tsval = sizeval;
		tempp = nextp;
	    }
	}
	counter = counter + 1;
	nextp = (long *)*(nextp + ((long)((*nextp) >> 3)) - 2);
    }
    if (tempp > 0x0L) {
	remove_free(tempp);
	return tempp;
    }
    return 0x0L; /* didn't find one that fit */
}

/* Decide which list based on size 
   Criterion are somewhat arbitrary, due to
   some guesing and experimentation */

int pick_list(size_t size) {

    if(size < 50)
	return 0;
    if(size < 256)
	return 1;
    if(size < 2184)
        return 2;
    if(size < 5000)
	return 3;
    if(size > 65535)
        return 5;
    return 4;
}
