/* $Id: malloc.c,v 1.7 1999/03/10 07:32:05 jjsmith Exp $ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define WRDSIZE 8

team_t team = {
    /* Team name to be displayed on webpage */
    "Nacho Mamas",
    /* First member full name */
    "Harlie Levine",
    /* First member email address */
    "hlevine@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Joshua Smith",
    /* Second member email address (blank if none) */
    "jjsmith@andrew.cmu.edu"
};

int  mm_expand_heap(unsigned int);

struct header *mm_coalesce();

  struct header{ 
    struct header *next_free;
    int               size;
    int               free;
  };

  struct mem_info{
  /*****   have we ever coalesced    *****/
  int  coalesce_done;
  /******   do we need to coalesce  ******/
  int  coalesce_needed;
  /***** biggest block after we have coalesced ****/
  int freeSize;
  /****** 1 pagetable size ******/
  int pagesize;
  };

  /*****  pointer to begining of our free list ***/
  unsigned long int *free_list = NULL;

  /***** ptr to the last free block ***/
  unsigned long int *free_end = NULL;

  /******  heap info at the beginning of our heap ****/
  struct mem_info *heap_info=NULL;


int mm_init (void)
{   

  if ( mem_sbrk(  mem_pagesize()  ) == NULL )
    return -1;
   
   /*   initialize our heap info */
   heap_info = (struct mem_info *)dseg_lo;
   heap_info->pagesize = mem_pagesize();
   heap_info->coalesce_done=0;
   heap_info->coalesce_needed=0;
   heap_info->freeSize=0;
  
   /* initialize our first free block */
   free_list = (unsigned long int *)dseg_lo + 2;
   ((struct header *)free_list)->next_free = NULL;
   ((struct header *)free_list)->size = heap_info->pagesize - 16;
   ((struct header *)free_list)->free = 1;

   return 0;
}

void *mm_malloc (size_t size)
{
    //ptr for iteration //
    void * temp = (void *)free_list;
    // ptr to the free_list //
    void * free_temp = (void *)free_list;
    // previous free block ptr //
    void * prev_free = (void *)free_list;
    // for a new block //
    void * new_header = NULL;

    /* Round size up to Word Alignment */
    if( size%WRDSIZE != 0)
      size = size + WRDSIZE - size%WRDSIZE;

 repeat:

    
    if(heap_info->coalesce_done == 0){

      if( (void *)temp + size + 40 > (void *)dseg_hi){
	/*  Not enough space in heap */

	if(heap_info->coalesce_needed == 1){
	  /*  coalesce and try again */
	  free_list = (unsigned long int *)mm_coalesce();
	  temp = free_list;
	  prev_free = free_list;
	  temp = (void *)free_list;
	  free_temp = (void *)free_list;
	  prev_free = (void *)free_list;
	  new_header = NULL;
	  goto repeat;
	}
	else{
          /*  we don't need to coalesce, so just expand the end of the heap */
	  ((struct header *)free_list)->size += mm_expand_heap(size - ((struct header *)free_list)->size+24);
	  goto repeat;
	}
      }
 
      else{
	/* we have enough space to fit the data */
	((struct header *)free_list)->size = size;
	((struct header *)free_list)->free = 0;
	temp = free_list;
	free_list = free_list + (size/WRDSIZE) + 2;
	((struct header *)free_list)->size = (void *)dseg_hi - (void *)free_list-16;
	((struct header *)free_list)->next_free = NULL;
	((struct header *)free_list)->free = 1;
	return temp+16;
      }

    }


    if(heap_info->coalesce_done == 1){
      /* we have coalesced and are dealing with linked lists */

      if( size > heap_info->freeSize )
	/* don't bother going through the linked list if we know it won't fit */
	temp = free_end;
      

      while( ((struct header *)temp)->size < size ){
	/*  keep checking the linked list until we find a block big enough */

	 if(  ((struct header *)temp)->next_free == NULL){
	   /* we have gotten to the end of the linked list */

	   if( heap_info->coalesce_needed == 1){
	     /* we need to coalesce again */

	     /* reset variable and try again */
	     free_list = (unsigned long int *)mm_coalesce();
	     temp = (void *)free_list;
	     free_temp = (void *)free_list;
	     prev_free = (void *)free_list;
	     new_header = NULL;

	     goto repeat;
	   }
	   else{
	     /*  there is no need to coalesce since nothing has been freed since last time */
	     ((struct header *)temp)->size += mm_expand_heap(size - ((struct header *)free_list)->size+24);
	     goto repeat;
	   }
	 }
	 /*set previous ptrs acoordingly */
	 prev_free = temp;
	 temp = ((struct header *)temp)->next_free;
	 
      }

      /* allocate space */
      
      /* check to see if the space can be broken up */
      if(  ((struct header *)temp)->size - size >= 24){
	
	/* initialize the new block */
	 new_header = temp+ size +16;
	((struct header *)new_header)->size = ((struct header *)temp)->size - size -16;
	((struct header *)new_header)->free = 1;
	((struct header *)new_header)->next_free = ((struct header *)temp)->next_free;
	((struct header *)prev_free)->next_free = new_header;
	((struct header *)temp)->size = size;

	/*check to see if we need to update the last block ptr */
	if( ((struct header *)new_header)->next_free == NULL){
	  free_end = new_header;
	}

      }
      else if( ((struct header *)temp)->next_free == NULL ){
	/* we are at the end of list and need to expand the heap */
	 ((struct header *)temp)->size += mm_expand_heap(size - ((struct header *)free_list)->size+24  );
	 goto repeat;
      }
      else{
	/* just change the prev ptr accordingly */
        ((struct header *)prev_free)->next_free = ((struct header *)temp)->next_free;
      }
      
      /* special case if we are pointing to the beginning of our free list */
      if(free_list == temp){
	free_list = (unsigned long int *)((struct header *)free_list)->next_free;
      }

      ((struct header *)temp)->next_free = NULL;
      ((struct header *)temp)->free = 0;

      return temp+16;
      
    } //if coalesce done == 1

    printf("error on malloc\n");
    return NULL;
}

void mm_free (void *ptr)
{
  /* reset ptr and set the block to free */
  ptr = ptr-16;
  ((struct header *)ptr)->free = 1;
  heap_info->coalesce_needed = 1;

}


struct header *mm_coalesce(){
  unsigned long int *index = (unsigned long int *)dseg_lo+2;
  unsigned long int *prev  = index;
  unsigned long int *start = NULL;
  struct header *next_index = NULL;
 
  heap_info->freeSize=0;

  while( (char *)index < dseg_hi ){
    /* keep iterating until we find a new block */

    if( ((struct header *)index)->free == 1  ){

      /* check to see if we can update the largest block size */
      if(((struct header *)index)->size > heap_info->freeSize)
	heap_info->freeSize=((struct header *)index)->size;

      if( start == NULL){
	/* special case if this is the first free block */
	start = index;
	prev = start;
	
	/* check for adjacent free blocks */
	next_index = (void *)index + ((struct header *)index)->size + 16;
	while( next_index->free == 1  && next_index < (struct header *)dseg_hi){
	((struct header *)index)->size += (next_index->size+16);
	((struct header *)index)->next_free = next_index->next_free;
	next_index =   (void *)index + ((struct header *)index)->size + 16;
	}

	index += (((struct header *)index)->size/WRDSIZE) +2; 
      }
      else{
	((struct header *)prev)->next_free = (struct header *)index;

	/* check for adjacent free blocks */
	next_index = (void *)index + ((struct header *)index)->size + 16;
	while( next_index->free == 1  && next_index<  (struct header *)dseg_hi){
	((struct header *)index)->size += (next_index->size+16);
	((struct header *)index)->next_free = next_index->next_free;
	next_index =   (void *)index + ((struct header *)index)->size + 16;
	}

	prev = index;
	index = (void *)index + ((struct header *)index)->size + 16;
      }
    }

    else{
      /* increment the block size and continue */
      index = (void *)index + ((struct header *)index)->size + 16;
    }
  }
  
  /* update our heap info */
  free_end = prev;
  heap_info->coalesce_done = 1;
  heap_info->coalesce_needed = 0;
  return (void *)start;
}

int  mm_expand_heap(unsigned int size){

  /* we need to allocate extra space for our next block if the data will fit exactly. ie, space = 0.
     thus, give it an extra 24 bytes */
  if( size == 0 ){
    size += 24;
  }
  
  /* expand the heap */
  if( mem_sbrk(size) != NULL)
    return size;
  else return 0;
}
