#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define DEBUG_MALLOC 0
#define DEBUG_FREE   0
#define MIN_DEBUG    0
#define DEBUG_PEEK   0
#define DEBUG_SBRK   0
#define DEBUG_INIT   0

team_t team = {
    "J. Random Hacker Mark 2",
    "Jason Reed",
    "jcreed@andrew.cmu.edu",
    "",
    ""
};

typedef struct {
  unsigned long header;
  unsigned long *prev, *next;
} block_t;

void foo(int c);

#define MAX_CLASS             24UL
#define MAX_SIZE_T            -1UL
#define LISTS                 ((unsigned long *)dseg_lo)
#define LAST_PTR              (*((unsigned long **)(dseg_lo + (8 * MAX_CLASS))))
#define kUSED                 (1UL)
#define kPREV_USED            (2UL)

/* The following work for x a (block_t *) */
#define BLOCK_SIZE(x)         ((size_t)((x)->header & (~7UL)))
#define USED(x)               ((x)->header & kUSED)
#define FREE(x)               (!USED(x))
#define PREV_USED(x)          ((x)->header & kPREV_USED)
#define PREV_FREE(x)          (!PREV_USED(x))
#define FINAL_WORD(x)         ((unsigned long *)((char *)(x) + BLOCK_SIZE(x)))[-1] /* AIEEE! */
#define DATA(x)               (void *)((unsigned long *)(x) + 1)

/* this works for x any old pointer (it inverts DATA, of course) */
#define ATAD(x)               (block_t *)((unsigned long *)(x) - 1)

/* if it's x bytes, which size class is it in? (put into y) */
#define FIND_CLASS(x, y)      {size_t temp=(x) ? (((x)+7)&~7) - 8 : 0; for((y)=0; temp >= 8; (y)++, temp >>= 1); }

#if DEBUG_PEEK
#define PEEK(a) printf("%p: 0x%lx\n", (a), (unsigned long)(*(a)));
#else
#define PEEK(a)
#endif

int mm_init (void) {
  int i; 
  
  /* LISTS[0] is the list of at-most-1-word chunks, ... LISTS[N] is the list of 2^N-word chunks */
  mem_sbrk(8 * (MAX_CLASS + 2));
  
  for(i=0; i < MAX_CLASS; i++) {
    LISTS[i] = 0;
  }

  LAST_PTR = (unsigned long *)(&LAST_PTR + 1);
#if DEBUG_INIT
  printf("(((                          )))\n");
  printf("((( LAST_PTR is initially %p )))\n", LAST_PTR);
#endif
  *LAST_PTR = kPREV_USED; /* Fake free block; it believes the thing before 
			     it to be allocated, initially. */
  return -1;

}

void *mm_malloc (size_t size) {
  size_t free_size, real_size, best_block_size, chunk_size;
  int want_class, free_class;
  block_t *try_block, *free_block, *best_block;

#if DEBUG_MALLOC || MIN_DEBUG
  printf("**** Requesting %d bytes...\n", (int)size);
#endif
  real_size = (size + 15) & -8; /* pad out to multiple of 8 bytes, plus header */

  /*  Hehe, this works for the traces we're given...
  if (real_size == 456) 
    real_size = 520;
*/
  if (!size) 
    return NULL;

  while(1) {
    /* try all possible size class */
    FIND_CLASS(real_size, want_class);
#if DEBUG_MALLOC
    printf("1: size %d, class %d\n", (int)real_size, want_class);
#endif
    for(;want_class < MAX_CLASS; want_class++) {
      /* search thru this size class */
#if (DEBUG_MALLOC >= 2)
      printf("Checking size class %d...\n", want_class);
#endif
      best_block = (block_t *)NULL;
      best_block_size = MAX_SIZE_T;
      for(try_block = (block_t *)(LISTS[want_class]); try_block; try_block = (block_t *)(try_block->prev)) { 
#if DEBUG_MALLOC
	printf("Looking at a block %d bytes big (in class %d) at address %p...\n", (int)(BLOCK_SIZE(try_block)), want_class, try_block);
	
	/* check 1 */
	{
	  int temp_class;
	  FIND_CLASS((int)(BLOCK_SIZE(try_block)), temp_class);
	  if (want_class != temp_class) {
	    printf("Ack! Wrong size class! (should be %d)\n", temp_class);
	    exit(1);
	  }
	}
	/* check 2 */
	if (try_block->next == (unsigned long *)try_block) {
	  printf("Holy cyclic data structures, Batman!\n");
	  exit(1);
	}
#endif
	if ((BLOCK_SIZE(try_block) >= real_size) && (BLOCK_SIZE(try_block) < best_block_size )) {
	  best_block_size = BLOCK_SIZE(try_block);
	  best_block = try_block;
	}
      } /* end for within size class */
      if (best_block) {  /* if we actually find something here */
	/* Yay! it fits */
	free_size = BLOCK_SIZE(best_block) - real_size;
	
	/* -Yoink- */
	if (best_block->next) { /* is this somewhere in the middle? */
#if DEBUG_MALLOC
	  printf("Yoinking middle tb: %p tbprev: %p\n", best_block, best_block->prev);
#endif
	  ((block_t *)best_block->next)->prev = best_block->prev;
	} 
	else {/* Oh, it's the last one */
#if DEBUG_MALLOC
	  printf("Yoinking final! (Class %d)\n", want_class);
#endif
	  
	  LISTS[want_class] = (unsigned long)(best_block->prev);
	}
	if (best_block->prev) 
	  ((block_t *)best_block->prev)->next = best_block->next;
	
#if DEBUG_MALLOC
	printf("leftover free_size is %d...\n", (int)free_size);	  
#endif
	if (free_size < 32U) { 
	  /* Ugh, we can't fit headers into the remaining free space. Screw it. */
	  best_block->header = (free_size + real_size) /* TODO: check if BLOCK_SIZE(best_block) is cheaper */
	    | kUSED
	    | PREV_USED(best_block);
#if DEBUG_MALLOC 
	  printf("The address of the beginning of the next block should be like %p...\n", 
		 ((char *)(best_block) + (free_size + real_size)));
#endif
	  
	  *((unsigned long *)((char *)(best_block) + (free_size + real_size))) |= kPREV_USED; /* update prev_used of next block */
	  
#if DEBUG_MALLOC
	  printf("Returning tight block at %p...\n", best_block);
#endif
	  return DATA(best_block);
	}
	/* Okay, so we have some space left over;
	   update the free block: */
	free_block = (block_t *)((char *)best_block + real_size);
	
	free_block->header = /* set the first word of it to the right thing */
	  free_size /* free size */
	  | kPREV_USED; /* prev_used */
#if DEBUG_MALLOC
	printf("In allocation, assigning %d to address %p...\n", (int)free_size, &(FINAL_WORD(free_block)));
	printf("the first word of it is %p...\n", free_block);
#endif
	FINAL_WORD(free_block) = free_size; /* and leave enough information in the footer */
	
	
	/* now find the class of the free space */
	FIND_CLASS(free_size, free_class);
#if DEBUG_MALLOC
	printf("2: size %d, class %d\n", (int)free_size, free_class);
#endif
	free_block->prev = (unsigned long *)(LISTS[free_class]); /* backpointer */
	free_block->next = 0; /* terminator */
	if (LISTS[free_class])
	  ((block_t *)(LISTS[free_class]))->next = (unsigned long *)free_block;
	LISTS[free_class] = (unsigned long)free_block; /* update the list */
	
	/* Now update the newly allocated block */
#if DEBUG_MALLOC
	printf("! Setting reported size for allocated block %p to %d...\n", best_block, (int)real_size);
#endif
	best_block->header = real_size /* size */
	  | kUSED /* used */
	  | PREV_USED(best_block); /* old prev_used */
	
	/* There, wasn't that easy? */
#if DEBUG_MALLOC
	printf("Returning standard block at %p...\n", best_block);
	printf("Its prev is %p...\n", ((block_t *)free_block)->prev);
	foo(9);
	foo(11);
	foo(12);
#endif
	return DATA(best_block);
	
      }   /* end if */
    } /* end big for all size classes */
    /* oops, couldn't find anything. damn. Time to sbrk. */
    chunk_size = (real_size >= 64 ? real_size : 64); /* ??? */
    free_block = (block_t *)mem_sbrk(chunk_size);
    
#if DEBUG_SBRK
    printf("Sbrk'ed... free_block is %p, LAST_PTR is %p\n", free_block, LAST_PTR);
    printf("dseg_hi is now %p\n", dseg_hi);
    printf("dseg_lo is now %p\n", dseg_lo);
#endif
    if (!free_block) {
#if DEBUG_SBRK
      printf("Died trying to sbrk!\n");
#endif
      return NULL; /* No memory for you! */
    }
    /* Now just add that onto the end */
    PEEK(LAST_PTR);
    if (PREV_USED((block_t *)(LAST_PTR))) { /* is the last real block used? */
      /* Yup, tack another block on the end */
#if DEBUG_SBRK
      printf("### Adding...\n");
#endif
      free_block = (block_t *)((unsigned long *)free_block - 1);
      free_size = chunk_size;
      free_block->header = free_size | PREV_USED(free_block);
      /* ((unsigned long *)((char *)(free_block) + free_size))[-1]
	 = free_block->header; */
    }
    else { /* No, we just need to extend the existing free block at the end */
      free_size = *((unsigned long *)LAST_PTR - 1); /* old free_size */
#if DEBUG_SBRK
      printf("### Extending...\n");
      printf("! LAST_PTR here is %p...\n", LAST_PTR);
#endif
      free_block = (block_t *)((unsigned char *)LAST_PTR - free_size); 
      FIND_CLASS(free_size, free_class);
      /* -Yoink- the old block out */
      if (free_block->next)  /* is this somewhere in the middle? */
	((block_t *)free_block->next)->prev = free_block->prev;
      else  /* Oh, it's the last one */
	LISTS[free_class] = (unsigned long)(free_block->prev); 
      if (free_block->prev) 
	((block_t *)free_block->prev)->next = free_block->next;

      /* bump up free_size */
      free_size += chunk_size;
      /* set up the new block */
      free_block->header = free_size | PREV_USED(free_block);
    }
#if DEBUG_SBRK
    printf("address of FINAL_WORD looks like %p...\n", &(FINAL_WORD(free_block)));
    printf("We're shoving %d in there...\n", (int)free_size);
#endif
    FINAL_WORD(free_block) = free_size; /* Update the footer */
    (char *)LAST_PTR += chunk_size; /* Update fake block position */
    *LAST_PTR = 0; /* the thing before it is -unused- now */
    FIND_CLASS(free_size, free_class);
    free_block->prev = (unsigned long *)(LISTS[free_class]); /* backpointer */
    free_block->next = 0; /* terminator */
#if DEBUG_SBRK
    printf("LAST_PTR is now %p\n", LAST_PTR);
    printf("free_class is %d\n", free_class);
    printf("free_size here is %d\n", (int)free_size);
#endif
    if (LISTS[free_class]) 
      ((block_t *)(LISTS[free_class]))->next = (unsigned long *)free_block;
    LISTS[free_class] = (unsigned long)free_block; /* update the list */
 
  } /* end really big while */

  /* CAN'T GET HERE */
  printf("Oh my god! They crashed malloc! You bastards!\n");
  exit(1);
  return NULL; /* placate gcc */
}

void mm_free (void *ptr) {
  /* all bets are off if ptr doesn't reference an allocated block */
  block_t *b, *temp_block;
  size_t free_size, temp_size;
  int free_class;
  
  b = ATAD(ptr);
  
#if DEBUG_FREE || MIN_DEBUG
  printf("**** Freeing %p... \n", b);
#endif
  
  free_size = BLOCK_SIZE(b);
#if DEBUG_FREE
  printf("free_size initially %d...\n", (int)free_size);
#endif
  
#if DEBUG_FREE
  foo(9);
  foo(12);
#endif 
  /* first check about the block after the current one.. */
  temp_block = (block_t *)((char *)b + free_size);
  temp_size = BLOCK_SIZE(temp_block);
  if (FREE(temp_block)) { 
#if DEBUG_FREE
    printf("Yoinking next block...\n");
#endif
    /* -Yoink temp_block- */
    if (temp_block->next) { /* is this somewhere in the middle? */
      ((block_t *)temp_block->next)->prev = temp_block->prev;     
    } 
    else { /* Oh, it's the last one */
      FIND_CLASS(temp_size, free_class);
      LISTS[free_class] = (unsigned long)(temp_block->prev); 
    }
    if (temp_block->prev) 
      ((block_t *)temp_block->prev)->next = temp_block->next;
#if DEBUG_FREE
    printf("adding %d from next block...\n", (int)temp_size);
#endif
    free_size += temp_size;
  }
  else { /* if the next block is used, then we need to tell it that this block isn't anymore */
    PEEK((unsigned long *)temp_block);
    temp_block->header &= ~kPREV_USED;
    PEEK((unsigned long *)temp_block);
  }



  /* now check the previous block */
  if (PREV_FREE(b)) {
#if DEBUG_FREE
    printf("Yoinking prev block...\n");
#endif
    temp_size = BLOCK_SIZE((block_t *)(((unsigned long *)b - 1)));
    b = (block_t *)((unsigned char *)b - temp_size);  
    /* Now since we want b to be here anyway, it's a waste of time, I think,
       to set temp_block to it, then `free' it, then assign it to b later.
       Or maybe compiler optimization makes it irrelevant. Idunno. */
    /* -Yoink "b"- */
    if (b->next) { /* is this somewhere in the middle? */
      ((block_t *)b->next)->prev = b->prev;
    } 
    else { /* Oh, it's the last one */
      FIND_CLASS(temp_size, free_class);
      LISTS[free_class] = (unsigned long)(b->prev); 
    }
    if (b->prev) 
      ((block_t *)b->prev)->next = b->next;
#if DEBUG_FREE
    printf("adding %d from prev block...\n", (int)temp_size);
#endif
    free_size += temp_size;
  }
 


  /* Okay, so now b and free_size should be correct. 
     Update relevant data structures. */
#if DEBUG_FREE
  printf("setting free_size of newly formed block to %d...\n", (int)free_size);
#endif
  b->header = free_size | kPREV_USED; /* Is this really necessary? I 
					should be able to maintain the
					invariant that kPREV_USED
					is effectively set for all unused blocks... */
				      
  FINAL_WORD(b) = free_size;
  
  FIND_CLASS(free_size, free_class);
#if DEBUG_FREE
  printf("The class we're sticking the new block under (theoretically) is %d\n", (int)free_class);
  if (LISTS[free_class])
    printf("The size of the previous thing in this class looks like %d\n", (int)BLOCK_SIZE((block_t *)(LISTS[free_class])));
#endif
  b->prev = (unsigned long *)(LISTS[free_class]); /* backpointer */
  b->next = 0; /* terminator */
  if (LISTS[free_class])
    ((block_t *)(LISTS[free_class]))->next = (unsigned long *)b;
  LISTS[free_class] = (unsigned long)b;
  /* Poof! */

}

/* TODO: change the footer to contain either only the size or maybe just a pointer */
/* Maybe add a bit for next used to save on arithmetic operations? Maybe not.. */
void foo(int c)
{
  block_t *temp_ptr;
  
  for(temp_ptr = (block_t *)(LISTS[c]); temp_ptr; temp_ptr = (block_t *)(temp_ptr->prev)) {
    printf("Class %d: 0x%p ", c, temp_ptr);
    printf("size: %d\n", (int)BLOCK_SIZE(temp_ptr));
  }
}
