/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

/*  How I went about this:
    I used first fit for the malloc function.  There's really nothing special or tricky to it.  My free clears out the lowest bit meaning that the block is not allocated.  Then it coalesces. */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "whatever",
    /* First member full name */
    "Hope Welsch",
    /* First member email address */
    "hwelsch@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{
     int size;
     char* fail;

     size = mem_usage();  /* get the current size of the heap */
     if (size == -1) {  /* if the heap is empty */
       fail = mem_sbrk(8192); /* set the initial heap size */  
       if (fail == NULL) { /* mem_sbrk returned that there is no more memory left */
         return -1;
       }
       else { /* mem_sbrk worked */
         *((int*)(dseg_lo)) = 1024;  /* sets the initial header size */
         *((int*)(dseg_hi-7)) = 1024;  /* sets the initial footer size */
	 return 0;
       }
     }
     else { /* the heap is not empty */
       *((int*)(dseg_lo)) = (size + 1)/8;  /* sets the header size to the size of the heap */
       *((int*)(dseg_hi-7)) = (size + 1)/8;  /* sets the footer size to the size of the heap*/
       return 0;
   }
}


void *mm_malloc (size_t size)
{
    int length;
    int temp;
    long* move;
    int freelength;
    int leftover;
    long* returnme;
    char* fail;

    /* get the length (8 byte aligned) of the pointer you're going to need to allocate */
    length = size / 8; 
    if (size % 8 != 0) {
	length = length + 1;
    }
    if (length % 2 != 0) { /* length is odd, so add one so that I can use the last bit for a flag */
      length = length + 1;
    }

    /* look through the heap for a spot to allocate the space */
    /* first fit */
    temp = *((int*)(dseg_lo)); /* temp is the length of the first block */
    move = (long*)(dseg_lo); /* pointer to first thing in the heap */

    /* progress through the heap until you find a place to allocate or you hit the end of the heap */
    while (  (move < (long*)(dseg_hi)) && /* not past the end of the heap */
            ( (temp & 1)   ||    /* already allocated */
             ( (temp & -2) < (length+2) ) ) ) {  /* too small */ 

      move = move + (temp & -2);  /* move the pointer to the next header */
      temp = *((int*)(move));  /* make temp be the length in this new header */    }
    
   if (move >= (long*)(dseg_hi))  { /* there is no more room so make more */
     if (length + 2 < 1024) { /* length will fit in 1024, so allocate that 1024 */
      fail = mem_sbrk(8192);
      if (fail == NULL) {
        return NULL;
      }
      *((int*)(fail)) = 1024;  /* sets the header size of new block */
      *((int*)(dseg_hi-7)) = 1024;  /* sets the footer sizeof new block */
     }
     else { /* length won't fit in 1024, so allocate enough for length */
       fail = mem_sbrk( (8*length) + 16); 
       if (fail == NULL) {
         return NULL;
       }
       *((int*)(move)) = length+2;  /* sets the header size of new block */
       *((int*)(dseg_hi-7)) = length+2;  /* sets the footer sizeof new block */
     }

    move = (long*)fail;
    temp = *((int*)(fail)); /* temp is the length of the new block */
   }

 /* it will fit so allocate */
     returnme = move + 1; /* the pointer that needs to be returned at the end */
     freelength = temp; /* the length of the entire free block */
     leftover = freelength - (length + 2); /* the left over free space if a block of size length was allocated */
     if (leftover >= 4) { /* there is still enough room left to allocate another block */
       *(int*)(move) = (length + 2) | 1 ;  /* sets header to the length and ors on a 1 because allocated */
       move = move + (length + 1); /* move to the footer of the allocated block */
       *(int*)(move) = (length + 2) | 1; /*  sets footer to be the same as the header */

       move = move + 1; /* move to the header of the remaining free block */

       *(int*)(move) = leftover; /* set the header to the length of the remaining free block */
       move = move + (leftover - 1); /* move to the footer of the free block */
       *(int*)(move) = leftover; /* set the footer to be the same as the header */
    }  
     else { /* not enough free space left so allocate the entire free block */
       *(int*)(move) = freelength | 1;  /* sets the header to the length and adds on a 1 because allocated */
       move = move + (freelength -1);  /* move to the footer */
       *(int*)(move) = freelength | 1; /*  sets the footer to the length and adds on a 1 because allocated */
    
     }
   
   return returnme;
}

void mm_free (void *ptr)
{
  long* middle;
  long* next;
  long* prev;
  long* start;
  long* tempend;

  middle = (long*)ptr - 1;  /* make middle pointer to the header of ptr */

  *((int*)middle) = *((int*)middle) & -2;  /* changes the flag to a 0 to make it mean that its free */
  tempend = middle + ((*(int*)middle) - 1); /* changes the flag of the footer */
  *((int*)tempend) = (*(int*)tempend) & -2;

   /* coalesce */
   prev = middle - 1; /* find the footer of the previous block */
   if ( ( (*(int*)prev) & 1) == 0 ) { /* the previous block is free */
    start = prev - ((*(int*)prev) -1);
    (*(int*)start) =  (*(int*)start) + (*(int*)middle); 
   }
   else { /* the previous block is not free */
     start = middle;
   }
   
   next = middle + (*(int*)middle);
   /* find header of next block after middle*/
   if ( ((*(int*)next)  & 1) == 0){ /* the next block is free */
      (*(int*)start) = (*(int*)start) + (*(int*)next);  /* add to this block if not allocated */
      next = next + ((*(int*)next) - 1); /* go to the end of the next block */
      (*(int*)next) = (*(int*)start);
    }
   else { /* the next block is not free so make a footer */
     tempend = start + ((*(int*)start) - 1);
     (*(int*)tempend) = (*(int*)start);
   }
}

