/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */
/*THIS IS A BEST-FIT IMPLEMNTATION OF MALLOC*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Antioch",
    /* First member full name */
    "Matthew James Geyer",
    /* First member email address */
    "geyer",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#define FREELIST_HEAD ((freeblk_t *)(dseg_lo))
#define BLOCK_HEAD ((freeblk_t *)(dseg_lo+8))
#define INT_MAX          2147483647     /* max value for an int */

void* next (void *mem_loc);
long size (void *mem_loc);
long is_prev_full(void *mem_loc);
long is_curr_empty(void *mem_loc);
long not_last_block(void *mem_loc);

int mm_init (void)
{
  int *block;

printf("init\n");
  mem_sbrk(8);

  block = (int *)(dseg_lo);

  /*initialize first block info*/

  block[0] = 20971512; /*20MB - 8*/

  block[1] = 5L; /*last_block = true, prev_empty = false, curr_empty = true*/

  return 0;
}

void *mm_malloc (size_t size)
{
  void * current_loc;
  void * bestfit = NULL; /*the bestfit sofar*/
  int wasted=INT_MAX; /*the amount of space left in the block not used*/
  int temp;
  int *block;
  int prev=0; /*is the previous block used?*/
  int msize; /*the actual size you malloc, has to be a multiple of 8*/
  int temp2;

  msize = size%8;


  if(msize != 0)
    msize = size - msize + 8; /*make sure the size is a multiple of 8*/
  else
    msize = size;


  current_loc = (dseg_lo);
  /*scan thru list, find best fit*/

  while(not_last_block(current_loc)) 
    {
      block = (int *)(current_loc);
      if(is_curr_empty(current_loc))
	{

	  temp = block[0]-msize;
	  if(temp >= 0 && temp < wasted)
	    {
	      wasted = temp;
	      bestfit = current_loc;
	    }
	}
      prev = (block[1] & 1L) << 1L; /*prev = 2 if empty...*/
      current_loc = next(current_loc);
    }

  /* FOUND A MATCHING BLOCK THAT IS NOT THE LAST BLOCK*/
  if(bestfit !=NULL)
    {      
      /*modify current block*/
      block = (int *)(bestfit);
      block[0] = msize;
      block[1] = prev; 

      if(wasted!=0)
	/*modify next block*/
	{
	  current_loc = next(bestfit);
	  block = (int *)(current_loc);
	  block[0] = wasted-8; /*size of empty block is listed as size-8*/
	  block[1] = 1; /*set the previous block bit as full, current block
			 as empty and not the last block*/
	}
      else /*if it happens to be the exact size*/
	{
	  current_loc = next(bestfit);
	  block = (int *)(current_loc);

	  block[1] = block[1] | 2L; /*set the previous block bit as full*/
	}
      return (bestfit +8);
    }
  /*otherwhise, check to see if the last block fits*/
  block = (int *)(current_loc); /*current_loc is always last block here...*/
  temp = block[0]-msize;

  /*IF THE LAST BLOCK FITS*/
  if(temp > 0 && temp < wasted && is_curr_empty(current_loc))
    {


      /*setting the memory breaks in increments of pagesize*/
       mem_sbrk(msize + 8);

/*       temp2 = msize +8; */
/*       temp = temp2 % mem_pagesize(); */
/*       if(temp2-temp != 0) */
/* 	mem_sbrk(temp2 - temp); */
/*       if(((long)dseg_hi - (long)current_loc)<= temp) */
/* 	mem_sbrk(mem_pagesize()); */
      if((long)dseg_hi < (long)current_loc)
	{

	  mem_sbrk(msize + 8);
	}
      /*finished setting the memory breaks*/


      bestfit = current_loc;
      /*modify block 000 if prev is empty 010 if full*/
      block[0] = msize;
      block[1] = prev; 
      
      if(wasted!=0)
	/*modify next block*/
	{
	  current_loc = next(current_loc);
	  block = (int *)(current_loc);
	  block[0] = wasted-8; /*size of empty block is listed as size-8*/
	  block[1] = 5L; /*set the previous block bit as full*/
	  /*and set this block as the lastblock and empty*/
	}
      
      return bestfit+8;
    }
  /*NO MATCHES FOUND*/

    return NULL;

}

void mm_free (void *ptr)
{
/*   int *block; */
/*   int *block_n; */ /*neighbor block*/
/*   void *current_loc; */
/*   void *prev_loc; */

  /*free the memory and coallesce..*/
/*   block = (int *)(ptr-8); */
/*   printf("freeing %d of memory at %d \n", block[0], block); */
/*   block[1] = block[1] | 1L;  *//*sets the first bit to 1 (current block is empty)*/  

/*coallesce*/

  /*try to coallesce with next*/
  /*check to see if this is the last block*/


/*   if(not_last_block(block)) */
/*     { */
/*       current_loc = next(block); */
/*       if(is_curr_empty(current_loc)) */
/* 	{ */
/* 	  block_n = (int *)(current_loc); */
	  /*coallesce with next*/
/* 	  block[0] = block[0] + block_n[0]; */
/* 	  block[0] = block[0] + 8; */
	  /*check to see if next was last block*/
/* 	  block[1] = (block_n[1] & 4L) | block[1];	     */
/* 	} */
/*     } */


  /*try to coallesce with prev*/
/*   if(!is_prev_full(block)) */
/*     { */
      /*coallesce with prev*/
      /*find prev address*/
/*       current_loc = dseg_lo; */
/*       while(current_loc != block) */
/* 	{ */
/* 	  prev_loc = current_loc; */
/* 	  current_loc = next(current_loc); */
/* 	} */
      /*coallesce with prev_loc*/
/*       block_n = (int *)(prev_loc); */
      /*coallesce with prev*/
/*       block_n[0] = block_n[0] + block[0] + 8; */
      /*check to see if block was last block*/
/*       block_n[1] = (block[1] & 4L) | block_n[1]; */
/*       block = block_n; */
/*     } */

  /*if not lastblock*/
/*   if(not_last_block(block)) */
/*     { */
      /*then modify next block*/
/*       current_loc = next(block); */
/*       block = (int *)(current_loc); */
/*       block[1] = block[1] & 2L; */
/*     } */
/*   printf("i should be freeing memory\n"); */
/*   printf("done not freeing memory\n"); */
}



/************HELPER FUNCTIONS***********/
/* returns the address of the next block */
void* next (void *mem_loc)
{
  int *block;
  block = (int *)(mem_loc);

  if (block[0]==0)
    return NULL;
  return mem_loc + block[0]+8;
}
/* returns the size of the allocated block */
long size (void *mem_loc) 
{
  int *block;
  block = (int *)(mem_loc);

  return block[0];
}

/* returns 0 if the previous block is empty else 1 */
long is_prev_full(void *mem_loc)
{
  int *block;
  block = (int *)(mem_loc);

  return !(block[1] & 2L);
}

/*is the current memlocation/ block empty*/

long is_curr_empty(void *mem_loc)
{
  int *block;
  block = (int *)(mem_loc);

  return (block[1] & 1L);
}

/* returns 0 if this is the last block in the free block list */
long not_last_block(void *mem_loc)
{
  int *block;
  block = (int *)(mem_loc);

  return !(block[1] & 4L);
}
