/*
  we use implicit bidirectional lists with 2 8-byte headers
  next fit was used where CURPOS holds the start of the search

  just like in the 1st memory management lecture page 9 slide 18
*/


/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Mania",
    /* First member full name */
    "Eugene Cheleshkin",
    /* First member email address */
    "eugenec@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "Rahul Caprihan",
    /* Second member email address (blank if none) */
    "rahulc@andrew.cmu.edu"
};

#define UL unsigned long

//PSIZE holds the pagesize
#define PSIZE (* (UL *)(dseg_lo + 8) - 1)

//CURPOS holds the address of the beggining of the block after the last allocated block
#define CURPOS (* (char **)(dseg_lo))



int mm_init (void)
{
  if( !mem_sbrk(mem_pagesize()) )
    return -1;

  *(UL *)(dseg_lo + 8) = (UL) mem_pagesize() + 1;//we store the page size here
  CURPOS = dseg_lo + 16;
    
  //this creates one huge free block
  *(UL *)(dseg_lo + 16) = *(UL *)(dseg_hi-7) = PSIZE - 16;
  
  return 0;
}  //mm_init


//add_page(size) - creates enough pages for size and returns ptr to block after coalescing
void *add_page(size_t size)
{
  UL real_size = ((UL) (size / PSIZE) + 1) * PSIZE; //# of bytes of total pages needed for this malloc
  char *ptr = mem_sbrk (real_size);
  UL new_size;

  if (ptr)
  {
    if ( (*(UL *)(ptr - 8)) & 1)  //no coalesce, make new page into 1 single block
    {
      *(UL *)(ptr) = real_size;
      *(UL *)(dseg_hi - 7) = real_size;
    }
    else   // coalesce
    {
      new_size = (*(UL *)(ptr - 8)) & -2;  // temp to hold the size of last block in the last page
      ptr = ptr - new_size;  //ptr points to header of above mentioned block
      new_size += real_size;
      *(UL *)(ptr) = new_size;
      *(UL *)(dseg_hi-7) = new_size;
    }
  }

  return ptr;
} //add_page


//next_free(size)-  finds next free block big enough for size, returns NULL if there is none
//Invariant: size is a multiple of 8
void *next_free (size_t size)
{
  char *ptr;

  for( ptr = CURPOS; ptr < dseg_hi - 15; ptr += ((*(UL *)(ptr)) & -2) )
    if ( !((*(UL *)(ptr)) & 1) && ((*(UL *)(ptr)) & -2) >= size ) //not allocated and is big enough
      return ptr;
  
  for( ptr = dseg_lo + 16; ptr < CURPOS; ptr += ((*(UL *)(ptr)) & -2) )
    if ( !((*(UL *)(ptr)) & 1) && ((*(UL *)(ptr)) & -2) >= size ) //not allocated and is big enough
      return ptr;
  
  return add_page(size);
} //next_free


// add_block (p, l) adds a block of length l beginning at position p
// modifies CURPOS and splits the free block if necessary
//l is already a multiple of 8
void add_block (char *ptr, size_t size)
{
  UL *ulptr = (UL *) ptr;  //temp variable so we make this cast only once
  UL old_size = (*ulptr) & -2;  //size of free block where we are allocating

  if ((old_size - size) == 8)  // so as not to lose 8 left-over bytes
  {
    *ulptr = *(UL *)(ptr + size) = size + 9;
    CURPOS = ptr + size + 8;
  }
  else
  {
    *ulptr = *(UL *)(ptr + size - 8) = size + 1;

    if (old_size > size)
      *(UL *)(ptr + size) =  *(UL *)(ptr + old_size - 8) =  old_size - size;

    CURPOS = ptr + size;
  }
}  //add_block


void *mm_malloc (size_t size)
{
  //real_size adds 16 for the header info and aligns it to 8 bytes
  size_t real_size = size + 16 + ((8 - (size % 8)) % 8);

  void *new_block;

  if (size == 0)
    return NULL;

  new_block =  next_free (real_size);  //points to the header

  if( new_block )
  {
    add_block (new_block, real_size);
    return new_block + 8;   // since new_block points to header
  }

  return NULL;
}


void mm_free (void *ptr)
// here we free and coalesce 
{
  UL *this_block_st = ptr - 8;
  UL *prev_block_end = ptr - 16; 
  UL *prev_block_st = (UL *)((char *)(this_block_st) - ((*prev_block_end) & -2));
  UL *next_block_st = (UL *)((char *)(this_block_st) + ((*this_block_st) & -2));
  UL *this_block_end = (UL *)((char *)(next_block_st) - 8);
  UL *next_block_end;

  UL new_size;  //used to store size of free block if coalescing

  if( (char *)(this_block_end) == dseg_hi-7) //then there is no next block
  {
    if ( (*prev_block_end) & 1 ) //previous block allocated
    {
      *this_block_st &= -2;         
      *this_block_end &= -2; 
    }
    else //previous block not allocated
    {
      new_size = ((*prev_block_st) & -2) + ((*this_block_st) & -2);
      *prev_block_st = new_size;
      *this_block_end = new_size;      

      //now we possibly have to fix the CURPOS
      if (CURPOS == (char *)this_block_st)
	CURPOS = (char *)prev_block_st;
    }

    return;
  }

  //so there is a next block
  next_block_end = (UL *)((char *)(this_block_end) + ((*next_block_st) & -2));  

  if ( (*prev_block_end) & 1 )  //previous block allocated
  {    
    if ( (*next_block_st) & 1 )  //next block allocated
    {
      *this_block_st &= -2;         
      *this_block_end &= -2; 
    }
    else     // previous allocated, next not
    {
      new_size = ((*this_block_st) & -2) + ((*next_block_st) & -2);
      *this_block_st = new_size;
      *next_block_end = new_size;

      //now we possibly have to fix the CURPOS
      if (CURPOS == (char *)next_block_st)
	CURPOS = (char *)this_block_st;
    }
  }
  else  //previous block unallocated
  {
    if ( (*next_block_st) & 1 )  // next block allocated
    {
      new_size = ((*prev_block_st) & -2) + ((*this_block_st) & -2);
      *prev_block_st = new_size;
      *this_block_end = new_size;

      //now we possibly have to fix the CURPOS
      if (CURPOS == (char *)this_block_st)
	CURPOS = (char *)prev_block_st;
    }
    else    // both unallocated
    {
      new_size = ((*prev_block_st) & -2) + ((*this_block_st) & -2) + ((*next_block_st) & -2);
      *prev_block_st = new_size;
      *next_block_end = new_size;

      //now we possibly have to fix the CURPOS
      if ((CURPOS == (char *)this_block_st) || (CURPOS == (char *)next_block_st))
	CURPOS = (char *)prev_block_st;
    }
  }
}

