/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Team blink must die",
    /* First member full name */
    "Eric Kadehjian",
    /* First member email address */
    "erick",
    /* Second member full name (leave blank if none) */
    "Rehana Rodrigues",
    /* Second member email address (blank if none) */
    "rehana"
};


char *currentPos;
char *beg;


#define BLOCKSIZE (*((long *) currentPos))

/* Simply computes the smallest multiple of 8 equal or greater than i */
long ceiling8 (long i)
{
    if (i % 8 == 0)
	return i;
    else
	return (((i/8)+1) * 8);
    
}

void coalesceLeft (void *ptr)
{
  /* Set curr equal to the footer of the previous block */
  char *curr = (char *) ptr - 16;
  /* If the previous block is free and fully within bounds of the heap */
  if ((!(*((long *) curr) & 1L))
      && (((unsigned long)curr) >= (unsigned long)dseg_lo))
    {
      /* Put curr to the beginning of its block */
      curr -= *((long *) curr) + 8;
      /* Increment the size located at curr by the amount in the block 
	 containing ptr */
      *((long *) curr) += *((long *)((char *)ptr - 8)) + 16;
      /* Set the footer of the original block to contain the size of the 
	 new coalesced block */
      *((long *) ((char *) ptr + (*((long *) ((char *)ptr - 8))))) = *((long *) curr);
      /* The 16 compensates for the recovery of one of the 8-byte headers and an 8-byte footer. */
      

      }
  }
void coalesceRight (void *ptr)
{
  char *curr = (char *)ptr - 8;
  curr += *((long *) curr) + 16;
  if ((!(*((long *) curr) & 1L)) 
      && (((unsigned long)curr) < (unsigned long)dseg_hi))
    {
      *((long *) ((char *)ptr - 8)) += *((long *) curr) + 16;
      *((long *) ((char *)curr + (*((long *) curr)) + 8)) 
	     = *((long *)((char *)ptr - 8));
    }
}

char *growHeap(long increment)
{
  char *start = mem_sbrk(increment);
  if (!start)
    return NULL; /* Can't grow heap */
  else
  {
    /* Set new region as a block of increment - 16 */
    *(long *) (start) = increment - 16;
    *(long *) (dseg_hi - 7) = increment - 16;
    return start;
  }
}

int mm_init (void)
{
   beg = NULL;
   currentPos = NULL;
   if (!(mem_sbrk(mem_pagesize())))
       return -1; /* Heap could not be allocated! */
   else
  {
    /* Set the first eight bytes of the heap to store the size of the page
       minus 16 bytes (8 for the header and 8 for the footer. */
     *(long *) (dseg_lo) = (long) (mem_pagesize() - 16);
     *(long *) (dseg_hi - 7) = (long) (mem_pagesize() - 16);

   return 0;
  } 

}

void *mm_malloc (size_t size)
{
    long page;
    size = ceiling8(size); /* round the size up to the next multiple of 
                              8 bytes */
    currentPos = dseg_lo;
    
    page = (long) mem_pagesize();
    while ((BLOCKSIZE & 1) || (BLOCKSIZE < size))
      {
	/* Try to grow the heap if currentPos gets too close to dseg_hi */
	if ((((long)dseg_hi - (long)currentPos) < ((long)size + 16L)) 
	    || ((long)dseg_hi - (long)currentPos) < (BLOCKSIZE + 16L))
	  {
	    beg = growHeap(size + 16);

	    if (!beg)
	      return NULL;
	    else
	      {
		coalesceLeft(beg + 8);
		continue;
	      }
	  }

	currentPos = currentPos + (BLOCKSIZE & -8L) + 16;
      }

   
    if (BLOCKSIZE > ((long)size + 16L)){
      
      *((long *)(currentPos + size + 16)) = BLOCKSIZE - size - 16;
      *((long *)(currentPos + BLOCKSIZE + 8)) = BLOCKSIZE - size - 16;
    }
    
    else size = BLOCKSIZE;

    BLOCKSIZE = size | 1; /* mark block as allocated */
    (*(long *)(currentPos + size + 8)) = size | 1;

    return currentPos + 8;
}


void mm_free (void *ptr)
{
  
  if( (((unsigned long)ptr - 8) < (unsigned long)dseg_lo) 
      || (((unsigned long)ptr - 8) > (unsigned long)dseg_hi))
    return;
  

  currentPos = ptr - 8;
 
  if (!(BLOCKSIZE & 1))
    return;

  BLOCKSIZE = BLOCKSIZE & -8L;   /* zeroes out last three bytes */
  currentPos += BLOCKSIZE + 8;
  BLOCKSIZE = BLOCKSIZE & -8L;

  coalesceRight(ptr); 
  coalesceLeft(ptr);
}














