/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "<font color=#cc0000>Put me on the joybus<br>Get me in a groove<br>Supply me with rock music<br> Take me on a rock harmony joyride</font>",
    /* First member full name */
    "Chris Sollitto",
    /* First member email address */
    "cs3",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/* macros for accessing data locations relative to the begining of a block */

/* pointer to first free block stored at begining of heap */
#define BASE ((long *)dseg_lo)
/* pointer to next free block in free list */
#define NEXT(p) ((long *)*((p) + 1))
/* pointer to previous free block in free list */
#define PREV(p) ((long *)*((p) + 2))
/* pointer to foot marker of memory block */
#define FOOT(p) ((long *)*((p) + ((*(p)) & -2)-1))
/* returns master free list pointer, stored at BASE */
#define FLHEAD ((long *)(*BASE))

/* note: throughout this file, memory will be addressed with (long *) */
/* this ensures that the smallest allocatable space is 8 bytes and    */
/* that the allocated memory will be 8-byte aligned                   */

int mm_init (void)
{
  /* first block starts  */
  long *firstfree = BASE + 1;
  /* if no memory allocated for the heap */
  if (dseg_hi<=dseg_lo)
  {
    /* allocate a new page */
    void *newPage = mem_sbrk(mem_pagesize());

    if (!newPage)
      return -1;
  }
  /* set the free list head to this first block */
  FLHEAD = firstfree;
  /* set the size of this block to the max heap size */
  *firstfree = ((DSEG_MAX-1) >> 3) & -2;
  /* set pointers for block */
  NEXT(firstfree) = NULL;
  PREV(firstfree) = BASE;
  return 0;
}

void *mm_malloc (size_t size)
{
    /* calculate number of 8 bytes blocks needed */
    int blocks = (size+7) >> 3;
    /* start of free list */
    long *temp = FLHEAD;
    long *prev,*next;
    long *found = NULL;
    long s = DSEG_MAX + 1;
    /* add size of head/foot, round to even size */
    int newsize = (((blocks + 3) >> 1) << 1);
    int oldsize;

    // find BEST FIT free block
    while (temp!=NULL) /// FOOT
    {
      /* only conisde free blocks large enough in size */
      if (!((*temp & 1) || (*temp < blocks)))
      {
	/* if closer to actual size, save */
	if (*temp < s)
        {
	  s = *temp;
	  found = temp;
	}
      }
      temp = NEXT(temp);
    }
    temp = found;
    if (temp == NULL)
      return NULL;
    
    oldsize = *temp & -2;
    /* if space leftover not big enough for head/foot & pointers */
    /* add leftover space to the new block */
    if (newsize > oldsize - 4)
      newsize = oldsize;
    /* allocate extra memory if heap isn't large enough */
    if (((long)(temp + newsize)) > ((long)dseg_hi))
      {
	/* note: i used to allocate only multiples of page size */
	/* but that had a detrimental effect on performance score */
	if (!mem_sbrk((( ((long)(temp + newsize)) - ((long)dseg_hi)))))
	  return NULL;
      }
      
    // allocate block

    /* set size, mark used flag bit */
    *temp = newsize | 1;
    /* update pointers */
    FOOT(temp) = newsize | 1; // FOOT
    next = NEXT(temp);
    prev = PREV(temp);
    if (prev == BASE)
      FLHEAD = next;
    else if (prev)
      NEXT(prev) = next;
    if (next) 
      PREV(next) = prev;    
    /* if there is extra space at end of block, add to free list */
    if (newsize < oldsize)
    {
      /* starting address */
      long *newfblock = temp + newsize;
      /* set size */
      *newfblock = (oldsize - newsize);
      if (((long)(newfblock + *newfblock)) <= ((long)dseg_hi))
	FOOT(newfblock) = (oldsize-newsize);
      /* update pointers */
      if (prev == BASE)
	FLHEAD = newfblock;
      else if (prev)
	NEXT(prev) = newfblock;
      PREV(newfblock) = prev;
      NEXT(newfblock) = next;
      if (next)
	PREV(next) = newfblock;
    }
    /* return pointer without header */
    return (void *)(temp + 1);
}

void mm_free (void *ptr)
{
  /* get ptr header */
  long *p = ((long *)ptr)-1;
  long *prevblock;
  /* calculate next physical memory block location */
  long *nextblock = p + (*p & -2);
  int cnext = 0; /* coalesce with next block?  */
  int cprev = 0; /* coalesce with previous block?  */

  /* calculate previous block and cprev */
  if (((long)p) <= ((long)BASE) + 8)
    cprev = 0;
  else
  {
      prevblock = p - 1 - ((*(p-1)) & -2) +1;
      cprev = !((*prevblock) & 1L);
  }
  /* calculate cprev */
  if (((long)nextblock) > ((long)dseg_hi))
    cnext = 0;
  else
  {
     cnext= !((*nextblock) & 1L);
  }
      
  if ((!cnext) && (!cprev)) /* no coalescing */
    {
      /* add block to free list */
      PREV(p) = BASE;
      NEXT(p) = FLHEAD;
      if (FLHEAD)
	PREV(FLHEAD)=p;
      FLHEAD = p;
      *p = (*p) & -2;
      FOOT(p) = *p;
    }
   else if (cnext && cprev)
    {
      /*coalesce next and previous */
        long csize = ((long)(*prevblock)) + ((long)(*p & -2)) + ((long)(*nextblock));
	/* remove next block from free list */
	long *next = NEXT(nextblock);
	long *prev = PREV(nextblock);
	if (prev == BASE)
	  FLHEAD = next;
	else if (prev)
	  NEXT(prev) = next;
	if (next)
	  PREV(next) = prev;
	/* increase prev block size */
	(*prevblock) = csize;
	FOOT(prevblock) = csize;


    }
  else if (cnext)
    {
      /* coalesce next only */
      long csize = ((long)(*p & -2)) + ((long)(*nextblock));
      long *next = NEXT(nextblock);
      long *prev = PREV(nextblock);
      /* remove next block, add current block to free list */
      if (prev == BASE)
	FLHEAD = p;
      else if (prev)
	NEXT(prev) = p;
      PREV(p) = prev;
      NEXT(p) = next;
      if (next)
	PREV(next) = p;
      /* update current block size */
      (*p) = csize;
      if (((long)(p + *p)) <= ((long)dseg_hi))
	FOOT(p) = csize;
    }
   else if (cprev)
    {
      /* coalesce previous only */
      long csize = ((long)(*p & -2)) + ((long)(*prevblock));
      /* increase previous block size to include p */
      (*prevblock) = csize;
      FOOT(prevblock) = csize;
    }
}

