/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
  /* Team name to be displayed on webpage */
  "Agent Dale Cooper, FBI",
  /* First member full name */
  "Carl Eastlund",
  /* First member email address */
  "cce",
  /* Second member full name (leave blank if none) */
  "",
  /* Second member email address (blank if none) */
  ""
};

/*

  Using segregate memory allocation

  Heap structure:
  60 pointers: array of lists of free blocks,
               indexed by logarithm of size
	       60 = 64 - 3 - 1
	       3 because blocksize 8
	       1 because min size 16

  Linked lists in following structure
  [8 bytes: size of this block (n), +1 if allocated]
  [n bytes: data, or pointers for lists if free    ]
  [         pointers: [next,prev]                  ]
  [8 bytes: size of this block (n), +1 if allocated]

 */

#define log_ptrs ((char **)dseg_lo)
#define heap (dseg_lo + (sizeof(char *) * 60))

/* Returns the log_2 of (n/8)
   n is broken into 8-blocks
   for purposes of alignment
   Also, min block = 16  */

int lg (size_t n)
{
  int ret=0;

  for( n /= 8 ; n>2 ; ret++ )
    n >>= 1;

  return ret;
}

/* Inserts free block ent into
   proper segregated free list
   in log_ptrs.  Assumes block
   ent is properly initialized.
 */

void insert (char *ent)
{
  int idx;

  idx = lg(*(size_t *)ent);

  /* Sets next/previous free list links */
  ((char **)ent)[1] = log_ptrs[idx];
  ((char **)ent)[2] = NULL;

  /* Splices ent into list */
  if( log_ptrs[idx] )
    ((char **)(log_ptrs[idx]))[2] = ent;
  log_ptrs[idx] = ent;
}

/* Removes free block ent from
   associated segregated free
   list.  Assumes correctness
   of prev/next pointers, and
   that ent is in the correct
   free block list.
 */

void destroy (char *ent)
{
  char **prev;
  char **next;

  /* Finds prev/next pointers from ent */
  prev = ((char ***)ent)[2];
  next = ((char ***)ent)[1];

  /* Not head of list:
     change prev block's next pointer */
  if( prev )
    prev[1] = (char *)next;
  /* Head of list: change log_ptrs[foo] */
  else
    log_ptrs[lg( *(size_t *)ent )] = (char *)next;

  /* If not tail, change prev of next
     If tail, no change to make */
  if( next )
    next[2] = (char *)prev;
}

int mm_init (void)
{
  int i;
  size_t heapsize /* , psize */ ;

  /* Calculate pagesize,
     and size of heap header in pages */
  /* Once again, this kills me with this
     assignment's grading script */
  /* psize = mem_pagesize();
     heapsize = (60 * sizeof(char *)) / psize; */

  /* Allocate at least enough for header */
  if( !mem_sbrk( 60 * sizeof(char *) ) )
    return -1;

  /* Initialize free block lists to empty */
  for( i=0 ; i<60 ; i++ )
    log_ptrs[i] = NULL;

  /* Calculate allocatable memory;
     initialize as free block.
  */
  heapsize = 1 + dseg_hi - heap;
  if(heapsize)
    {
      /* Make sure we have enough for one full block */
      if(heapsize < 32)
	{
	  if(!mem_sbrk(32-heapsize))
	    return -1;
	  heapsize = 32;
	}

      /* Set up header/footer, and next/prev pointers */
      ((size_t *)heap)[0] = heapsize-16;
      ((size_t *)(dseg_hi+1))[-1] = heapsize-16;
      ((char **)heap)[1] = NULL;
      ((char **)heap)[2] = NULL;
      
      /* Add to appropriate list */
      log_ptrs[lg(heapsize-16)] = heap;
    }

  return 0;
}

/* Allocates memory block of sufficient size
   from space in heap.  Split blocks as
   necessary, or allocate new space in heap.
 */

void *mm_malloc (size_t size)
{
  size_t i, len;
  char *ptr;
  char *tmp;

  /* Waste no space on zero-size request */
  if(!size)
    return NULL;

  /* Block size as multiple of 8, minimum 16 */
  if(size < 16)
    size = 16;
  else if(size % 8)
    size += 8 - (size % 8);

  /* Find first block of adequate size */
  for( ptr = NULL, i=lg(size) ; !ptr && i<60 ; i++ )
    if( log_ptrs[i] )
      {
	ptr = log_ptrs[i];
	while( ptr && *(size_t *)ptr < size )
	  ptr = ((char **)ptr)[1];
      }

  /* If found block in free list, remove it */
  if(ptr)
    destroy(ptr);
  /* Otherwise, allocate new memory */
  else
    {
      i = mem_pagesize();

      /* Find last block in heap */
      len = ((size_t *)(dseg_hi+1))[-1];

      /* If allocated, make new block */
      if( len % 8 || heap > dseg_hi )
	{
	  /* Allocate block + header + footer */
	  len = size + 16;
	  ptr = dseg_hi + 1;
	}
      /* Otherwise, coalesce with last block */
      else
	{
	  /* Last block accounts for len bytes,
	     plus header and footer */
	  ptr = (dseg_hi+1) - (len + 16);
	  len = size - len;
 	  destroy(ptr);
	}

      /* Make even number of pages */
      /* Should be put in "real" malloc, but kills
	 my utilization in this assignment */
      /*      if( len % i )
	      len += i - (len % i);*/

      /* Grab memory pages */
      if(!mem_sbrk( len ))
	return NULL;

      /* Re-calculate total block size */
      len = (dseg_hi+1) - ptr - 16;

      /* Construct header and footer */
      *(size_t *)ptr = len;
      *(size_t *)(ptr + len + 8) = len;
    }

  /* Found block, allocate it */
  if(ptr)
    {
      /* Block is large enough to split */
      if(*(size_t *)ptr - size >= 32)
	{
	  tmp = ptr + size + 16;
	  i = *(size_t *)ptr - (size + 16);

	  /* Set header/footer of block, add to free list */
	  *(size_t *)tmp = i;
	  *(size_t *)(tmp + i + 8) = i;
	  insert(tmp);

	  /* Set current block to fit size */
	  *(size_t *)ptr = size;
	  *(size_t *)(ptr + size + 8) = size;
	}
      else
	size = *(size_t *)ptr;

      /* Increment header/footer to indicate allocated */
      *(size_t *)ptr += 1;
      *(size_t *)(ptr + size + 8) += 1;

      /* Return data portion of block */
      return ptr+8;
    }

  /* No block of sufficient size available -- Fail */
  return NULL;
}

/* Given a previously allocated pointer,
   coalesces with adjacent blocks and
   puts everything back on the correct
   segregated free block list.
 */

void mm_free (void *ptr)
{
  char *tmp;
  size_t size;

  /* Waste no time on NULL */
  if(!ptr)
    return;

  /* Look at block, not data portion of block */
  ptr -= 8;

  /* Extract size, correct for allocated +1 flag */
  size = *(size_t *)ptr - 1;

  /* Attempt to coalesce right */
  tmp = ((char *)ptr) + 16 + size;
  if( dseg_hi > tmp && *(size_t *)tmp % 8 == 0 )
    {
      destroy(tmp);
      size += *(size_t *)tmp + 16;
    }

  /* Attempt to coalesce left */
  if( heap < (char *)ptr && ((size_t *)ptr)[-1] % 8 == 0 )
    {
      ptr -= ((size_t *)ptr)[-1] + 16;
      destroy(ptr);
      size += *(size_t *)ptr + 16;
    }

  /* Correct header/footer for coalescing */
  *(size_t *)ptr = size;
  *(size_t *)(ptr + size + 8) = size;

  /* Place free block on correct list */
  insert(ptr);
}

