/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Jumping Monkeys",
    /* First member full name */
    "Chris Allwein",
    /* First member email address */
    "allwein",
    /* Second member full name (leave blank if none) */
    "John Corwin",
    /* Second member email address (blank if none) */
    "jcorwin"
};

/* Method: represent blocks of memory as follows:

   Free Blocks: [size][next][---free---][size]
   size = the size of the block in quad-words
   next = a ponter to the next free block   

   Allocated Blocks: [size][---data---][size]
   size = The negative size of the block

   Free blocks have positive sizes, allocated
   blocks have negative sizes
 */

// The first free block in the heap
#define firstfree (((long *) (dseg_lo))[0])

// The beginning of the heap
#define head (((long *)(dseg_lo)) + 1)

// The end of the heap
#define tail ((long *)(dseg_hi + 1))

// Returns the number of quad-words required to represent 
// data of a given size, aligned to 8-bytes
long blocksize(size_t size)
{
  if (size % 8 == 0)
    return size / 8;
  else return (size + 8) / 8;
}

int mm_init (void)
{
  long initsize;      // The initial heap size

  long * mem = head;  // The initial heap

  // allocate some memory
  if(mem_sbrk(mem_pagesize())==NULL)    
    return -1;

  initsize = tail - head - 2; 

  // set up the initial block in the heap
  mem[0] = initsize;             
  mem[1] = NULL;
  mem[mem[0] + 1] = mem[0];

  // set the free pointer to the start of the heap
  firstfree = (long ) mem;     
  
  return 0;  // return success
}

void *mm_malloc (size_t size)
{
  long * cur = (long *) firstfree;
  long * last = NULL;
  long nextsize;
  long memsize = blocksize(size);

  while (cur)   // Try to find a free block in the heap
  {
    if (cur[0] >= memsize)  // See if this block is big enough
    {
      nextsize = cur[0] - memsize - 2;
      if (nextsize >= 1)  // determine if the whole block should be used,
      {                   // or if it should be split up
	// set the next block's data
	cur[memsize + 2] = nextsize;
	cur[cur[0] + 1] = nextsize;

	// set the free block pointer
	cur[memsize + 3] = cur[1];
		
	// Add the next block to the free list
	if ((long *)firstfree == cur)
	  firstfree = (long) &cur[memsize + 2];
	else if (last)
	  last[1] = (long) &cur[memsize + 2];

	// Set the size of the current block
	cur[0] = -memsize;
	cur[memsize + 1] = -memsize;
      }
      else // use the whole block
      {
	// Remove the current block from the free list
	if ((long *) firstfree == cur)
	  firstfree = cur[1];
	if (last)
	  last[1] = cur[1];

	// Set the current block's status to allocated
	cur[cur[0] + 1] = -cur[0];
	cur[0] = -cur[0];
      }
      return &cur[1];   // Return the memory
    }

    // Try the next free block
    last = cur;
    cur = (long *) cur[1];
  }

  // If no free blocks were found, increase the size of the heap
  nextsize = memsize;
  if (mem_sbrk((nextsize + 2) * 8) == NULL)
    return NULL;
  last = tail - (nextsize + 2);

  last[0] = -nextsize;
  last[nextsize + 1] = -nextsize;
  return &last[1];
}

// Removes a pointer from a linked list, and returns the list
long * remove_me(long * list,long *p)
{
  long * temp;
  long * last;

  if (list == NULL)
    return NULL;
  else if (list == p)
    return (long *) list[1];

  temp = list;
  last = NULL;
  while (temp && temp != p)
  {
    last = temp;
    temp = (long *) temp[1];
  }
  if (temp == p)
    last[1] = p[1];
  return list;
}

void mm_free (void *ptr)
{
  long * cur = ptr;
  long * next;
  long * prev;

  cur--;
  cur[0] = -cur[0]; // Set the block to be unallocated
  cur[cur[0] + 1] = cur[0];

  // Try to coalesc to the right
  next = &cur[cur[0] + 2];
  if (next < tail && next[0] > 0)
  {
    // coalesc right
    cur[0] = cur[0] + next[0] + 2;
    cur[cur[0] + 1] = cur[0];

    // Remove the right pointer from the free list
    firstfree = (long) remove_me((long *) firstfree,next);
  }

  // Try to coalesc to the left
  if (cur > head)
  {
    prev = &cur[-abs(cur[-1]) - 2];
    if (prev >= head && prev[0] > 0)
    {
      // coalesc left
      prev[0] = prev[0] + cur[0] + 2;
      prev[prev[0] + 1] = prev[0];

      return;
    }
  }

  // Add the newly freed block to the free block list
  cur[1] = firstfree;
  firstfree = (long) &cur[0]; 
}
