/* malloc.c
Andrew Alford and Scott Robbins
Our algorithim is just a basic doubly linked explicit list with coalescing
we use a first-fit allocation policy for putting things into the list.
We originally came up with an algorithm that would combine using this approach
for large allocations and a buddy system approach for smaller ones - this would
mitigate the downsides of the buddy system(hard to grow the heap, and large
internal fragmentation) by combining it with a list which does not have these
problems.  All of this is moot, however, because we didn't have enough time to
get the buddy system part working... anyway, this is our program. */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

void* block_allocate(size_t size);
//void* buddy_allocate(size_t size);

team_t team = {
    /* Team name to be displayed on webpage */
    "Harry Q. Bovik",
    /* First member full name */
    "Andrew Alford",
    /* First member email address */
    "alford",
    /* Second member full name (leave blank if none) */
    "Scott Robbins",
    /* Second member email address (blank if none) */
    "robbins"
};

typedef struct free_head
{
  unsigned long int size;
  struct free_head* prev;
  struct free_head* next;
} *fhead_p;

typedef long int word;


/* ALLOC_BLOCK                                        */
/* set alloc bit & set size                           */
/* maintain prev_alloc_bit                            */
/* if not at the end-of-page                          */
/* assign state-of-back-element=alloc to next element */

#define ALLOC_BLOCK(pt,len)                           \
    ((*((word*)(pt)))= ((len)| ALLOC_MASK)|           \
    ( (*(word*)(pt)) & PREV_ALLOC_MASK)  );           \
    if(((void*)(pt)+(len)) < (void*)dseg_hi)          \
      (*((word*)((void*)(pt)+(len)))|=PREV_ALLOC_MASK );

/* FREE_BLOCK                                        */
/* clear alloc bit & set size                        */
/* maintain prev_alloc_bit                           */
/* assign backpointer to last word in block          */
/* if not at the end-of-page                         */
/* assign state-of-back-element=free to next element */

#define FREE_BLOCK(pt,len)                                   \
    (((fhead_p)(pt))->size = ((len)&(~ALLOC_MASK))|          \
           (((fhead_p)(pt))->size & PREV_ALLOC_MASK));       \
    (*((word**) ((void*)(pt)+(len)-WORDSIZE)) = (word*)(pt));\
    if(((void*)(pt)+(len)) < (void*)dseg_hi)                 \
      (*((word *)((void*)(pt)+(len)))&=(~PREV_ALLOC_MASK));


/* returns 1 if block alloc, 0 otherwise (buddy)*/
#define IS_K(pt) (((*(word*)(pt))&SIZE_MASK)>=WORDSIZE ? 1 : 0 );

#define BLOCKS(size)  (size/BLOCKSIZE + 1)
#define WORDS(size)  (size/WORDSIZE + 1)
/* 8 blocks per page, 1kb/block */
#define BLOCKSIZE 32
#define WORDSIZE 8

#define ALLOC_MASK 0x01
#define PREV_ALLOC_MASK 0x02
#define SIZE_MASK (~0x03)
/* free block list head pointer */
#define K_LIST ((fhead_p*)(dseg_lo+2*WORDSIZE))
/* points to last element in memory (for coalescing with new pages)*/
#define LAST_THING ((word**)(dseg_lo+4*WORDSIZE))




int mm_init (void)
{
  fhead_p ptr; /* jack-of-all trades pointer */

  /*
  printf("MM_INIT\n");
  */
  /* stop on error */
  if(!(mem_sbrk(mem_pagesize())))
    {
      printf("mem_sbrk failed! mem_usage() = %ld\n",mem_usage());
      printf("aborting!\n");
      return -1;
    }
  /* allocate the first block for record keeping*/
  ALLOC_BLOCK (dseg_lo,2*BLOCKSIZE); 

  /* mark the rest of the page as free */
  ptr = (fhead_p)(dseg_lo+(2*BLOCKSIZE));
  FREE_BLOCK (ptr,254*BLOCKSIZE);
  *LAST_THING = (word*) ptr;

  /* set up pointers, and K_LIST */
  *K_LIST = ptr;
  ptr->next = NULL;
  ptr->prev = (fhead_p)dseg_lo;

  return 0;
}


/* make an allocation of one or more whole blocks
   size is guaranteed to be >= BLOCKSIZE/2 */
void* mm_malloc (size_t size)
{
  fhead_p ptr;  /* useful pointer */
  fhead_p *list_head = K_LIST;
  word** last_thing = LAST_THING;
  unsigned long int len, needed_space, last_alloc,num_pages, numblocks;
  fhead_p minptr = NULL;
  if(size == 0)
    return NULL;
  size = WORDS(size) * WORDSIZE;  /* round up to next nearest word */  
  numblocks = BLOCKS(size);  /* number of blocks we need to allocate */
  ptr = *list_head; /* first element of K_LIST */
  /* do first fit */
  while(ptr)
    {
      if(size < (ptr->size & SIZE_MASK))
	{
	  minptr = ptr;
	  break;
	}
      ptr = ptr->next;
    }

  /* check to see if we need new pages */
  if(!minptr)
    {
      needed_space = size;
     
      if(!(**last_thing & ALLOC_MASK) && 
	 ((**last_thing & SIZE_MASK) >= BLOCKSIZE))
	{/* check if last thing is a free block */
	  needed_space -= (**last_thing & SIZE_MASK);
	  last_alloc = 0;
	}
      else /* the last thing is segmented or wholly allocated */
	last_alloc = 1;

      num_pages = needed_space / mem_pagesize() + 1;
      /* get the needed number of pages */
      if ((ptr = (fhead_p)mem_sbrk(num_pages*mem_pagesize())) == NULL){
	printf("mem_sbrk() returned NULL. We are out of heap.\n");
	return NULL;
      }
      if (last_alloc) /* start a new free block with what mem_sbrk returned */
	{
	  FREE_BLOCK(ptr,num_pages*mem_pagesize());
	  ptr->next = *list_head;
	  ptr->prev = (fhead_p)dseg_lo;
	  *list_head = ptr;
	  if(ptr->next)
	    ptr->next->prev = ptr;
	  minptr = ptr;
	  *last_thing = (word*) ptr;
	  ptr->size = (ptr->size | PREV_ALLOC_MASK);
	}
      else
	{  /* combine the new memory with the free chunk at the end of the old heap */
	  ((fhead_p)*last_thing)->size += num_pages*mem_pagesize();
	  minptr = (fhead_p)*last_thing;
	}
    }

  /* length of remaining free blocks from best-fit chunk */
  len = (minptr->size&SIZE_MASK)-numblocks*BLOCKSIZE;
  if(len != 0)
    { 
      /* if we need to segment, make a new free block */
      ptr = (fhead_p)(((void*)minptr)+numblocks*BLOCKSIZE);    
      FREE_BLOCK(ptr, len);

      /* check to see if this is the last thing */
      if(minptr == (fhead_p)(*last_thing))
	*last_thing = (word*) ptr;
      
      /* let ptr take our spot in the list */
      ptr->next = minptr->next;
      ptr->prev = minptr->prev;
      minptr->prev->next = ptr;
      if(minptr->next)
	minptr->next->prev = ptr;
    }
  else  /* otherwise, just take this free block out of the list */
   {
      minptr->prev->next = minptr->next;
      if(minptr->next)
	minptr->next->prev = minptr->prev;
   }

  /* now allocate this area */
  ALLOC_BLOCK(minptr,numblocks*BLOCKSIZE);
  /* and return the pointer to the allocated block */
  return (((void*)minptr) + WORDSIZE);
}



void mm_free (void* ptr)
{
  size_t size;
  fhead_p front, back, here;
  fhead_p* list_head = K_LIST;
  word** last_thing = LAST_THING;
  int is_back_free = 0;

  ptr -= WORDSIZE;
  
  if(!((*(word*)ptr) & ALLOC_MASK))
    {
      printf("I never gave you this!\n");
      return;
    }
  size = ((fhead_p)ptr)->size & SIZE_MASK;

  /*clear alloc bit, set backpointer, notify neighbors */
  // FREE_BLOCK(ptr,size);

  /* check if back neighbor is free */
  if(!(((fhead_p)ptr)->size & PREV_ALLOC_MASK))
    {
      is_back_free = 1;
      back = *((fhead_p *)((void*)ptr-WORDSIZE));
    }
  /* check that there is a front neighbor */
  /* coalesce when needed */
  if((word*)ptr != *last_thing)
    {
      front = (fhead_p)((void*)ptr+size);
      if(!(front->size & ALLOC_MASK))
	{ 
	  /* front neighbor is free */
	  if(is_back_free){
	    /*front and back are free - coalesce whole thing */
	    /* first remove front neighbor from list */ 
	    front->prev->next = front->next;
	    if(front->next)
	      front->next->prev = front->prev;
	    /* next calculate size */
	    size += front->size & SIZE_MASK;
	    size += back->size & SIZE_MASK;
	    /* adjust last_thing if needed */
	    if((word*)front == *last_thing)
	      *last_thing = (word*)back;
	    /* set the whole thing free */
	    FREE_BLOCK(back,size);
	  }
	  else{
	    /* front is free, but back is not */
	    /* first take the place of the front neighbor in the list */
	    here = (fhead_p)ptr;
	    here->next = front->next;
	    here->prev = front->prev;
	    here->prev->next = here;
	    if(here->next)
	      here->next->prev = here;
	    /* now calculate the new size */
	    size += front->size & SIZE_MASK;
	    /* adjust last_thing if needed */
	    if((word*)front == *last_thing)
	      *last_thing = (word*)here;
	    /* free the block */
	    FREE_BLOCK(here,size);
	  }
	}
      else
	{  /* front is not free */
	  if(is_back_free){
	    /* only the back is free */
	    /* calculate size */
	    size += back->size & SIZE_MASK;
	    /* no need to adjust last_thing, since it isn't us */
	    /* redo the free block */
	    FREE_BLOCK(back,size);
	  }
	  else{
	    /* no coalescing - just free ourselves */
	    /* insert into front of K_LIST */
	    here = (fhead_p)ptr;
	    here->next = *list_head;
	    here->prev = (fhead_p)dseg_lo;
	    if(here->next)
	      here->next->prev = here;
	    *list_head = here;
	    FREE_BLOCK(here,size);
	  }
	}
    }
  else
    {/* we are the last thing. there is no front. coalesce w/ back if needed */
      if(is_back_free){
	    /* only the back is free */
	    /* calculate size */
	    size += back->size & SIZE_MASK;
	    /* adjust last_thing */
	    *last_thing = (word*)back;
	    /* redo the free block */
	    FREE_BLOCK(back,size);
	  }
	  else{
	    /* no coalescing - just free ourselves */
	    here = (fhead_p)ptr;
	    here->next = *list_head;
	    if(here->next)
	      here->next->prev = here;
	    here->prev = (fhead_p)dseg_lo;
	    *list_head = here;
	    FREE_BLOCK(here,size);
	  }
    }

}

