/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/*int IS_FREE( long int * ); */
#define IS_FREE(x) ((*((long int *)(x)) & 0x1) ? 1 : 0)
#define LENGTH(x)  (*((long int *)(x)) >> 1)
/*long int LENGTH( long int * );*/

team_t team = {
    /* Team name to be displayed on webpage */
    "Word, yo.",
    /* First member full name */
    "Aron Flagg",
    /* First member email address */
    "aflagg",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

/*malloc routines use the scheme...

  [Header word which points to address of ending word][data][end word]
  
  Encoded in the header & end words is whether or not it is a free or used
  block
*/

int mm_init (void)
{
  if( !mem_sbrk(mem_pagesize()) )
    return -1;
  else {
    long int *l = (long int *)dseg_lo;        /*simple pointer conversion*/
    long int *h = (long int *)(dseg_hi - 7);  /*adjust to word-align*/
    *l = (h - l) << 1;                        /*Make it LENGTH h-l-1*/
    *l += 1;                                  /*Make it free */
    *h =  *l;                                 /*Set ending block*/
  }
  
  return 0;  
}

void *mm_malloc (size_t size)
{
  long int lsize = (size >> 3) + 1;
  long int *ptr = (long int *)dseg_lo;
  int increase_size = 0;
  long int *l, *h;
  int psize = mem_pagesize();

  while( 1 )
    {
      for( ;ptr < (long int *)(dseg_hi - 7); ptr += LENGTH(ptr) + 1 )
	{
	  if( IS_FREE(ptr) && (LENGTH(ptr) > lsize + 2) ) {
	    if( LENGTH(ptr) <= lsize + 3 ){
	      *ptr &= -2;
	      *(ptr + LENGTH(ptr)) &= -2;
	      return (void *)(ptr + 1);
	    } else {
	      long int *endptr = (ptr + LENGTH(ptr));
	      *ptr = (lsize + 1) << 1;
	      *(ptr + lsize + 1) = *ptr;
	      *(ptr + lsize + 2) = (endptr - (ptr + lsize + 2)) << 1;
	      *(ptr + lsize + 2) += 1;
	      *endptr = *(ptr + lsize + 2);
	      return (void *)(ptr + 1);
	    }
	  }
	}
      
      l = (long int *)(dseg_hi-7) - LENGTH((long int *)(dseg_hi-7));
      increase_size = (size / psize) + 1;
      if( !mem_sbrk( psize * increase_size ) )
	return NULL;

      h = (long int *)(dseg_hi-7);
      
      if( !IS_FREE(l) )
	l += LENGTH(l) + 1;
      
      *l = (h - l) << 1;
      *l += 1;
      *h = *l;

      ptr = l;
    }
  
  return NULL; 
}

void mm_free (void *ptr)
{
  long int *l, *h;
  
  l = ((long int *)ptr) - 1;
  h = l + LENGTH(l);
  
  if( IS_FREE(l-1) )
    l = (l-1) - LENGTH(l-1);
  if( IS_FREE(h+1) )
    h = (h+1) + LENGTH(h+1);

  *l = (h - l) << 1;
  *l += 1;
  *h = *l;
}
