/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "Craptacular 3.0a unoptimized",
    /* First member full name */
    "Dan Wyand",
    /* First member email address */
    "wyand@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{
  register long *p;  

  if (!mem_sbrk(8192)) return -1;
  p = dseg_lo;
  p[0] = 0;
  p[1] = p + 5;
  p[2] = p + 5;
  p[3] = p + 5;
  p[4] = 1;
  p[5] = (long)dseg_hi - (long)dseg_lo + 1 - 8*8;
  p[6] = (long)dseg_lo;
  p[7] = (long)dseg_lo;
  
  p = (long *)((long)dseg_hi - 15);
  p[0] = (long)dseg_hi - (long)dseg_lo + 1 - 8*8;
  p[1] = 1L;

  return 0;
}

/* Heap growing optimiztion, must be a multiple of 8196.
   Higher values slightly increase performance, lower 
   values slightly increase usage */

#define GROWTH_LIMIT 0x10000

long *growheap(size_t size) {
  register long increment;
  register long *p, *q;

  /* double the heap to a point, then grow linearly */
  increment = (long)dseg_hi - (long)dseg_lo + 1;
  increment = (increment > GROWTH_LIMIT)? GROWTH_LIMIT: increment;

  while (increment < GROWTH_LIMIT && increment - 16 < size) increment *= 3;

  if (increment < size + 16) 
    increment += (size - increment + 16 + GROWTH_LIMIT-1) & (0L-GROWTH_LIMIT);

  p = (long *)((char *)dseg_hi + 1);
  if (!mem_sbrk(increment)) return NULL;

  /* join the new block with the old block if its free... */
  size = *(p-2);
  if ((size & 1L) == 0) {
    p = p - size/8 - 3;
    p[0] = size + increment;
    q = (long *)((char *)dseg_hi - 15);
    q[0] = size + increment;
    q[1] = 1L;
  } else {
    /* ...or else mark and add the new block */
    p = p-1;
    p[0] = increment - 16;
    p[1] = *((long *)dseg_lo + 1);
    *((long **)dseg_lo + 1) = p;
    p[2] = (long *)dseg_lo;
    q = p[1]; q[2] = p;
    q = (long *)((char *)dseg_hi - 15);
    q[0] = increment-16;
    q[1] = 1L;
  }

  return p;
}

long *useblock(long *p, long blocksize, long size) {
  register long *q;

  /* Use the whole thing? */
  if (blocksize - size < 32) {
    p[0] = blocksize | 1L;
    p[blocksize/8 + 1] = blocksize | 1L;
    q = p[1]; q[2] = p[2];
    q = p[2]; q[1] = p[1];
    return p[1];
  } else {
    /* split the block. */
    q = p[1]; q[2] = p + size/8 + 2;
    q = p[2]; q[1] = p + size/8 + 2;
    q = p + size/8 + 2;
    p[0] = size | 1L;
    *(q-1) = size | 1L;
    blocksize = blocksize - size - 16;
    q[0] = blocksize;
    q[1] = p[1];
    q[2] = p[2];
    q[blocksize/8 + 1] = blocksize;
    return q;
  }
}

void *mm_malloc (size_t size)
{
  register long *p;
  register long blocksize, i;
  
  /* printf("a %d\n", size); */

  if (size == 0) return NULL;
    
  size = (size + 7) & -8L;
  size = (size == 8)? 16 : size;

  p = ((long *)dseg_lo)[3];
  blocksize = *p;
  i = 2;
  
  /* heres the time consumer, keep it tight. */
  while (blocksize < size && i) {
    i = (blocksize > 0)? i : i-1;
    p = p[1];
    blocksize = *p;
  }

  /* here either p points to a block of sufficient size or */
  /* i=0 and there is no space. */

  if (!i) {
    p = growheap(size);
    if (!p) return p;     /* out of memory */
    blocksize = *p;
  }
  
  /* here p points to a valid free block */

  /* mark the block and set the search pointer */
  i = (long)useblock(p, blocksize, size);
  *((long *)dseg_lo + 3) = i;
  
  return p+1;
}

void mm_free (void *ptr)
{
  register long *q, *p = ptr;
  register long lsize, size, rsize;

  /* printf("f\n"); */
  p -= 1;

  lsize = *(p-1);
  size = p[0] & -2L;
  rsize = p[size/8 + 2];

  switch (((lsize & 1L) << 1) | (rsize & 1L)) {

  case 0: /* Coalesce both. */
    q = p + size/8 + 2;
    ((long *)(q[1]))[2] = q[2];
    ((long *)(q[2]))[1] = q[1];
    p = p - lsize/8 - 2;
    size = size + lsize + rsize + 32;
    p[0] = size;
    p[size/8 + 1] = size;
    break;
  
  case 1: /* Coalesce left. */
    p = p - lsize/8 - 2;
    size = size + lsize + 16;
    p[0] = size;
    p[size/8 + 1] = size;
    break;

  case 2: /* Coalesce right. */
    q = p + size/8 + 2;
    ((long *)(q[1]))[2] = p;
    ((long *)(q[2]))[1] = p;
    size = size + rsize + 16;
    p[0] = size;
    p[1] = q[1];
    p[2] = q[2];
    p[size/8 + 1] = size;
    break;

  case 3: /* No coalescing. */
    p[0] = size;
    p[size/8 + 1] = size;
    p[1] = *((long *)dseg_lo + 1);
    *((long **)dseg_lo + 1) = p;
    p[2] = (long *)dseg_lo;
    ((long *)(p[1]))[2] = p;
    break;

  }


  /* point search list at new free block? */
  *((long **)dseg_lo + 3) = p;
     
}

