/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

team_t team = {
    /* Team name to be displayed on webpage */
    "powerpuff girls II ",
    /* First member full name */
    "Michael D Schuresko",
    /* First member email address */
    "mds2",
    /* Second member full name (leave blank if none) */
    "Camille Fournier",
    /* Second member email address (blank if none) */
    "camille"
};

//#define DEBUG
#define DEBUG_2

/* block format is as follows
   PPrev BlockSize  BlockData 
*/

static void yow(void) {}

#define FREE 0L
#define ALLOC 1L

/* number of bytes of extra stuff for each block */
#define PADDING 16L

/* used to extract block status */
#define STATUS_MASK 7L

/* used to extract block pointer */
#define POINTER_MASK (~(7L))

#define BLOCK_STATUS(x) ( *((long *) x) & STATUS_MASK)

// #define BLOCK_TAG(x)  *((long *) x)

// #define END_OF_BLOCK(x) (void *)( (char *)x + *((size_t *)x+1) -8)

#define BLOCK_SIZE(x) ( *((size_t *)x +1))

#define NEXT_BLOCK(x) ((void *)( (char *)x + *((size_t *)x+1)))

/* hope this works, typecast to a void** looks kinda funky */
#define PREV_BLOCK(x) (void *)( POINTER_MASK & *(size_t *)((unsigned long)x))

#define TO_BLOCK(ptr) ((void *) ((char *)ptr -PADDING))

#define MEM_SIZE ((size_t)dseg_hi + 1 - (size_t)dseg_lo)

static void view_heap(char * str) {
  void *ptr;
  int freeBlocks;
  int allocBlocks;
  freeBlocks = allocBlocks = 0;
  fprintf(stdout, "viewing heap at event: \"%s\"\n",str);  
  for(ptr = dseg_lo; (char *)ptr < (char *)dseg_hi; ptr = NEXT_BLOCK(ptr)) {
    fprintf(stdout,"%s block of size %lx starting at %lx\n",
	    (BLOCK_STATUS(ptr) == FREE? "---FREE---":"-ALLOCATED-"),
	    (unsigned long)BLOCK_SIZE(ptr),(unsigned long)ptr);
    if(BLOCK_STATUS(ptr) == FREE) freeBlocks++; else allocBlocks++;
    if(BLOCK_SIZE(ptr) == 0)
      break;
  }
  fprintf(stdout,"%d free blocks , %d allocated blocks\n",freeBlocks, allocBlocks);
  fprintf(stdout,"dseg_lo is %lx, dseg_hi is %lx\n", (unsigned long)dseg_lo,
	  (unsigned long)dseg_hi);
  fprintf(stdout, "### END OF HEAP ####\n");
}

int mm_init (void)
{
  if (MEM_SIZE < mem_pagesize()) {
    mem_sbrk(4*mem_pagesize());
  }
  *((size_t *)dseg_lo) = 0;  /* free with no previous block */
  *((size_t *)dseg_lo +1) = dseg_hi - dseg_lo+1;
  
  return 0;
}

static void *splitBlock(void * ptr, size_t size) {
  void * nxtPtr;
  size_t currSize;

  /*  if(size < 16) {
      fprintf(stdout, "here is your problem\n");
      yow();
      return ptr;
      } */

  if((size & STATUS_MASK) != 0)
    fprintf(stdout,"split passed a non-aligned size, %lx \n", size);
  if(BLOCK_STATUS(ptr) != FREE) {
    fprintf(stdout,"tried to split allocated block\n");
    return NULL;
  }


  
  currSize = BLOCK_SIZE(ptr);
  if(currSize-size-PADDING < 16)
    return ptr;
  if(currSize > (size_t)dseg_lo)
    yow();
  *((size_t *) ptr + 1) = size+PADDING;
  nxtPtr = NEXT_BLOCK(ptr);
  *((void **)nxtPtr) = ptr; /* set previous pointer */
  *((size_t *)nxtPtr +1) = currSize - size - PADDING; /* set pointer to end of 
							 block */
  ptr = nxtPtr;
  nxtPtr = NEXT_BLOCK(ptr);
  if((char *)nxtPtr > (char *)dseg_hi+1) { 
    printf("oops, bug\n");
    yow();
  }
  else
    *((void **) nxtPtr) = (void *)((long)ptr + 
				   (7L & (*((long *)nxtPtr))));

#ifdef DEBUG_2
  if((unsigned long)ptr & STATUS_MASK) 
    fprintf(stdout, "split a non-aligned block at %lx\n",(unsigned long)ptr);
  if((unsigned long)nxtPtr & STATUS_MASK) {
    fprintf(stdout, "split created a non-aligned block at %lx\n",
	    (unsigned long)nxtPtr);
    fprintf(stdout,"size = %lx, currsize = %lx, split block to %lx\n",
	    size, currSize, currSize -size - PADDING);
  }
#endif

  /*   aaaaa
       if(NEXT_BLOCK(PREV_BLOCK(ptr)) != PREV_BLOCK(NEXT_BLOCK(ptr)) ||
       NEXT_BLOCK(PREV_BLOCK(ptr)) != ptr) {
       fprintf(stdout,"oops, NEXT and PREV break after the coallesce\n");
       fprintf(stdout,"NEXT_BLOCK(ptr == %lx\n",(unsigned long)
       (NEXT_BLOCK(ptr)));
       fprintf(stdout, "PREV_BLOCK(ptr) == %lx\n",(unsigned long)
       (PREV_BLOCK(ptr)));
       fprintf(stdout, "NEXT_BLOCK(PREV_BLOCK(ptr)) == %lx\n",
       (unsigned long)NEXT_BLOCK(PREV_BLOCK(ptr)));
       fprintf(stdout, "PREV_BLOCK(NEXT_BLOCK(ptr)) == %lx\n",
       (unsigned long)PREV_BLOCK(NEXT_BLOCK(ptr)));
       fprintf(stdout, "ptr == %lx\n", (unsigned long)ptr);
       
       } */

  return nxtPtr;
}

void *mm_malloc (size_t size)
{
  /* damn, this could be REALLY sped up 
     by factoring out common sub-expressions */
  void * ptr;
  void * lastPtr;

  if(size == 0) return NULL;

#ifdef DEBUG
  fprintf(stdout, "mallocing a block of size %lx\n",(unsigned long)size);
#endif

  //  view_heap("malloc started");

  if((size & STATUS_MASK) != (size % 8))
    fprintf(stdout,"camille was right\n");
  
  if((size & STATUS_MASK) != 0) {
    size &= ~7L;
    size += 8L;

  }



  //  size += 8;

  for(ptr = dseg_lo; (char *)ptr < (char *)dseg_hi; ptr = NEXT_BLOCK(ptr)) {
#ifdef DEBUG_2
    if(((unsigned long)ptr & STATUS_MASK) != 0)
      fprintf(stdout,"misaligned block at address %lx\n",(unsigned long)ptr);
#endif
    if((BLOCK_STATUS(ptr) == FREE) &&(BLOCK_SIZE(ptr) > size+PADDING)) 
      break;
    lastPtr = ptr;
  }
  /* 
     if(((char *)ptr < (char *) dseg_hi) && (BLOCK_SIZE(ptr) == 0)) {
     fprintf(stdout,"found a sizeless pointer\n");
     } */
  if ((char *)ptr >= (char *)dseg_hi ) {

#ifdef DEBUG
    view_heap("about to mem_sbrk");
#endif
#ifdef DEBUG_2
    //    printf("about to mem_sbrk\n");
#endif 

    
    if((ptr = mem_sbrk((size+PADDING)))) {
      //      ptr = NEXT_BLOCK(lastPtr);

      *( (void **)ptr) = lastPtr;
      *( (size_t *)ptr +1) = (size+PADDING);
      /*
	if(NEXT_BLOCK(NEXT_BLOCK(PREV_BLOCK(ptr))) != (void *)((char *)dseg_hi +1))
	fprintf(stdout, "OK, that was wrong\n");
	if(NEXT_BLOCK(PREV_BLOCK(ptr)) != ptr) 
	fprintf(stdout, "that was also wrong\n");
      */

      /*      fprintf(stdout,"%lx should be one less than %lx\n", (unsigned long)dseg_hi,
	      (unsigned long)NEXT_BLOCK(ptr));  */

#ifdef DEBUG
      view_heap("mem_sbrk completed");
#endif

    } else {
      return NULL;
    }
  }
  if(BLOCK_STATUS(ptr) != FREE) {
    fprintf(stdout,"tried allocating a free block\n");
    return NULL;
  }
  splitBlock(ptr, size);
  *((unsigned long *) ptr) |= ALLOC;
  if((unsigned long)ptr == 0x14001e868) {
    fprintf(stderr,"allocating it\n");
    // view_heap("_THAT_ block");
    // yow();
  }
  //  view_heap("malloc completed");
  return ((void *)((char *)ptr+PADDING));
}

void mm_free (void *ptr)
{
  void * blockPtr;
  void * prevBlock;
  void * nextBlock;
  char coallesce;

  blockPtr = TO_BLOCK(ptr);

#ifdef DEBUG
  if((char *)blockPtr + PADDING != (char *)ptr)
    fprintf(stdout,"block %lx does not contain pointer %lx\n",
	    (unsigned long)blockPtr, (unsigned long)ptr);
  //if((unsigned long)ptr == 0x14001e878)
  // fprintf(stdout,"freeing %lx\n",(unsigned long)ptr);

#endif

  

  *((size_t *)blockPtr) &= ~7L;
  coallesce = 0;
  // while(coallesce != 3) {
  //  coallesce = 0;
  // do some coallescing
  prevBlock = PREV_BLOCK(blockPtr);
  if(((char *)prevBlock >= (char *)dseg_lo) &&
     (char *)prevBlock < (char *) dseg_hi &&
     BLOCK_STATUS(prevBlock) == FREE) {
    //    printf("coallescing\n");
    //    view_heap("coallescing");
    
    // BLOCK_TAG(prevBlock) = BLOCK_TAG(prevBlock) + BLOCK_TAG(blockPtr);
    *((size_t *)prevBlock+1) = *((size_t *)prevBlock+1) + 
      *((size_t *)blockPtr+1);
    nextBlock = NEXT_BLOCK(blockPtr);
    blockPtr = prevBlock;
    *((void **) nextBlock) = (void *)((long)blockPtr + 
				      (7L & (*((long *)nextBlock))));
    
    //    view_heap("coallesced");
      
  }// else 
  //coallesce += 1;
  nextBlock = NEXT_BLOCK(blockPtr);
  if(((char *)nextBlock < (char *)dseg_hi) && 
     BLOCK_STATUS(nextBlock) == FREE) {
    // BLOCK_TAG(blockPtr) = BLOCK_TAG(blockPtr) + BLOCK_TAG(nextBlock);
    *((size_t *)blockPtr +1) = *((size_t *)blockPtr + 1) +
      *((size_t *)nextBlock +1);
    nextBlock = NEXT_BLOCK(nextBlock);
    *((void **)nextBlock) = (void *)(blockPtr + 
				     (7L &(*((unsigned long *)nextBlock))));
  }// else
  // coallesce += 2;
  
  


}

