/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

typedef struct{
  long size; /* keep in mind that least bit is the allocated bit */
  struct block_t *next;
  struct block_t *prev;
} block_t;

/* Linked-list of free lists, in ascending order by size */
typedef struct {
  long  size; /* Size of the free spaces on the list */
  block_t *head; /* Pointer to first free block with size */
  struct freelist_t *next; /* Pointer to the next higher list */
  struct freelist_t *prev;
} freelist_t;

team_t team = {
    /* Team name to be displayed on webpage */
    "Crack",
    /* First member full name */
    "Joel Young",
    /* First member email address */
    "reverie@cmu.edu",
    /* Second member full name (leave blank if none) */
    "Vanessa Ou",
    /* Second member email address (blank if none) */
    "yuanwei@andrew.cmu.edu"
};

#define FREELIST_HEAD ((freelist_t *)(dseg_lo))
#define BLOCK_HEAD ((block_t *)(dseg_lo + 32))
/* use piece of freelist_head that should never be touched */
/*#define BLOCK_TAIL ((block_t **)(dseg_lo + 24));*/

block_t *block_tail;


void *mem_sbrk2(long int increment){
  printf("Calling for %ld bytes\n", increment);
  return mem_sbrk(increment);
}


/* returns pointer to smallest free block >= size, else NULL */
block_t *smallest_gt(size_t size, freelist_t *flist){
  if (flist == NULL) return NULL;
  else if (flist->size >= size && flist->head) return flist->head;
  else if (flist->next) return smallest_gt(size, flist->next);
  else return NULL;
}


/* Adds a free block to the head of the appropriate freelist, 
   creating and inserting a new one if needed.
   Will return NULL if there's not enough memory to add a new
   freelist_t (i.e., if mem_sbrk returns NULL). */
block_t *add_to_freelist(block_t *fb)
{
  freelist_t *tmp = FREELIST_HEAD;
  freelist_t *tmp2;
  /*  freelist_t *block_tail = *BLOCK_TAIL;*/

  if (tmp){
    if (tmp->head->size <= fb->size){
      while (tmp2 = tmp->next && tmp2->head &&
	     tmp2->head->size <= fb->size){
	tmp = tmp->next;
      }
    }
    if (tmp->size == fb->size){
      fb->next = tmp->head;
      tmp->head = fb;
    }
    else{
      if (block_tail->size < 6){
	tmp2 = block_tail;
	tmp2->next = tmp->next;
	tmp2->head = fb;
	tmp->next = tmp2;
	
	block_tail = mem_sbrk(8192);
	if (block_tail == NULL) return NULL;
	block_tail->size = 8192/8;
	*((long *)block_tail + 8192/8 - 1) = 8192/8;
      }
    }
  }
  else tmp->head = fb;
  return fb;
}

int mm_init (void)
{
  freelist_t *freelist_head = FREELIST_HEAD;
  block_t *block_head = BLOCK_HEAD;
  
  mem_sbrk(8192);

  /* don't count the last block as a free block */
  freelist_head->prev = freelist_head->next = NULL;
  freelist_head->head = NULL;
  freelist_head->size = 4;

  /* all of the page except the first 3 words */
  block_tail = (long *)block_head;
  block_tail->size = 8192/8 - 4;

  return 0;

}

void *mm_malloc (size_t size)
{
  long newmem;
  block_t *tmp;
  freelist_t *freelist_head = FREELIST_HEAD;
  block_t *block_head = BLOCK_HEAD;
  block_t *best_fit, *tmpb;
  
  /* size blocks at header and footer */
  size += 2;
  /* adjust size up to a multiple of 4 */
  if (size % 4) size += 4 - size % 4;

  /* look for smallest free block <= size */
  best_fit = /*(freelist_head->size && freelist_head->head ? */
	      smallest_gt(size, freelist_head);
  /*NULL); */
  /* if it exists */
  if (best_fit){
    /* take it out of freelist */
    tmpb = best_fit->prev;
    tmpb->next = best_fit->next;
    
    /* if there will be space at the end */
    if (best_fit->size > size){
      /* Point tmp to free space after block */
      tmp = (long *)best_fit + size;
      /* set size blocks of new space */
      tmp->size = *((long *)tmp + best_fit->size-size) = best_fit->size - size;
      /* add tmp to the end of the appropriate free list */
      tmp->next = NULL;
      if (!add_to_freelist(tmp)) return NULL;
    }
    /* change both size blocks and allocated bit */
    *((long *)best_fit + size - 1) = size;
    best_fit->size = size+1;
  }
  else{
    /* if blocktail is a free block and is large enough */
    if (!(block_tail->size % 2) && block_tail->size >= size){
      /* set return val to blocktail */
      best_fit = block_tail;
      /* if it's too big */
      if (best_fit->size > size){
	/* move block_tail over */
	block_tail = (long *)best_fit+size;
	block_tail->size = size - best_fit->size;
      }
    }
    else{
      /* calculate memory required */
      newmem = (block_tail->size & 1 ?
		(size/(8192/8) + 1) * (8192/8) :
		((size-block_tail->size)/(8192/8) + 1) * (8192/8));
      /* if memory is there */
      if (best_fit = mem_sbrk(newmem*8)){
	/* if blocktail is allocated */
	if ((block_tail->size) & 1){
	  /* if there's space  left over */
	  if (newmem > size){
	    /* move it to the end of newly allocated */
	    block_tail = (long*)best_fit + size;
	    block_tail->size = newmem - size;
	  }
	  else{
	    /* move it to beginning */
	    block_tail = best_fit;
	  }
	}
	else {
	  /* move return pointer into position */
	  best_fit = block_tail;
	  /* if there's a free space at the end */
	  if (size < newmem + block_tail->size){
	    /* move blocktail over */
	    block_tail = (long*)best_fit + size;
	    /* remember that best_fit->size is still old block_tail->size */
	    block_tail->size = newmem - size + best_fit->size;
	  }
	}
      }
      else return NULL;
    }
    /* set size blocks and allocation flag */
    best_fit->size = *((long*)best_fit + size-1) = size;
    best_fit->size++;
  }
  /* return pointer to word *after the size block */
  return (long*)best_fit + 1;
}


void mm_free (void *ptr)
{
  block_t *tmp;
  block_t *nextb, *prevb;
  block_t *pt = ptr;

  /*if pt is actually allocated (according to bit pattern) */
  if (pt->size & 1){
    /* change allocated bit */
    pt->size--;

    /* if nextblock is free */
    nextb = (long*)pt + pt->size;
    if (!(nextb->size & 1)){
      /* remove nextblock from its list */
      tmp = nextb->prev;
      tmp->next = nextb->next;
      /* change size of ptr */
      pt->size = *((long*)pt + pt->size) = pt->size + nextb->size;
    }
    /*if prevblock is free*/
    prevb = (long*)pt - *((long*)pt-1);
    if (!(prevb->size & 1)){
      /* remove prevblock from its list */
      tmp = prevb->prev;
      tmp->next = prevb->next;
      /* change size of prevblock */
      prevb->size = *((long*)prevb + prevb->size) = 
	prevb->size + pt->size;
      /* set ptr to prevblock */
      pt = prevb;
    }
    /* add ptr to end of appropriate freelist */
    add_to_freelist(pt);
  }
}

