/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define INTPTR(x) (*(((long*)dseg_lo + x))) /*simplifies heap access, 
					  x is the offset*/
#define BAB 8L; /* Bits A Bite */

#define M 20  /* "registry" size */

#define N(x) x & (~1) /* mascs out the free switch bit */

team_t team = {
    /* Team name to be displayed on webpage */
    "CS #$*@% $&#%",
    /* First member full name */
    "Daniel Shaykevich",
    /* First member email address */
    "dan2@andrew.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


int mm_init (void)
{
  int i;
  if ( mem_sbrk(mem_pagesize()) == NULL)
    return -1;

  for (i=0; i<=M; i++)
    INTPTR(i) = 0L;

  printf("\nINIT FINISHED\n");
  return 0;

}

void *mm_malloc (size_t size)
{
  long i;
  long j;
  long temp;
  long temp2;
  long next;
  long k;

  printf("\nMALLOC CALLED, size is %x\n", size);
  if (!size)
    return NULL;
  /* add 2 words to size to compensate for padding */
  size = size + 16; 
  /* round size to nearest power of 2 */
  i = 0;
  while (( 1L << i ) < size)
    i++;
  size = (1L << i);
  printf("Size rounded up to %x\n", size);
  for (j = i; j <= M; j++)
    {
      temp2 = INTPTR(j);
      printf(" p: %x ", temp2);
      if (INTPTR(j) != 0L)
	//allocate the block
	{
	  /* remove free flag */
	  temp = INTPTR(j);
	  INTPTR(j) = N(temp);
	  /* save the next address in linked list */
	  temp = INTPTR(j);
	  temp = temp + (1L << j) - 1L; //BAB?;
	  next = INTPTR(temp);
	  {
	    k = j;
	    while (k>i)
	      {
		//add buddy to appropriate free list, add flag
		temp = INTPTR(k) + (1L << k) - 1;
		INTPTR(temp) = INTPTR(k / 2);
		temp = (INTPTR(k) + (1 << (k-1)));
		INTPTR(k / 2) = INTPTR(temp);
		k--;//add size
	      }  
	    

	    //remove block from free list
	    INTPTR(j) = next; 
	    printf("\nABOUT TO SUCCESSFULLY EXIT\n");
	    return ((long *)dseg_lo + j + 1L);//8L?
	  }
	}	
    }
  for (i=0; i<=M; i++)
    printf(" %d", INTPTR(i));
  /* allocate more heap */
 
  /*double heap size */
  mem_sbrk(mem_usage()+1);
  /*add new block to the registry */
  
  /*set the pointer of the block to the top of the linked list */
  temp = (((mem_usage() + 1) >> 3 ) - 1);// pointer off new block  
  temp2 = ((mem_usage() + 1) >> 4); // size of block

  printf("\nsize of block is %x, pointer is %x", temp2, temp);

  i = 1;
  while (( 1L << i ) !=  temp2)
    i++;
  printf(" i is %x ",i);
  
  
  INTPTR(temp) = INTPTR(i); 
  printf("\ntemp2 is %x  temp is %x\n", INTPTR(temp), INTPTR(temp2));

  /*make the head of the list point to the new block */;
  //printf("\ntemp2 is %x  temp is %x\n", temp2, temp);
  INTPTR(i) = INTPTR(temp2);
  //printf("\ntemp2 is %x  temp is %x\n", temp2, temp);
  /* set the first word to the size of the block*/
  INTPTR(temp2) = temp2;

  printf("\ntemp2 is %x  temp is %x\n", INTPTR(temp), INTPTR(temp2));
  printf("\nRECURSIVE CALL:  mem_usage is now: %x\n", mem_usage());
  return mm_malloc(size-16);
}

void mm_free (void *ptr)
{
  long size;
  long buddy;
  long temp;
  /* adjust pointer so it points to begining of block */
  ptr = (long *)ptr - 1;
  /*set size to size of current block */
  size = *(long*)ptr;

  buddy = (long)ptr ^ size;

  while   ((INTPTR(buddy) & 1L) != 0L) // while buddy is free
    {
      /* remove buddy from free list */
      remove_block(size, (long)ptr);
      
      if ((long)ptr > buddy)
	ptr = (long*)buddy;
      /* double the size */
      size = size << 1;
      *(long*)ptr = size;
      
      buddy = (long)ptr ^ size;      
    }
  /*set the pointer of the block to the top of the linked list */
  temp = (long)ptr + size - BAB;
  INTPTR(temp) = INTPTR(size); 
  /*make the head of the list point to the new block */
  INTPTR(size) = (long)ptr;
  /* turn the free flag to on */
  *(long*)ptr = *(long*)ptr & 1L;
}
void remove_block(long size, long address)
{
	  long* current;
	  current = INTPTR(size);

	  while (*current != 0)
	    {
	      if (*current == address)
		{
		*current = INTPTR(address+size-8);
		return;
		}
	    current = INTPTR(*current+size - 8);
	    }

	} 
