/* $Id$ */

/*
 *  Papadimitriou Spiros
 *  spapadim+@cs.cmu.edu
 *
 *  CS213 - Lab assignment 3
 *
 */

//#define _DEBUG_

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

/* Custom Defnitions: */
#define false 0
#define true 1

#define xdseg_lo dseg_lo+6
#define xdseg_hi dseg_hi+1

team_t team = {
    /* Team name to be displayed on webpage */
    "Pinky and the Brain",
    /* First member full name */
    "Steve Schaffer",
    /* First member email address */
    "srs3",
    /* Second member full name (leave blank if none) */
    "Omari Teel",
    /* Second member email address (blank if none) */
    "odt"
};


//unsigned short sizeTo8( long n ) //computes the number of 8-byte blocks needed for size n
//{
//    return ((n-1) / 8)+1;
//}

#define sizeTo8(n) ((n-1) / 8)+1

//long sizeFrom8( long n ) //computes the number of bytes used my a n-block structure
//{
//    return n*8;
//}
#define sizeFrom8(n) (n*8) 

//int isAllocated( long controlPointer ) //returns true(1) if the structure is allocated, false(0) otherwise
//{
//    return (int)((*((unsigned short*)controlPointer))&1);
//}
#define isAllocated(x) ((int)((*((unsigned short*)x))&1))

unsigned short getSize8( long controlPointer ) //gets the size of the structure pointed to
{
    return ((*((unsigned short*)controlPointer))>>1)&(0x7fff);
}
//#define getSize8(x) (((*((unsigned short*)x))>>1)&(0x7fff))

void setSize8( long controlPointer, unsigned short size )//sets the size of the structure pointed to
{
    *((unsigned short*)(controlPointer)) = (size<<1)|isAllocated(controlPointer);
}

void setAllocated( long controlPointer, int allocatedBit ) //markes the structure as allocated or not (as allocatedBit)
{
    *((unsigned short*)(controlPointer)) =  (*((unsigned short*)(controlPointer))&0xfffe)|(allocatedBit);
}

//long sizeToPages( long size ) //converts a size to a nearest size in pages
//{
//	 return ((size-1) / mem_pagesize() ) + 1;	 
//}
#define sizeToPages(x) (((size-1) / mem_pagesize() ) + 1)



void coalescePair(long lo, long hi)  //coalesces a pair of structures (note assumptions)
//assume lo<hi, isAllocated(lo)|isAllocated(hi)=false
{
	 unsigned short loSize8, hiSize8;
	 
	 assert(lo<hi);

	 loSize8 = getSize8(lo);
	 hiSize8 = getSize8(hi);
	 
	 if( (hiSize8+loSize8)<32677 )
	 {
		  setSize8(hi-2,loSize8+hiSize8);
		  setSize8(lo,loSize8+hiSize8);
	 }
	 
}

void coalesce(long loc) //given a structure, checks if any coalescing can be done and calls the pairwise function
//isAllocated(loc)=false
{
	 long loPtr = loc;
    long  hiPtr;
	 hiPtr = loc+sizeFrom8(getSize8(loc));
	 if(!isAllocated(hiPtr)&&(hiPtr<(long)(xdseg_hi)))
	 {
		  coalescePair(loPtr,hiPtr);
	 }
	 hiPtr=loPtr;
	 if(loc-2>(long)(xdseg_lo))
	 {
		  loPtr = loc-sizeFrom8(getSize8(loc-2));
		  //assert(loPtr>dseg_lo);
		  if(loPtr>(long)dseg_lo)
		  {
		  if (!isAllocated(loPtr))
		  {
				coalescePair(loPtr,hiPtr);
		  }
		  }
		  
	 }
	 
}


int mm_init (void) //initializes the heap (allocate a few pages and setup first empty structure)
{
	 
	 if(!mem_sbrk(1*mem_pagesize()+6))
    {
		  return -1;
	 }
	 else
	 {
		  long hi,lo,memsize;
		  (*(long*)(dseg_lo))=0;

		  hi = (long)xdseg_hi;
		  //printf("hi = %d \n",hi);
		  lo = (long)xdseg_lo;
		  //printf("lo = %d \n",lo);
		  
		  memsize = hi-lo;
		  //printf("memsize = %d \n",memsize);
		  
		  setSize8(lo,sizeTo8(memsize));
		  setAllocated(lo,false);
		  setSize8(hi-2,sizeTo8(memsize));
		  setAllocated(hi-2,false);
		  
		  return 0;
	 }
	 
	 
}

void *mm_malloc (size_t size) //allocates room for a new structure (and gets more heap space if necissary) and relinks into implicit list. (note size constraint)
{
    unsigned short size8, blockSize8, leftover8, increment8;
    long loc, oldLoc, end, boundary, increment;
    void* addr=NULL;
	 
	 //(*(long*)(dseg_lo))+=1;
	 
	 
    size8 = sizeTo8( size+4 );

	 #ifdef _DEBUG_
	 printf("**Allocating #%i: %i -> %i bytes\n",(int)(*(long*)dseg_lo),(int)size,size8*8);
	 printf("TotalHeap: %f\n",(float)(xdseg_hi-xdseg_lo));
	 printf("LastBlock: %i\n",(int)(*((short*)((long)xdseg_hi-2))));
	 #endif

	 assert(size8<32767); //maximum size handled by 2-byte controls

    loc = (long)xdseg_lo;
	 oldLoc = 0;
    
	 while(true)
	 {

		 while(loc<(long)xdseg_hi)
		 {
			  blockSize8=getSize8(loc);
			  end = loc + sizeFrom8(blockSize8);
			  if((!isAllocated(loc))&&(blockSize8>=size8))
			  {
					boundary = loc + sizeFrom8(size8);
					leftover8 = blockSize8-size8;
					
					addr = (void*)loc;
					
					setSize8(loc,size8);
					setAllocated(loc,true);
					setSize8(boundary-2,size8);
					setAllocated(boundary-2,true);
					if( blockSize8 > size8 )
					{
						 setSize8(boundary,leftover8);
						 setAllocated(boundary,false);
						 setSize8(end-2,leftover8);
						 setAllocated(end-2,false); //redundant unless error
					}
					return addr+2;
			  }
			  oldLoc = loc;
			  loc = end;
		 }

		 loc = (long)xdseg_hi; //redundant unless error
		 increment = sizeToPages(size);
		 increment8 = sizeTo8(increment * mem_pagesize());
		 
		 if (!mem_sbrk(increment * mem_pagesize())) //null if no space, new hi if so
		 {
			  return NULL;
		 }
		 setSize8(loc,increment8); //mark the new page as a large free block
		 setAllocated(loc,false);
		 setSize8((long)xdseg_hi-2,increment8);
		 setAllocated((long)xdseg_hi-2,false);
		 
		 if(!isAllocated(oldLoc)) //and then try to mash with previous free blocks
		 {
			  coalescePair(oldLoc,loc);
			  loc=oldLoc;
			  oldLoc=NULL;
		 }
   }
}



void mm_free (void *ptr) //frees the structure pointed to by ptr and returns its blocks to free space for reallocation
{
	 long loc;
	 unsigned short size;

	 //(*(long*)(dseg_lo))+=1;
	 
	 loc = (long)ptr-2;//find position of the control bits

	 assert((loc<=(long)dseg_hi)); //make sure we can actually check around the block (we got a bad ptr if these fail)
	 assert((loc>=(long)dseg_lo));
	 assert(isAllocated((long)loc));
	 assert((sizeFrom8(getSize8(loc))+loc)<=(long)dseg_hi);

	 size = sizeFrom8(getSize8(loc));
	 #ifdef _DEBUG_
	 printf("##Unallocating #%i: %i bytes\n",(int)(*(long*)(dseg_lo)),(int)size);
	 #endif
	 
	 setAllocated(loc,false); //mark block as unallocated
	 setAllocated(loc+size-2,false);
	 coalesce(loc); //and try to mash it together with other free blocks adjacent
	 

}













